
CREATE TABLE SearchWords (
    WordId          INT NOT NULL AUTO_INCREMENT,
    WordText        TEXT,
    INDEX           (WordId)
);
CREATE TABLE SearchWordCounts (
    WordId          INT NOT NULL,
    ResourceId      INT NOT NULL,
    Count           INT,
    INDEX           (WordId, ResourceId)
);

ALTER TABLE ControlledNameTypes ADD ControlledNameIsList INT;

UPDATE ControlledNameTypes SET ControlledNameIsList = 0;
UPDATE ControlledNameTypes SET ControlledNameTypeName = 'Creator' WHERE ControlledNameTypeId = 1;
INSERT ControlledNameTypes SET ControlledNameTypeId = 3, ControlledNameTypeName = 'Contributor', ControlledNameIsList = 0;
INSERT ControlledNameTypes SET ControlledNameTypeId = 10, ControlledNameTypeName = 'ResourceType', ControlledNameIsList = 1;
INSERT ControlledNameTypes SET ControlledNameTypeId = 11, ControlledNameTypeName = 'Audience', ControlledNameIsList = 1;
INSERT ControlledNameTypes SET ControlledNameTypeId = 12, ControlledNameTypeName = 'Language', ControlledNameIsList = 1;
INSERT ControlledNameTypes SET ControlledNameTypeId = 13, ControlledNameTypeName = 'Format', ControlledNameIsList = 1;

INSERT ControlledNames (ControlledName, ControlledNameTypeId) VALUES ('Collection', 10),('Dataset',10), ('Event',10), ('Image', 10), ('Interactive Resource', 10), ('Service', 10), ('Software', 10), ('Sound', 10), ('Text', 10);
INSERT ControlledNames (ControlledName, ControlledNameTypeId) VALUES ('Elementary',11), ('Middle School', 11), ('High School',11), ('Undergraduate',11), ('Graduate', 11), ('Research',  11), ('Lifelong Learner',11);
INSERT ControlledNames (ControlledName, ControlledNameTypeId) VALUES ('English',12),('Arabic',12), ('Celtic',12),('Chinese',12),('Croatian',12),('Czech',12),('Danish',12),('Dutch',12),('Esperanto',12),('Finnish',12),('French',12),('German',12),('Hebrew',12),('Hungarian',12),('Icelandic',12),('Italian',12),('Korean',12),('Norwegian',12),('Persian',12),('Japanese',12),('Romanian',12),('Russian',12),('Spanish',12),('Swedish',12),('Thai',12),('Vietnamese',12);
INSERT ControlledNames (ControlledName, ControlledNameTypeId) VALUES ('plain', 13), ('richtext', 13),('enriched',13), ('tab-separated-values',13),('html',  13), ('sgml',13),('css',13),('xml',13),('rtf',13),('directory',13),('calendar',13);

ALTER TABLE Resources ADD AlternateTitle TEXT AFTER Title;
ALTER TABLE Resources CHANGE PublicationDate DateIssued DATE;
ALTER TABLE Resources CHANGE PublicationDateFormat DateIssuedFormat INT(11);
ALTER TABLE Resources CHANGE DateAdded DateOfRecordCreation DATETIME;
ALTER TABLE Resources CHANGE DateLastVerified DateRecordChecked DATETIME;
ALTER TABLE Resources ADD Source TEXT AFTER ReleaseFlag;
ALTER TABLE Resources ADD Relation TEXT AFTER Source;
ALTER TABLE Resources ADD Coverage TEXT AFTER Relation;
ALTER TABLE Resources ADD Rights TEXT AFTER Coverage;
ALTER TABLE Resources ADD EmailAddress TEXT AFTER Rights;

ALTER TABLE SystemConfiguration ADD ActiveUI TEXT;
UPDATE SystemConfiguration SET ActiveUI = 'SPTUI--Default';

ALTER TABLE Resources CHANGE DateIssuedFormat DateIssuedFormat TEXT;
ALTER TABLE Resources ADD DateIssuedAlternate DATE AFTER DateIssued;
UPDATE Resources SET DateIssuedFormat = 'YYYY-MM-DD';

INSERT ControlledNameTypes SET ControlledNameTypeId=4, ControlledNameTypeName='Subject', ControlledNameIsList = 0;

