ALTER TABLE SystemConfiguration ADD COLUMN NumResourcesOnHomePage int DEFAULT 5;
ALTER TABLE SystemConfiguration ADD COLUMN ResourceRatingsEnabled int DEFAULT 0;
ALTER TABLE SystemConfiguration ADD COLUMN ResourceCommentsEnabled int DEFAULT 0;

ALTER TABLE UserSearch ADD COLUMN AddedBy text;
ALTER TABLE UserSearch ADD COLUMN ReleaseFlag int;

ALTER TABLE Resources ADD COLUMN TempResourceId int;

UPDATE MetadataFields SET FieldName = "Release Flag" WHERE FieldName = "ReleaseFlag";
UPDATE MetadataFields SET FieldName = "Added By Id" WHERE FieldName = "AddedById";
UPDATE MetadataFields SET FieldName = "Last Modified By Id" WHERE FieldName = "LastModifiedById";
UPDATE MetadataFields SET FieldName = "Date Issued" WHERE FieldName = "DateIssued";
UPDATE MetadataFields SET FieldName = "Alternate Title" WHERE FieldName = "AlternateTitle";
UPDATE MetadataFields SET FieldName = "Email Address" WHERE FieldName = "EmailAddress";
UPDATE MetadataFields SET FieldName = "Date Of Record Creation" WHERE FieldName = "DateOfRecordCreation";
UPDATE MetadataFields SET FieldName = "Date Record Checked" WHERE FieldName = "DateRecordChecked";
UPDATE MetadataFields SET FieldName = "Date Last Modified" WHERE FieldName = "DateLastModified";
UPDATE MetadataFields SET FieldName = "Verification Attempts" WHERE FieldName = "VerificationAttempts";
UPDATE MetadataFields SET FieldName = "Resource Type" WHERE FieldName = "ResourceType";
UPDATE MetadataFields SET FieldName = "Cumulative Rating" WHERE FieldName = "CumulativeRating";
UPDATE ControlledNameTypes SET ControlledNameTypeName = "Resource Type" WHERE ControlledNameTypeName = "ResourceType";

-- OAI fields for SystemConfiguration
ALTER TABLE SystemConfiguration ADD COLUMN OaiIdDomain TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN OaiIdPrefix TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN OaiEarliestDate TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN OaiDateGranularity ENUM("DATE", "DATETIME");

-- OAI formats table 
CREATE TABLE OAIFormats(
    FormatId        INT NOT NULL AUTO_INCREMENT,
    FormatName      TEXT,
    TagName         TEXT,
    SchemaLocation  TEXT,
    INDEX           (FormatId)
);

INSERT INTO OAIFormats SET FormatName = "oai_dc", TagName = "oai_dc:dc", SchemaLocation = "http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd";

-- OAI format namespaces table
CREATE TABLE OAIFormatNamespaces(
    FormatId        INT NOT NULL,
    NamespaceName   TEXT,
    NamespaceURI    TEXT,
    INDEX           (FormatId)
);

INSERT INTO OAIFormatNamespaces SET FormatId = "1", NamespaceName = "oai_dc", NamespaceURI = "http://www.openarchives.org/OAI/2.0/oai_dc/";
INSERT INTO OAIFormatNamespaces SET FormatId = "1", NamespaceName = "dc", NamespaceURI = "http://purl.org/dc/elements/1.1/";

-- OAI field mappings table 
CREATE TABLE OAIFieldMappings(
    OAIFieldMappingId   INT NOT NULL AUTO_INCREMENT,
    FormatId            INT NOT NULL,
    SPTFieldId          INT NOT NULL,
    OAIFieldName        TEXT,
    INDEX               (OAIFieldMappingId, FormatId, SPTFieldId)
);

INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "1", OAIFieldName = "dc:title";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "20", OAIFieldName = "dc:creator";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "22", OAIFieldName = "dc:subject";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "3", OAIFieldName = "dc:description";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "19", OAIFieldName = "dc:publisher";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "21", OAIFieldName = "dc:contributor";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "11", OAIFieldName = "dc:date";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "23", OAIFieldName = "dc:type";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "26", OAIFieldName = "dc:format";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "4", OAIFieldName = "dc:identifier";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "6", OAIFieldName = "dc:source";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "24", OAIFieldName = "dc:language";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "7", OAIFieldName = "dc:relation";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "8", OAIFieldName = "dc:coverage";
INSERT INTO OAIFieldMappings SET FormatId = "1", SPTFieldId = "9", OAIFieldName = "dc:rights";

