// !!! YOU MUST INCLUDE THE jQUERY LIBRARY ALONG WITH THIS FILE !!!!
/*
#   Common functions
#
#   FUNCTIONS PROVIDED:
#       ToggleDisplay
#           - Toggles an element's display, saves previous display
#       ToggleText
#           - Toggles an element's HTML, saves previous HTML
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
*/

function jQuery_ToggleDisplay(Element, DefaultDisplay){
    DefaultDisplay = DefaultDisplay || "block";
    if ($(Element).css("display") == "none"){
        if ($(Element).attr("display") !== undefined){
            $(Element).css({ display: unescape($(Element).attr("display")) });
            $(Element).removeAttr("display");
        } else {
            $(Element).css({ display: DefaultDisplay });
        }
    } else {
        $(Element).attr({ display: escape($(Element).css("display")) });
        $(Element).css({ display: "none" });
    }
}

function jQuery_ToggleText(Element, SecondText){         
    if ($(Element).attr("origtext") !== undefined){
        $(Element).html(unescape($(Element).attr("origtext")));
        $(Element).removeAttr("origtext");
    } else {
        $(Element).attr({ origtext: escape($(Element).html()) });
        $(Element).html(SecondText);
    }
}

/*
#   Common DOM functions
#
#   FUNCTIONS PROVIDED:
#       GetElement(Identifier)
#           - Gets the element with identfier "Identifier"
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
*/

function jQuery_GetElement(Identifier){
    return $(Identifier).get(0);
}