/*
#   Common MetaData tool functions
#
#   FUNCTIONS PROVIDED:
#       CheckAdd(Form, Field, FieldNum)
#           - Performs some checks and calls PrintMenu
#       PrintMenu(Form, Field)
#           - Makes the next option menu visible and populates it with values
#       SubmitForm(SubmitVal)
#           - Used to submit a form using a text link. SubmitVal becomes the
#             value of a field called HiddenSubmit
#
#   FORM FIELDS EXPECTED:
#       HiddenSubmit
#           - Must be present if SubmitForm is used
#
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
*/
function CheckAdd(Form, Field, FieldNum)
{
    with (Form)
    {
        // Get the current value
        FieldHidden = GetElement(Field + "Hidden");
        
        //Check if this is the most recently added select menu
        if (FieldHidden.value == FieldNum)
        {
            PrintMenu(Form, Field);
        }
        else
        {
            return false;
        }
    }
}

function PrintMenu(Form, Field)
{
    with (Form)
    {
        // Get the value for the next field to be displayed
        FieldHidden = GetElement(Field + "Hidden");
        FieldHidden.value = parseInt(FieldHidden.value) + 1;
        
        // Handle too many additions
        if (FieldHidden.value > 21)
        {
            return false;
        }
        else if (FieldHidden.value == 21)
        {
            FieldButton = GetElement(Field + "Add");
            HideElement(FieldButton);
        }

        // make the field visible
        FieldBase = Field;
        Field = GetElement(Field + FieldHidden.value);
        ShowElement(Field);
        
        //Adjust the width of the field
        if (GetElement(FieldBase + "1"))
        {
            FirstField = GetElement(FieldBase + "1");
        }
        else
        {
            FirstField = GetElement(FieldBase);
        }
        Field.style.width = FirstField.style.width;

        // call the corresponding javascript function
        eval("Print"+FieldBase+"Options(Form, Field);");
    }
}

function SubmitForm(SubmitVal)
{
    SubmitButton = document.dbentry.HiddenSubmit;
    SubmitButton.value = SubmitVal;
    document.dbentry.submit();
}