<?PHP

PageTitle("Plugin Configuration");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

$PluginName = isset($_GET["PN"]) ? $_GET["PN"] : NULL;
$G_Plugin = $G_PluginManager->GetPlugin($PluginName);

if ($G_Plugin && isset($_POST["Submit"]))
{
    if ($_POST["Submit"] == "Save Changes")
    {
        $Attribs = $G_Plugin->GetAttributes();
        foreach ($Attribs["CfgSetup"] as $Name => $Params)
        {
            $FieldName = "F_".preg_replace("/[^a-zA-Z0-9]/", "", $Name);
            switch ($Params["Type"])
            {
                case "Flag":
                    if (isset($_POST[$FieldName]))
                    {
                        $G_Plugin->ConfigSetting($Name, 
                                ($_POST[$FieldName] == "1") ? TRUE : FALSE);
                    }
                    break;

                default:
                    if (isset($_POST[$FieldName]))
                    {
                        $G_Plugin->ConfigSetting($Name, $_POST[$FieldName]);
                    }
                    break;
            }
        }
    }
    $AF->SetJumpToPage("Plugins");
}

?>
