<?PHP
#
#   FILE:  SavedSearch.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

if (!CheckAuthorization()) {  return;  }
PageTitle("Manage Saved Searches");

include_once("lib/AxisPHP/Axis--StandardLibrary.php");  # (for PrintOptionList())

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSavedSearches()
{
    global $SysConfig;
    global $User;
    $Searches = GetSavedSearchesForUser($User->Id());
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SavedSearch::SEARCHFREQ_HOURLY);
    }

    # if no saved searches found
    if (count($Searches) == 0)
    {
        # add message indicating no saved searches
    ?>
    <tr valign="top">
        <td colspan="4">
            There are no searches currently saved.<br>
        You can enter and save a search via the <a href="index.php?P=Advanced">Advanced Search</a> page.</td>
    </tr>
    <?PHP
    }
    else
    {
        # add table row for each saved search
        foreach ($Searches as $SearchId => $Search)
        {
            ?>

            <tr valign="top">
                <th align="left"><div style="margin-top: 5px;"
                ><a href="index.php?P=AdvancedSearch&amp;Q=Y&amp;<?PHP
                   print $Search->GetSearchGroupsAsUrlParameters();?>"
                ><?PHP  print($Search->SearchName());  ?></a></div></th>
                <td><div class="editbutton" style="float: left;">
                <a href="index.php?P=Advanced&amp;SI=<?PHP
                   print($SearchId);  ?>">Edit</a>
            </div></td>
                <td><div class="editbutton" style="float: left;">
                <a href="index.php?P=SavedSearch&amp;AC=Delete&amp;SI=<?PHP
                         print($SearchId);  ?>">Delete</a>
            </div></td>

            <?PHP  if ($SysConfig->UserAgentsEnabled()) {  ?>
                <td><?PHP  PrintOptionList("F_Frequency_".$SearchId, $FreqList, $Search->Frequency(), TRUE);  ?></td>
                <?PHP  }  ?>

                <td><div style="margin-top: 5px;"><?PHP  print($Search->GetSearchGroupsAsTextDescription(NULL, TRUE, FALSE));  ?></div></td>
            </tr>

        <?PHP
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# if user asked to save new search
if (isset($_POST["Submit"]) && $_POST["Submit"] == "Save")
{
    # if reasonable search name was supplied
    if (isset($_POST["F_SearchName"]) && strlen(trim($_POST["F_SearchName"])))
    {
        # save search
        $NewSavedSearch = new SavedSearch(NULL, $_POST["F_SearchName"],
                $User->Id(), SavedSearch::SEARCHFREQ_NEVER,
                SavedSearch::TranslateUrlParametersToSearchGroups($_GET));
    }
    else
    {
        # set error message and return back to new saved search page
        $ErrorMessage = "ERROR: No name was supplied for the saved search.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        $SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);
        $SearchGroupsForUrl = SavedSearch::TranslateSearchGroupsToUrlParameters($SearchGroups);
        $AF->SetJumpToPage("NewSavedSearch&".$SearchGroupsForUrl);
        return;
    }
}

# else if user asked to delete search
elseif (isset($_GET["AC"]) && ($_GET["AC"] == "Delete"))
{
    # delete specified search
    $Search = new SavedSearch($_GET["SI"]);
    $Search->Delete();
}

# else if user asked to change search frequency
elseif (isset($_POST["AC"]) && ($_POST["AC"] == "ChangeFrequency"))
{
    # for each saved search
    $Searches = GetSavedSearchesForUser($User->Id());
    foreach ($Searches as $Search)
    {
        # if frequency has changed
        if (isset($_POST["F_Frequency_".$Search->GetSearchId()])
                && ($_POST["F_Frequency_".$Search->GetSearchId()] != $Search->Frequency()))
        {
            # update frequency
            $Search->Frequency($_POST["F_Frequency_".$Search->GetSearchId()]);
        }
    }
}
