<?PHP
#
#   FILE:  ConfirmAutofix.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   Copyright 2010 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm an automatic fix to an URL");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = isset($_GET["ResourceId"]) ? intval($_GET["ResourceId"]) : NULL;
$FieldId = isset($_GET["FieldId"]) ? intval($_GET["FieldId"]) : NULL;
$Resource = new Resource($ResourceId);
$Schema = new MetadataSchema();
$Field = $Schema->GetField($FieldId);
$TitleField = $Schema->GetFieldByMappedName("Title");
$DescriptionField = $Schema->GetFieldByMappedName("Description");

if ($Resource->Status() == 1 && $Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    $InvalidUrl = $AF->SignalEvent("URLCHECKER_GET_INVALID_URL", array($Resource, $Field));
}

else
{
    $AF->SuppressHTMLOutput();
    $AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
}

?>
