<?php
#
#   FILE:  SPT--DBConfirmDeleteField.php
#
#   FUNCTIONS PROVIDED:
#       PrintFieldName()
#       - print field name
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print out field name
function PrintFieldName()
{
    $F_FieldName = StripXSSThreats($_GET["F_FieldName"]);
    print $F_FieldName;
}

# see if this is the last tree field
function IsLastTreeField()
{
    $F_FieldName = StripXSSThreats($_GET["F_FieldName"]);
    
    $Schema = new MetadataSchema();
    $Field = $Schema->GetFieldByName($F_FieldName);
    
    if ($Field->Type() & MetadataSchema::MDFTYPE_TREE)
    {
        $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TREE);
        if (count($Fields) == 1)
            return TRUE;
    }
    return FALSE; 
}

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }


$F_FieldId = intval( $_GET["F_FieldId"] );

PageTitle("Confirm Delete Database Field");

$Schema = new MetadataSchema();
if ($Schema->GetFieldByName($_GET["F_FieldName"]) === NULL)
{
    print("ERROR: No such field");
    exit;
}

?>
