<?PHP

# determine if resource matches user's accessibility preferences (returns empty string if not)
function GetAccessMatchText($Resource, $Schema, $User)
{
    static $UserPrefMethods = array(
        "Colors Avoided"     => "PrefColorAvoidanceFlags",
        "Text Captioning"    => "PrefCaptionType",
        "Audio Descriptions" => "PrefAudioDescriptionLevel",
        "Content Type"       => "PrefContentView");

    static $AccessMatchMsgs = array(
        "Colors Avoided" => array(
        array(
            "Resource" => "Red",
            "User" => SPTUser::UIPREF_AVOID_RED,
        "Text" => "Resource avoids red text",
        ),
        array(
            "Resource" => "Red/Green",
            "User" => SPTUser::UIPREF_AVOID_REDGREEN,
        "Text" => "Resource avoids red/green text",
        ),
        array(
            "Resource" => "Blue/Yellow",
            "User" => SPTUser::UIPREF_AVOID_BLUEYELLOW,
        "Text" => "Resource avoids blue/yellow text",
        ),
        array(
            "Resource" => "Green/Yellow",
            "User" => SPTUser::UIPREF_AVOID_GREENYELLOW,
        "Text" => "Resource avoids green/yellow text",
        ),
        array(
            "Resource" => "Orange",
            "User" => SPTUser::UIPREF_AVOID_ORANGE,
        "Text" => "Resource avoids orange text",
        ),
        array(
            "Resource" => "Red/Black",
            "User" => SPTUser::UIPREF_AVOID_REDBLACK,
        "Text" => "Resource avoids red/black text",
        ),
        array(
            "Resource" => "Purple/Grey",
            "User" => SPTUser::UIPREF_AVOID_PURPLEGREY,
        "Text" => "Resource avoids purple/grey text",
        ),
        ),
        "Text Captioning" => array(
        array(
            "Resource" => "Verbatim",
            "User" => SPTUser::UIPREF_CAPTIONTYPE_VERBATIM,
        "Text" => "Resource offers verbatim text captioning",
        ),
        array(
            "Resource" => "Reduced Reading Level",
            "User" => SPTUser::UIPREF_CAPTIONTYPE_REDUCEDREADINGLEVEL,
        "Text" => "Resource offers reduced reading level text captioning",
        ),
        ),
        "Audio Descriptions" => array(
        array(
            "Resource" => "Standard",
            "User" => SPTUser::UIPREF_AUDIODESCRIPTION_STANDARD,
        "Text" => "Resource offers audio descriptions",
        ),
        array(
            "Resource" => "Expanded",
            "User" => SPTUser::UIPREF_AUDIODESCRIPTION_EXPANDED,
        "Text" => "Resource offers expanded audio descriptions",
        ),
        ),
        "Content Type" => array(
        array(
            "Resource" => "Text Intensive",
            "User" => SPTUser::UIPREF_CONTENTVIEW_TEXTINTENSIVE,
        "Text" => "Resource has text intensive content",
        ),
        array(
            "Resource" => "Image Intensive",
            "User" => SPTUser::UIPREF_CONTENTVIEW_IMAGEINTENSIVE,
        "Text" => "Resource has image intensive content",
        ),
        ),
    );

    # assume no access match will be found
    $AMText = "";

    # if we have a user to match
    if ($User->IsLoggedIn())
    {
        # for each access match type
        foreach ($UserPrefMethods as $ResourceFieldName => $UserMethodName)
        {
            # if user has expressed a preference for this match type
            $UserPref = $User->$UserMethodName();
            if ($UserPref)
            {
                # if resource field exists and is enabled/viewable
                $Field = $Schema->GetFieldByName($ResourceFieldName);
                if ($Resource->UserCanViewField($User, $Field))
                {
                    # for each possible match for field
                    $ResourceVals = $Resource->Get($ResourceFieldName);
                    foreach ($AccessMatchMsgs[$ResourceFieldName] as $MatchInfo)
                    {
                        # if user indicated this preference
                        if ($UserPref & $MatchInfo["User"])
                        {
                            # if resource matches this
                            if (in_array($MatchInfo["Resource"], $ResourceVals))
                            {
                                # add text for access match
                                $AMText .= $MatchInfo["Text"].".\n";
                            }
                        }
                    }
                }
            }
        }
    }

    # return access match text (if any) to caller
    return $AMText;
}
