<?php
#
#   FILE:  SPT--NewSavedSearch.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2005 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Save Search");

include_once("lib/AxisPHP/Axis--StandardLibrary.php");  # (for PrintOptionList())

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFrequencyOptionList()
{
    global $User;
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SavedSearch::SEARCHFREQ_HOURLY);
    }
    PrintOptionList("F_SearchFreq", $FreqList, SavedSearch::SEARCHFREQ_NEVER);
}

function PrintCriteria()
{
    global $SearchGroups;
    $CriteriaText = SavedSearch::GetSearchGroupsAsTextDescription($SearchGroups);
    print $CriteriaText;
}

function PrintFormUrl()
{
    global $SearchGroups;
    print("index.php?P=SavedSearch&amp;"
          .SavedSearch::TranslateSearchGroupsToUrlParameters($SearchGroups));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SearchGroups;

$SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);

?>
