<?PHP
#
#   FILE:  SPT--OAI.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none -- all field handling done by OAIServer object)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

header("Content-type: text/xml");
if (function_exists("Local_GetOAIRetrievalSearchParameters"))
{
    $RetrievalSearchParameters = Local_GetOAIRetrievalSearchParameters();
    $Server = new SPTOAIServer($RetrievalSearchParameters);
}
else
{
    $Server = new SPTOAIServer();
}

# log OAI request
$EventLog = new SPTEventLog();
$EventLog->Log(SptEventLog::SPTEVENT_OAIHARVEST,
        $_SERVER["REMOTE_ADDR"], $_SERVER["QUERY_STRING"]);

# signaling OAI-PMH request event (stripping P= page parameter out of GET string)
$QueryString = preg_replace(
        array("/&P=[a-zA-Z0-9_-]+[&]*/", "/^P=[a-zA-Z0-9_-]+[&]*/"), 
        array("&", ""), $_SERVER["QUERY_STRING"]);
$AF->SignalEvent("EVENT_OAIPMH_REQUEST", array(
        "RequesterIP" => $_SERVER["REMOTE_ADDR"], 
        "QueryString" => $QueryString));

print($Server->GetResponse());

# suppress any HTML output
$AF->SuppressHTMLOutput();

?>
