<?PHP

#
#   FILE:  SPT--AddClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintParentId()
#           - print ID of classification under which to add new classification
#       PrintLocation()
#           - print string with hierarchy above new classification
#       PrintFieldId()
#           - print the FieldId
#       PrintFieldName()
#           - print the Field name
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       ParentId
#           - ID of classification under which to add new classification 
#                   (-1 if add at top of hierarchy)
#       FieldId
#           - FieldId of classification type to be added
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print ID of classification under which to add new classification
function PrintParentId()
{
    global $ParentClass;
    print($ParentClass->Id());
}

# print string with hierarchy above new classification
function PrintLocation()
{
    global $ParentId;
    global $ParentClass;

    if ($ParentId == -1)
    {
        print("(top)");
    }
    else
    {
        print $ParentClass->FullName();
    }
}

# print the FieldId
function PrintFieldId()
{
    global $FieldId;

    print $FieldId;
}

# print the ClassTypeName
function PrintFieldName()
{
    global $FieldId;

    $Schema = new MetadataSchema;

    $Field = $Schema->GetField($FieldId);

    print $Field->Name();
}

# function to determine if field has itemlevelqualifiers or not
function UsesQualifiers()
{
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    if (is_object($Field))
        return $Field->UsesQualifiers();
    else
        return FALSE;
}

# print Qualifier option list
function PrintQualifierList()
{
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierId", $Items, $Field->DefaultQualifier(),
            0, 1, NULL, false);
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier))
            print $Qualifier->Name();
    }
    else
        print "None";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ParentClass;
global $ParentId;
global $FieldId;

CheckAuthorization(PRIV_CLASSADMIN);

# look up parent class info (make sure they get initialized)
$ParentId = (isset($_GET["ParentId"])) ? $_GET["ParentId"] : FALSE ;
$FieldId = (isset($_GET["FieldId"])) ? $_GET["FieldId"] : FALSE ;
$ParentClass = new Classification($ParentId);

# register post-processing function with the application framework
$AF->AddPostProcessingCall("PostProcessingFn");

# post-processing call
function PostProcessingFn()
{
    # global variables
    global $Session;

    $Session->UnregisterVariable("ErrorMessages");
}

?>
