<?PHP

#
#   FILE:  SPT--ConfirmDeleteTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintTopicName()
#       - print out topic name 
#
#       PrintForumName()
#       - print out forum name 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Confirm Delete Topic");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ForumName;
global $TopicName;

CheckAuthorization( PRIV_SYSADMIN );

$TopicId = $Session->Get("TopicId");
$Topic = new Topic($TopicId);
$TopicName = $Topic->TopicName();

$ForumId = $Session->Get("ForumId");
$Forum = new Forum($ForumId);
$ForumName = $Forum->ForumName();

$Session->PassVariable("ForumId", $ForumId);
$Session->PassVariable("TopicId", $TopicId);

?>
