<?PHP
#
#   FILE:  SPT--RSS.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# create RSS output object and set up channel values
$RSS = new RSS();

$DB = new SPTDatabase();

$Today = getdate();
$Date = $Today['year']."-".$Today['mon']."-".$Today['mday'];

$Query = "Select * from RSSConfiguration";
$DB->Query($Query);

# only one entry
$Entry = $DB->FetchRow();

$SiteLink = OurBaseUrl()."index.php?P=Home";
$NumberOfEntriesToPublish = $Entry["EntriesToPublish"];
$RSS->AddChannel($Entry["ChannelTitle"], $SiteLink, $Entry["ChannelDescription"]);
$RSS->SetImage($Entry["ImageUrl"], $Entry["ImageTitle"], $Entry["ImageLink"],
        $Entry["ImageHeight"], $Entry["ImageWidth"], $Entry["ImageDescription"]);
$RSS->SetLanguage(isset($Entry["Language"]) ? $Entry["Language"] : NULL);
$RSS->SetCopyright(isset($Entry["CopyRight"]) ? $Entry["CopyRight"] : NULL);
$RSS->SetManagingEditor(isset($Entry["ManagingEditor"]) ? $Entry["ManagingEditor"] : NULL);
$RSS->SetWebmaster(isset($Entry["Webmaster"]) ? $Entry["Webmaster"] : NULL);
$RSS->SetPicsRating(isset($Entry["PicsRating"]) ? $Entry["PicsRating"] : NULL);
$RSS->SetPublicationDate($Date);

# set date of most recent update to resources
$ResourceFact = new ResourceFactory();
$LastChangeTimestamp = $ResourceFact->GetTimestampOfLastResourceModification();
$RSS->SetLastChangeDate(date("Y-m-d", $LastChangeTimestamp));

# if search criteria specified
if (isset($_GET["Q"]) && ($_GET["Q"] == "Y"))
{
    # retrieve search parameters from URL
    $SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);

    # set up search engine
    $Engine = new SPTSearchEngine();
    $Engine->SearchTermsRequiredByDefault($SysConfig->SearchTermsRequired());

    # add condition to filter out any temporary resource records
    function FilterOutTempResources($Id) {  return ($Id < 0);  }
    $Engine->AddResultFilterFunction("FilterOutTempResources");

    # add condition to show only released resources
    $Schema = new MetadataSchema();
    $ReleaseField = $Schema->GetFieldByName("Release Flag");
    if ($ReleaseField)
    {
        $SearchGroups[$ReleaseField->Id()]["SearchStrings"]
                ["Release Flag"] = "=1";
        $SearchGroups[$ReleaseField->Id()]["Logic"] = SearchEngine::SEARCHLOGIC_AND;
    }

    # perform search
    $SearchResults = $Engine->GroupedSearch(
            $SearchGroups, 0, $NumberOfEntriesToPublish,
            "Date of Record Release", 1);

    # load resources
    foreach ($SearchResults as $Id => $Score)
    {
        $Resources[$Id] = new Resource($Id);
    }
}
else
{
    # get resource info to publish
    $Resources = $ResourceFact->GetRecentlyReleasedResources(
            $NumberOfEntriesToPublish, 0, 3650);
}

# add resources to feed
foreach ($Resources as $Resource)
{
    $RSS->AddItem(strip_tags($Resource->Get("Title")), 
        "http://".$_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"])
            ."/index.php?P=FullRecord&amp;ResourceId=".$Resource->Id(), 
        strip_tags($Resource->Get("Description")),
        $Resource->Get("Date of Record Release"));
}

# publish RSS page
$RSS->PrintRSS();

# suppress any HTML output
$AF->SuppressHTMLOutput();

?>
