<?php

#
#   FILE:  SPT--AddResourceComment.php
#
#   FUNCTIONS PROVIDED:
#       PrintTitle()
#       - print the resource title
#
#       PrintBody()
#       - print the body of the comment
#
#       PrintSubject()
#       - print subject of comment
#
#       CheckForEdit()
#       - check to see if editing a resource
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the Title
function PrintTitle()
{
    global $Resource;

    print $Resource->Get("Title");
}

# print body
function PrintBody()
{
    global $F_Body;

    # filter out "Edited by:" text
    $loc = strpos($F_Body, "<br>");
    if ($loc === false)
        print GetHtmlEscapedString($F_Body);
    else
        print GetHtmlEscapedString(substr($F_Body, 0, $loc - 2));  
} 

# print body
function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
} 

function CheckForEdit()
{
    global $MessageId, $User, $PosterId;

    if (isset($MessageId) && ($User->Get("UserId") == $PosterId ||
        $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_Body;
global $F_Subject;
global $PosterId;
global $Resource;

# do the query for this resource
if (isset($_GET["ResourceId"]))
    $ResourceId = $_GET["ResourceId"];
else if ($Session->IsRegistered("ResourceId"))
    $ResourceId = $Session->Get("ResourceId");
else
    $ErrorMessages []= "Resource Not Set";

$Resource = new Resource($ResourceId);

if (isset($_GET["MessageId"]))
    $MessageId = $_GET["MessageId"];
else if ($Session->IsRegistered("MessageId"))
    $MessageId = $Session->Get("MessageId");

if(isset($MessageId))    
{
    $Message = new Message($MessageId);
    $F_Subject = $Message->Subject();
    $F_Body = $Message->Body();
    $PosterId = $Message->PosterId();
}
else
{
    $F_Subject = $Resource->Get("Title");
}

if(CheckForEdit())
    PageTitle("Update Resource Comment");
else
    PageTitle("Add Resource Comment");

# pass along necessary variables 
$Session->PassVariable("ResourceId", $ResourceId);
$Session->PassVariable("ParentId", $ResourceId);
$Session->PassVariable("F_Subject", GetHtmlEscapedString($F_Subject));
$Session->PassVariable("MessageId", $MessageId);

CheckAuthorization(PRIV_POSTCOMMENTS);

?>
