<?php

#
#   FILE:  SPT--ExportField.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitExportVars()
{
    global $FSeek, $FieldCount;

    if (is_null($FSeek))
        $FSeek = 0;
    if (is_null($FieldCount))
        $FieldCount = 0;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $fpo, $Session, $FieldCount;
    global $Field, $FSeek;

    # write out the header line only on first time
    if (!empty($fpo) && $FSeek == 0)
    {
        # replace trailing tab with newline
        $Header = $Field->Name()."\n";
        fwrite($fpo, $Header);
    }

    if ($Field->Type() == MetadataSchema::MDFTYPE_TREE)
    {
        $Factory = new ClassificationFactory();
    }
    else if ($Field->Type() == MetadataSchema::MDFTYPE_CONTROLLEDNAME)
    {
        $Factory = new ControlledNameFactory();
    }
    else if ($Field->Type() == MetadataSchema::MDFTYPE_OPTION)
    {
        $Factory = new ControlledNameFactory();
    }

    $ItemIds = $Factory->GetItemIds("FieldId = ".$Field->Id());

    foreach ($ItemIds as $Id)
    {
        # can only export trees 
        if ($Field->Type() == MetadataSchema::MDFTYPE_TREE)
        {
            $Class = new Classification($Id);
            $Value = $Class->FullName();
        }
        # or controllednames or options
        else
        {
            $CN = new ControlledName($Id);
            $Value = $CN->Name();
        }

        # write out the value
        $Record = $Value."\n";
        if (!empty($fpo))
            fwrite($fpo, $Record);
        $FieldCount++;
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $FSeek;
global $Field;
global $FieldCount;
global $fpo;

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ClassDB = new SPTDatabase();

$Schema = new MetadataSchema();
$FieldId = $Schema->GetCurrentEditedItemId();
$Field = new MetadataField($FieldId);

$ScriptFileName = GetFullScriptFileName();
$TempDir = dirname($ScriptFileName)."/tmp/";

# make sure destination dir exists 
if (!file_exists($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " doesn't exist.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    $AF->SetJumpToPage("ExportData");
    return;
}

# make sure destination dir is writable
if (!is_writable($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " is not writable.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    $AF->SetJumpToPage("ExportData");
    return;
}
    
if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("DBEditor");
    return;
}

InitExportVars();

# open export path
$ExportPath = $Session->Get("ExportPath");
if (is_null($ExportPath))
{
    $FileNamePrefix = preg_replace("/[^a-z0-9]/i", "", $Field->Name());
    $BaseName = $FileNamePrefix."_".date("YmdHis").".txt";
    $FileName = "tmp/".$BaseName;
    $ExportPath = dirname($ScriptFileName)."/".$FileName;
}

$fpo = fopen($ExportPath, "a");
if ($fpo == FALSE)
{
    $ErrorMessage = "Cannot open Export Filename: $ExportPath<br>";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    $AF->SetJumpToPage("ExportData");
    return;
}

# suppress any HTML output
$AF->SuppressHTMLOutput();

# the main work happenes here
DoWhileLoop();

fclose($fpo);

header("Content-Type: application/x-octet-stream");
header("Content-Disposition: attachment; filename=\"".addslashes($BaseName)."\"");
readfile($FileName);

?>
