<?php
#
#   FILE:  SPT--EditControlledName.php
#
#   FUNCTIONS PROVIDED:
#       DisplayFoundControlledNames()
#           - displays results of search ControlledNames
#
#   FUNCTIONS EXPECTED:
#       DisplayControlledName()
#           - displays the ControlledNameId and ControlledName
#
#       DisplayControlledNamesForEdit()
#           - Displays Editable fields for a ControlledName
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

include_once("lib/AxisPHP/Axis--StandardLibrary.php");  # (for PrintOptionList())

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the ControlledName
function PrintControlledName()
{
    global $F_ControlledName;

    print(GetHtmlTranslatedString($F_ControlledName));
}

# function to print the ControlledNameId
function PrintControlledNameId()
{
    global $F_ControlledNameId;

    print $F_ControlledNameId;
}

# function to print the ControlledNameId
function PrintVariantName()
{
    global $F_VariantName;

    print(GetHtmlTranslatedString($F_VariantName));

}

# return if ControlledNames exist or not
function ControlledNamesExist()
{
    global $NumRows;

    return $NumRows;
}

# print number of Rows
function PrintNumRows()
{
    global $NumRows;

    print $NumRows;
}

# print in use message 
function PrintInUseMessage()
{
    global $InUseMessage;

    print $InUseMessage;
}

# function to see if Form variable F_ControlledName is empty or not
function SearchEntered()
{
    global $F_ControlledName;

    return (empty($F_ControlledName)) ? false : true;
}

#  display a ControlledName list of values as an option menu
function DisplayControlledNameList()
{
    global $F_FieldId;
    global $Schema;
    global $Index;

    if (isset($Index))
        $FieldName = "F_FieldId_".$Index;
    else
        $FieldName = "F_FieldId";

    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_CONTROLLEDNAME);
    foreach ($Fields as $Field)
    {
        $Items[$Field->Id()] =  $Field->Name();
    }
    PrintOptionList($FieldName, $Items, $F_FieldId, 0, 1, NULL, false, false);
}

# returns true if field uses qualifiers
function FieldUsesQualifiers()
{
    global $F_FieldId;
    global $Schema;

    if ($F_FieldId > 0)
    {
        $Field = $Schema->GetField($F_FieldId);
        if (is_object($Field))
            return $Field->UsesQualifiers();
        else
            return false;
    }
    return false;
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->HasItemLevelQualifiers();
}

# get default qualifier
function GetDefaultQualifier()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    $Qualifier = new Qualifier($Field->DefaultQualifier());
    return $Qualifier->Name();
}

# function to print list of qualifiers
function PrintQualifierOrList()
{
    global $QualifierId;
    global $Index;
    global $F_FieldId;
    global $Schema;

    if (FieldHasItemLevelQualifiers())
    {
        $Field = $Schema->GetField($F_FieldId);

        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierName_".$Index, $Items, $QualifierId,
            0, 1, NULL, false);
    }
    else
    {
        print GetDefaultQualifier();
    }
}

# display list of search results
function DisplayFoundControlledNames()
{
    global $DB;
    global $Index;
    global $F_ControlledNameId;
    global $F_ControlledName;
    global $F_VariantName;
    global $QualifierId;
    global $NumRows;
    global $InUseMessage;

    if ($NumRows > 0)
    {
        DisplayResults();
        $Index=0;
    }

    while ($Index < $DB->NumRowsSelected())
    {
        $DB1 = new SPTDatabase();

        $Result = $DB->FetchRow();
        $F_ControlledNameId = $Result["ControlledNameId"];
        $CN = new ControlledName($F_ControlledNameId);
        $InUseCount = $CN->InUse();

        # display number of resources that use this controlled name
        if ($InUseCount > 0)
            $InUseMessage = "(This value in use by $InUseCount Resources)";
        else
            $InUseMessage = "(This value is not currently in use)";

        $F_ControlledName = $Result["ControlledName"];
        $F_FieldId = $Result["FieldId"];
        $F_VariantName = $Result["VariantName"];
        $QualifierId = $Result["QualifierId"];
              
        DisplayControlledNamesForEdit();
        
        # only display qualifer field if field uses qualifiers    
        if (FieldUsesQualifiers())
            DisplayQualifier();

        DisplayEndTags();    
        $Index++;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# controlledname search
function ControlledNameSearch()
{
    global $DB, $Query, $F_FieldId, $F_ControlledName;

    if (!empty($F_ControlledName))
    {
        # replace * and space with wild cards
        # pass +, squiqgles, and brackets through as literals
        # so that REGEXP in query doesn't puke
        $CNRegex = str_replace("*", ".*.", $F_ControlledName);
        $CNRegex = str_replace(" ", ".*.", $CNRegex);       
        $CNRegex = str_replace("{", "[{]", $CNRegex);       
        $CNRegex = str_replace("}", "[}]", $CNRegex);       
        $CNRegex = str_replace("(", "[(]", $CNRegex);       
        $CNRegex = str_replace(")", "[)]", $CNRegex); 
        $CNRegex = str_replace("+", "[+]", $CNRegex);

        # this Query gets us close
        $Query = "Select ControlledName, VariantName, C.ControlledNameId, ".
                "C.FieldId, QualifierId from ControlledNames AS C".
                " LEFT JOIN VariantNames AS V ON ".
                "C.ControlledNameId=V.ControlledNameId WHERE (".
                "ControlledName REGEXP \"".$CNRegex."\" OR ".
                "VariantName REGEXP \"".$CNRegex."\") ".
                "AND C.FieldId = ".$F_FieldId." ".
                "ORDER BY ControlledName";
    } 
    # nothing entered to search for
    else
    {
        $Query = "Select * from ControlledNames where ControlledName != ".
            "ControlledName";
    }
    $DB->Query($Query);
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_ControlledName;
global $F_ControlledNameId;
global $F_FieldId;
global $F_VariantName;
global $InUseMessage;
global $Index;
global $NumRows;
global $QualifierId;
global $Query;
global $Schema;

CheckAuthorization(PRIV_NAMEADMIN);

$DB = new SPTDatabase();
$Schema = new MetadataSchema();

if (isset($_POST["F_FieldId"]))
    $F_FieldId = $_POST["F_FieldId"];
if (isset($_POST["F_ControlledName"]))
    $F_ControlledName = $_POST["F_ControlledName"];
if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

# echo "F_FieldId = $F_FieldId, CN=$F_ControlledName<br>";

#controlled name search
ControlledNameSearch();
$NumRows = $DB->NumRowsSelected();

if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("MDHome");
}

?>
