<?php

#
#   FILE:  SPT--ExportData.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessage()
#           - print an error message
#
#       GetFlaggedFilesCount()
#           - get number of flagged resources
#
#       PrintFlaggedFilesMessage()
#           - print the number of flagged resource message
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Export Data");

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);


# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# print error messages
function PrintErrorMessage()
{
    global $ErrorMessage;
 
    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

# open import file for reading
function GetFlaggedFilesCount()
{
    global $ScriptFileName, $ErrorMessage, $User;

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/tmp/InputData.".$User->Get("UserId");

    $ResourceCount = 0;

    if (is_null($ErrorMessage) && is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while (!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if (empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

function PrintFlaggedFilesMessage()
{
    $ResourceCount = GetFlaggedFilesCount();

    if ($ResourceCount)
        print "$ResourceCount resources have been flagged for export.";
    else
    {
        print "No flagged files available for export.<br>";
        print "Use Advanced Search to flag files for export.<br>";
    }
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessage;
global $ScriptFileName;

if (isset($_GET["ERR"]))
{
    $ErrorMessage = $_GET["ERR"];
}

if (isset($_SERVER["PATH_TRANSLATED"])
        && strlen($_SERVER["PATH_TRANSLATED"]))
{
    $ScriptFileName = $_SERVER["PATH_TRANSLATED"];
}
elseif (isset($_SERVER["SCRIPT_FILENAME"])
        && strlen($_SERVER["SCRIPT_FILENAME"]))
{
    $ScriptFileName = $_SERVER["SCRIPT_FILENAME"];
}
elseif (isset($_SERVER["PATH_INFO"])
        && strlen($_SERVER["PATH_INFO"]))
{
    $ScriptFileName = $_SERVER["PATH_INFO"];
}
$TempDir = dirname($ScriptFileName).
            "/tmp/";

# make sure destination dir exists 
if (!file_exists($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " doesn't exist.";
}

# make sure destination dir is writable
else if (!is_writable($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " is not writable.";
}

?>
