<?PHP

#
#   FILE:  SPT--EditAboutText.php
#
#   FUNCTIONS PROVIDED:
#       PrintAboutText()
#           - Prints the portal about text from SysConfig
#       PrintPortalName()
#           - Prints the portal name from SysConfig
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintAboutText() { PrintValue("AboutText"); }
function PrintPortalName() {  PrintValue("PortalName");  }

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $SysConfig;  
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(${$FormVar});
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print($SysConfig->{$ValueName}());  
    }
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit About Text");
CheckAuthorization(PRIV_SYSADMIN);

if ( isset($_GET["FromSysConfig"]) )
{
    $Session->PassVariable( "FromSysConfig", "true" );
}


?>
