<?PHP

#
#   FILE:  SPT--EditAnnouncement.php
#
#   FUNCTIONS PROVIDED:
#       AnnouncementInfoAvailable()
#           - indicates whether announcement headline/text is already set
#       EditingAnnouncement()
#           - indicates whether we are editing an existing announcement
#       PrintAnnouncementHeading()
#       PrintAnnouncementDate()
#       PrintAnnouncementText()
#           - print existing announcement headline/date/text
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_Id
#           - ID of existing announcement
#       F_Editing
#           - set if we're editing an existing announcement
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function AnnouncementInfoAvailable()
{
    global $AnnouncementHeading;
    return (isset($AnnouncementHeading)) ? TRUE : FALSE;
}

function EditingAnnouncement()
{
    global $F_Editing;
    return (isset($F_Editing)) ? TRUE : FALSE;
}

function PrintAnnouncementHeading()
{
    global $AnnouncementHeading;

    print(GetHtmlTranslatedString($AnnouncementHeading));
}

function PrintAnnouncementText()
{
    global $AnnouncementText;

    print(GetHtmlTranslatedString($AnnouncementText));
}

function PreviewAnnouncementHeading()
{
    global $AnnouncementHeading;
    print $AnnouncementHeading;
}

function PreviewAnnouncementText()
{
    global $AnnouncementText;
    print $AnnouncementText;
}

function PrintAnnouncementDate()
{
    print(date("M j"));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LoadAnnouncement($Id)
{
    global $DB;
    global $Session;
    global $AnnouncementHeading, $AnnouncementText;

    # retrieve announcement values
    if (isset($Id) && (!isset($AnnouncementHeading)))
    {
        $DB->Query("SELECT * FROM Announcements WHERE AnnouncementId=".intval($Id));
        $Announcement = $DB->FetchRow();
        $AnnouncementHeading = stripslashes($Announcement["AnnouncementHeading"]);
        $AnnouncementText = stripslashes($Announcement["AnnouncementText"]);
    }

    # remember announcement ID
    $Session->PassVariable("F_Id", $Id);
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AnnouncementHeading;
global $AnnouncementText;
global $F_Editing;

if (isset($_GET["F_Id"]))
    $F_Id = $_GET["F_Id"];
else
    $F_Id = $Session->Get("F_Id");

if (isset($_GET["F_Editing"]))
    $F_Editing = $_GET["F_Editing"];
else
    $F_Editing = $Session->Get("F_Editing");

# set page title based on whether an announcement ID was passed in
if (isset($F_Editing))
    PageTitle("Edit Announcement");
else
    PageTitle("Add Announcement");

# load announcement info
LoadAnnouncement($F_Id);

# pass along editing flag if set
if (isset($F_Editing)) {  $Session->PassVariable("F_Editing", $F_Editing);  }
CheckAuthorization( PRIV_NEWSADMIN );

?>
