<?PHP
#
#   FILE:  SPT--EditPrivilegeNames.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

CheckAuthorization(PRIV_SYSADMIN);

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTextFormEntries($NumberOfEntries)
{
    global $Privileges;
    global $G_PrivDescriptions;
    
    # for each requested entry
    $Index = 0;
    foreach ($Privileges as $Privilege)
    {
        # Determine if the privilege is predefined
        if (!$Privilege->IsPredefined())
        {
            # use default value from saved search if available
            $DefaultValue = isset($Privilege->Name) ? $Privilege->Name() : "";
            $DefaultId = isset($Privilege->Id) ? $Privilege->Id() : "";

            # print entry and increment index
            PrintTextFormEntry("F_PermissionText".$Index, addslashes($DefaultValue), $DefaultId);
            $Index++;
        }
    }
    
    # Print remaining blank entries
    for ($Index; $Index < $NumberOfEntries; $Index++)
    {
        $IsLast = ($Index + 1 == $NumberOfEntries) ? TRUE : FALSE;
        PrintTextFormEntry("F_PermissionText".$Index, "", "", $IsLast); 
    }
}

# function to print any error messages at top of the page
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed from PreferencesComplete
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul><b>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul></b>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $G_PrivDescriptions;
global $Privileges;

if ($User->IsLoggedIn())
{
    $PrivilegeFactory = new PrivilegeFactory();
    $Privileges = $PrivilegeFactory->GetPrivileges();
}

PageTitle("");

?>
