<?PHP
#
#   FILE:  SPT--EditPrivilegeNamesComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2006 Internet Scout Project
#   http://scout.wisc.edu
#

PageTitle("");

CheckAuthorization(PRIV_SYSADMIN);

# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)
function UpdatePrivileges(){
    global $G_PrivDescriptions;

    # Create privilege factory and get all privileges
    $PrivilegeFactory = new PrivilegeFactory();
    $Privileges = $PrivilegeFactory->GetPrivileges();

    # Set starting index
    $Index = 0;
    $Counter = 0;
    
    # Loop through each privilege
    foreach ($Privileges as $Privilege)
    {
        # Determine if current privilege is not predefined
        if (!$Privilege->IsPredefined() &&
                isset($_POST["F_PermissionText".$Index]))
        {
            # Initialize status
            $Status = 0;
        
            # Determine privilege's update/delete status
            if (isset($_POST["F_PermissionText".$Index."_Delete"]))
            {
                # Delete the privilege and update status
                $Privilege->Delete();
                $Status = 1;
                $Counter--;
            }
            else if ($Privilege->Name() !== $_POST["F_PermissionText".$Index])
            {
                # Update privilege and status
                $Privilege->Name(addslashes($_POST["F_PermissionText".$Index]));
                $Status = 2;
            }
    
            # Display privilege and increment index
            DisplayField($Privilege->Name(), $Status);
            $Index++;
            $Counter++;
        }
    }
    
    # Loop through remaining permission values
    for ($Index; isset($_POST["F_PermissionText".$Index]); $Index++)
    {
        # If not whitespace, add new privilege and display it
        if (trim($_POST["F_PermissionText".$Index]) !== "" &&
                !isset($_POST["F_PermissionText".$Index."_Delete"]))
        {
            $Privilege = new Privilege(NULL,
                addslashes($_POST["F_PermissionText".$Index]));
            DisplayField($Privilege->Name(), 3);
            $Counter++;
        }
    }

    # Determine if any privileges exist
    if ($Counter < 1)
    {
        DisplayField("No privileges", 0);
    }
}

function DisplayPrivileges()
{
    global $G_PrivDescriptions;

    # Create privilege factory and get all privileges
    $PrivilegeFactory = new PrivilegeFactory();
    $Privileges = $PrivilegeFactory->GetPrivileges();
    
    # Determine if any privileges exist
    if (count($Privileges) - count($G_PrivDescriptions) < 1)
    {
        DisplayField("No privileges", 0);
    }
    else
    {
        # Loop through each privilege
        foreach ($Privileges as $Privilege)
        {
            # Determine if current privilege is not predefined
            if (!$Privilege->IsPredefined())
            {    
                # Display privilege and increment index
                DisplayField($Privilege->Name(), 0);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $G_PrivDescriptions;

# Check if the privileges have already been updated
if (isset($_POST["AlreadyLoaded"]))
{
    # Go to all privileges  (needs the "?ID=" portion, fixes refresh bug)
    $AF->SetJumpToPage("EditPrivilegeNames&ID=");
    return;
}
$_POST["AlreadyLoaded"] = "TRUE";

?>
