<?php

#
#   FILE:  SPT--Logout.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# if user is currently logged in
if ($User->IsLoggedIn() == TRUE)
{
    # wipe out editing state values
    $Schema = new MetadataSchema();
    while ($Schema->GetCurrentEditedItemId()) {  $Schema->ClearCurrentEditedItem();  }
    $RFactory = new ResourceFactory();
    while ($RFactory->GetCurrentEditedItemId()) {  $RFactory->ClearCurrentEditedItem();  }

    # signal user logout
    $AF->SignalEvent("EVENT_USER_LOGOUT", array("UserId" => $User->Id()));
    
    # log user out
    $User->Logout();
}

# return to page where user logged out
$AF->SetJumpToPage($_SERVER["HTTP_REFERER"]);

?>
