
------- DEFAULT VALUES -------------------------------------------------------

-- set up default system configuration values
INSERT INTO SystemConfiguration (
        TopLinkString, 
        PortalName, 
        AdminEmail,
        NumClassesPerBrowsePage, 
        PasswordMailSubject, 
        PasswordMailBody,
        SearchTermsRequired,
        DefaultCharacterSet,
        LegalNotice,
        CurrentTheme
    ) VALUES (
        '', 
        'Online Resource Portal', 
        'webmaster@localhost', 
        80, 
        'New Account (X-USERNAME-X)',
        '\nThank you for signing up on this online resource portal.  Below is\nyour new login name and password.\n\n    Account Name:  X-USERNAME-X\n        Password:  X-PASSWORD-X\n\nAfter logging in you can change your password via Preferences.',
        1,
        'ISO-8859-1',
        'Sample Content  1999-2003 Internet Scout Project',
        'Theme--ArcticSilver'
    );
INSERT INTO UIStyleConfiguration (
        StyleName,
        PageCenterBackground, 
        PageSideBackground, 
        SPTTableHeaderBackground, 
        MDTTableHeaderBackground, 
        TableBodyBackground, 
        ForumDarkHeaderBackground, 
        ForumLightHeaderBackground, 
        ForumBodyBackground,
        NavBoxBackground,
        HomeBoxBackground
    ) VALUES (
        'SPTUI--Default',
        '#FFFFFF',
        '#EEEEEE',
        '#DDEEFF',
        '#DDFFDD',
        '#F5F5F5',
        '#000066',
        '#336699',
        '#EEEEEE',
        '#F8F8F8',
        '#F0F0F0'
    );

INSERT INTO MetadataFields VALUES (1,'Title','Text','Name by which the resource is formally known. Title is used and displayed as a headline in the SPT. This field is a required field. Required fields may not be customized as to the field type or disabled. Required fields must be completed in each resource record. DCMI element.',1,1,0,1,NULL,1,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922144528,NULL,32,32);
INSERT INTO MetadataFields VALUES (2,'Alternate Title','Text','This is a variant name by which resources may be known. It allows access when the exact title may impede retrieval and includes complete names/words abbreviated in the Title, commonly known name, or an associated text. DCMI recommended element refinement of Title.',0,1,1,1,NULL,1,0,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145738,NULL,33,33);
INSERT INTO MetadataFields VALUES (3,'Description','Paragraph','Text describing the scope, subject matter, and usefulness of the resource. Sometimes this field is also referred to as account of the content of the resource or an annotation. Description may include but is not limited to: an abstract, table of contents, reference to a graphical representation of content or a free-text account of the content. This is a required field. Required fields may not be customized as to the field type or disabled. Required fields must be completed in each resource record. DCMI element.',1,1,0,1,NULL,1,1,NULL,NULL,12,38,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150031,NULL,38,39);
INSERT INTO MetadataFields VALUES (4,'Url','Text','The complete, current location or unique identifier of the resource. Because of the functionality of the domain limit, remember to always add the trailing slash after the domain. Portal administrators may make this a required field. Required fields must be completed in each resource record. DCMI element.',0,1,0,1,NULL,1,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145738,NULL,34,34);
INSERT INTO MetadataFields VALUES (5,'Release Flag','Flag','This internal administrative feature allows resource administrators to withhold record from public view and searching. Intended to provide a method for internal review and editing. The record will only be available for view by authorized resource editors and site administrator and is not available in the Advanced search. This is a required field. Required fields may not be customized as to the field type or disabled. In the Administration database editor feature, portal administrators may set the default value for this field.',1,1,0,0,NULL,0,0,NULL,NULL,NULL,NULL,'0',NULL,NULL,'OK for Viewing','Not OK for Viewing','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922151138,NULL,53,55);
INSERT INTO MetadataFields VALUES (6,'Source','Text','A Reference to a resource from which the present resource is derived. The present resource may be derived from the Source resource in whole or in part. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system. DCMI element.',0,1,1,1,NULL,0,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145903,NULL,49,50);
INSERT INTO MetadataFields VALUES (7,'Relation','Text','A reference to a related resource. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system. DCMI element.',0,1,1,1,NULL,0,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145930,NULL,48,49);
INSERT INTO MetadataFields VALUES (8,'Coverage','Text','The extent or scope of the content of the resource. Coverage will typically include spatial location (a place name or geographic coordinates), temporal period (a period label, date, or date range) or jurisdiction (such as a named administrative entity). Dublin Core Metadata Initiative recommended best practice is to select a value from a controlled vocabulary (for example, the Getty Thesaurus of Geographic Names) and that, where appropriate, named places or time periods be used in preference to numeric identifiers such as sets of coordinates or date ranges. DCMI element.',0,1,1,1,NULL,0,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150049,NULL,47,47);
INSERT INTO MetadataFields VALUES (9,'Rights','Text','Information about rights held in and over the resource. Typically, a Rights element will contain a rights management statement for the resource, or reference a service providing such information. Rights information often encompasses Intellectual Property Rights, Copyright, and various Property Rights. DCMI element.',0,1,1,1,NULL,0,1,30,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150049,NULL,46,46);
INSERT INTO MetadataFields VALUES (10,'Email Address','Text','The email address for contact of the creator, editor, site administrator, manager, information desk, user support agent, etc. or other entity responsible for answering questions and correspondence regarding the resource.',0,1,1,1,NULL,0,1,30,100,NULL,NULL,NULL,NULL,NULL,'','',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,20030922145844,NULL,51,53);
INSERT INTO MetadataFields VALUES (11,'Date Issued','Date','The year the resource being described was created, published, or otherwise made available. Records a date in a standard format. Users do not need to enter the date in this format. The software will translate a provided date into the standard format (YYYY-MM-DD). It is also possible to enter a partial date or an open ended (continuing) date or qualify the date in the case of uncertainty. For further examples see extended definitions. DCMI recommended element refinement for Date. ',0,1,1,1,NULL,0,0,10,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150035,NULL,40,41);
INSERT INTO MetadataFields VALUES (12,'Date Of Record Creation','TimeStamp','Date the resource being described was entered into the database collection. This date must be entered in the YYYY-MM-DD format. The software automatically enters the current date if this field is left uncompleted.',0,1,0,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','YYYY-MM-DD HH:MM:SS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,16,20030922145450,NULL,54,56);
INSERT INTO MetadataFields VALUES (13,'Date Record Checked','Date','Date the URL of the resource being described was determined to be accurate and adequately addressed by the cataloging record. This date may be entered in the same manner as described above in Date Issued definition. The software automatically enters the current date if this field is left uncompleted.',1,1,0,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','YYYY-MM-DD HH:MM:SS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,16,20030922145434,NULL,55,57);
INSERT INTO MetadataFields VALUES (14,'Date Last Modified','TimeStamp','This is a time stamp recording the last time anything in a given resource record was altered. This date cannot be manually edited.',1,1,0,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,16,20030922145444,NULL,56,59);
INSERT INTO MetadataFields VALUES (15,'Verification Attempts','Number','This field records the number of attempts a URL checking software has made to confirm the current the accuracy of the URL of the resource. By default this when the portal software is shipped, this field is disabled and does not appear visible anywhere throughout the portal. Administrators may at any time enable this field in the database editor in the portal Administration.',0,0,1,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,999,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,20030922150015,NULL,41,36);
INSERT INTO MetadataFields VALUES (16,'Added By Id','User','System supplied field which records the account name of the person creating the resource record. This field cannot be directly edited. All resource editors login name with automatically appear as an option in the Metadata Tool search limits and on the full record display.',1,1,0,1,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,9999999,'','',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,20030922145444,NULL,57,60);
INSERT INTO MetadataFields VALUES (17,'Last Modified By Id','User','System supplied field which records the account name of the person who last modified the resource record. This field cannot be directly edited. All resource editors login name with automatically appear as an option in the Metadata Tool search limits and on the full record display.',1,1,0,1,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,9999999,'','',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,20030922144644,NULL,58,61);
INSERT INTO MetadataFields VALUES (18,'Cumulative Rating','Number','This field records the evaluative ratings given to a particular resource by portal users.',1,1,1,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,5,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,20030922145438,NULL,61,58);
INSERT INTO MetadataFields VALUES (19,'Publisher','ControlledName','An entity responsible for making the resource available. Examples of a publisher include a person, an organization, or a service. Publishers are not necessarily the creators of the intellectual content of the resource, but they do claim some responsibility for the content. As with the Creator field (above), SPT Metadata Tool allows for a Controlled Name and a Variant Name. DCMI element.',0,1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150028,NULL,37,38);
INSERT INTO MetadataFields VALUES (20,'Creator','ControlledName','The personal, corporate, meeting/conference, etc. name(s) of the party(s) responsible for creation of resource content. Any work can have single, multiple, corporate, or personal creators. Personal creators are people. Some typical examples of corporate creators are associations, institutions, business firms, non-profit enterprises, governments, government agencies, projects, programs, religious bodies, church groups, and conferences. DCMI element.',0,1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150013,NULL,35,35);
INSERT INTO MetadataFields VALUES (21,'Contributor','ControlledName','An entity responsible for making contributions to the content of the resource. Examples of a Contributor include a person, an organization, or a service. This field also employs Controlled Names as described above in the definition for Creator. DCMI element.',0,1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150018,NULL,36,37);
INSERT INTO MetadataFields VALUES (22,'Subject','ControlledName','Terms or a nonhierarchical string of terms relating the resource\'s content. Recommended best practice is to select from a controlled vocabulary, Library of Congress Subject Headings, etc. DCMI element.',0,1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145844,NULL,50,52);
INSERT INTO MetadataFields VALUES (23,'Resource Type','Option','The nature or genre of the content of the resource. Type includes terms describing general categories, functions, genres, or aggregation levels for content. When entering a resource record, the software allows for multiple values to be selected from this field. This field is used in the Advanced Search as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. NOTE: The default values come from the working draft list of Dublin Core Types. Further, to describe the physical or digital manifestation of the resource, use the FORMAT element per Dublin Core definitions. DCMI element.',0,1,1,1,1,0,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',1,0,6,20030922150040,NULL,42,42);
INSERT INTO MetadataFields VALUES (24,'Language','Option','A language of the intellectual content of the resource. The default values are selected from several commonly used major languages. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. DCMI element.',0,1,1,1,1,0,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150102,NULL,45,45);
INSERT INTO MetadataFields VALUES (25,'Audience','Option','A category of user for whom the resource is intended. Frequently, creators and publishers of resources in education explicitly state the category of user for whom the resource is intended. In like fashion, end-users in the education/training domain frequently search using audience characteristics as search terms. The default values are drawn from the broadest educational category levels. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. DC-Education Working Group prosposed element.',0,1,1,1,1,0,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150102,NULL,44,44);
INSERT INTO MetadataFields VALUES (26,'Format','Option','The physical or digital manifestation of the resource. Typically, Format may include the media-type or dimensions of the resource. Format may be used to determine the software, hardware or other equipment needed to display or operate the resource. Examples of dimensions include size and duration. The default values are selections from the list of Internet Media Types (MIME) defining computer media formats.  When entering a resource record, the software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. DCMI element.',0,1,1,1,1,0,1,NULL,NULL,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922150059,NULL,43,43);
INSERT INTO MetadataFields VALUES (27,'Classification','Tree','The Metadata Tool allows the use an existing standard classification schema or your organization\'s homegrown taxonomy. Classification in the portal provides users with a way of browsing through the resources in hierarchical tiers. This approach guides users unfamiliar with terminology to appropriate resources descending in specificity from broadly defined to more precise.  Privilege to to build or edit the vocabulary or taxonomy of assifications requires authorization from the portal administrator.',1,1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','',NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,20030922150035,NULL,39,40);
INSERT INTO MetadataFields VALUES (28,'Screenshot','Still Image','Still, digital image or snapshot to be attached to a resource metadata record for illustration or other purposes. Acceptable file formats are .jpg, .bmp, and gif (depending on what is supported by the PHP version installed on your web server).',0,1,1,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','',NULL,NULL,3,768,576,100,100,50,50,'Screenshot',0,0,NULL,20030922145513,NULL,52,54);
INSERT INTO MetadataFields VALUES (29,'Interactivity Type','Option','The flow of interaction between this resource and the intended user. DC-Education Working Group recommended data element in the IEEE LOM/IMS Namespace',0,0,1,1,0,0,1,50,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145901,1,60,51);
INSERT INTO MetadataFields VALUES (30,'Interactivity Level','Option','The degree of interactivity between the end user and this resource. DC-Education Working Group recommended data element from the IEEE LOM/IMS Namespace.',0,0,1,1,0,1,0,50,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922145930,1,59,48);
INSERT INTO MetadataFields VALUES (31,'Typical Learning Time','Text','Approximate or typical time it takes to work with this resource. DC-Education Working Group recommended data elements from the IEEE LOM/IMS Namespace.',0,0,1,1,0,0,1,50,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922141719,1,31,31);
INSERT INTO MetadataFields VALUES (32,'Table of Contents','Paragraph','A list of subunits of the content of the resource. DCMI\r\nrecommended element refinement for	Description.',0,0,1,1,0,0,0,50,100,4,50,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922141719,1,30,30);
INSERT INTO MetadataFields VALUES (33,'Abstract','Paragraph','A summary of the content of the resource. DCMI \r\nrecommended element refinement\r\nfor Description.',0,0,1,1,0,0,0,50,100,4,50,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922141719,1,10,10);
INSERT INTO MetadataFields VALUES (34,'Valid Date','Date','Date (often a range) of validity of a resource. DCMI recommended 	element refinement\r\nfor Date.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,9,9);
INSERT INTO MetadataFields VALUES (37,'Modified Date','Date','Date on which the resource was changed. DCMI recommended element refinement for Date.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,11,11);
INSERT INTO MetadataFields VALUES (36,'Available Date','Date','Date (often a range) that the resource will become or did become available. DCMI recommended element refinement for Date.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,12,12);
INSERT INTO MetadataFields VALUES (35,'Creation Date','Date','Date of creation of the resource. DCMI recommended element refinement for Date. ',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,14,14);
INSERT INTO MetadataFields VALUES (38,'Extent','Option','The size or duration of the resource. DCMI recommended element refinement for Format.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,13,13);
INSERT INTO MetadataFields VALUES (39,'Medium','Option','The material or physical carrier of the resource. DCMI recommended element refinement of Format.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,8,8);
INSERT INTO MetadataFields VALUES (40,'Is Version Of','Text','The described resource is a version, edition, or adaptation of the referenced resource. Changes in version imply substantive changes in content rather than differences in format. DCMI recommended element refinement of Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,7,7);
INSERT INTO MetadataFields VALUES (41,'Has Version','Text','The described resource is a version, edition, or adaptation of the referenced resource. Changes in version imply substantive changes in content rather than differences in format. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,2,2);
INSERT INTO MetadataFields VALUES (42,'Is Replaced By','Text','The described resource is supplanted, displaced, or superseded by the referenced resource. DCMI recommend element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,1,1);
INSERT INTO MetadataFields VALUES (43,'Replaces','Text','The described resource supplants, displaces, or supersedes the referenced resource. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,3,3);
INSERT INTO MetadataFields VALUES (44,'Is Required By','Text','The described resource is required by the referenced resource, either physically or logically. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,'','','',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',0,0,0,20030922141719,1,4,4);
INSERT INTO MetadataFields VALUES (45,'Requires','Text','The described resource requires the referenced resource to support its function, delivery, or coherence of content. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,6,6);
INSERT INTO MetadataFields VALUES (46,'Is Part Of ','Text','The described resource is a physical or logical part of the referenced resource. DCMI recommended element refinment for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,5,5);
INSERT INTO MetadataFields VALUES (47,'Has Part','Text','The described resource includes the referenced resource either physically or logically. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,15,15);
INSERT INTO MetadataFields VALUES (48,'Is Referenced By','Text','The described resource is referenced, cited, or otherwise pointed to by the referenced resource. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,16,16);
INSERT INTO MetadataFields VALUES (49,'References','Text','The described resource references, cites, or otherwise points to the referenced resource.  DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,26,26);
INSERT INTO MetadataFields VALUES (50,'Is Format Of','Text','The described resource is the same intellectual content of the referenced resource, but presented in another format. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,25,25);
INSERT INTO MetadataFields VALUES (51,'Has Format','Text','The described resource pre-existed the referenced resource, which is essentially the same intellectual content presented in another format. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,27,27);
INSERT INTO MetadataFields VALUES (52,'Conforms To','Text','A reference to an established standard to which the resource conforms. DCMI recommended element refinement for Relation.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,28,28);
INSERT INTO MetadataFields VALUES (53,'Spatial','Text','Spatial characteristics of the intellectual content of the resource. DCMI recommended element refinement for Coverage.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,29,29);
INSERT INTO MetadataFields VALUES (54,'Temporal','Text','Temporal characteristics of the intellectual content of the resource. DCMI recommended element refinement for Coverage.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,24,24);
INSERT INTO MetadataFields VALUES (55,'Mediator','Option','A class of entity that mediates access to the resource and for whom the resource is intended or useful. The audiences for a resource are of two basic classes: (1) an ultimate beneficiary of the resource, and (2) frequently, an entity that mediates access to the resource. The mediator element refinement represents the second of these two classes. DCMI recommended element refinement for Audience.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,23,23);
INSERT INTO MetadataFields VALUES (56,'Date Accepted','Date','Date of acceptance of the resource (e.g. of thesis by university department, of article by journal, etc.). DCMI recommended element refinement form Date.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,18,18);
INSERT INTO MetadataFields VALUES (57,'Date Copyrighted','Date','Date of a statement of copyright. DCMI recommended element refinement for Date. ',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,17,17);
INSERT INTO MetadataFields VALUES (58,'Date Submitted','Date','Date of submission of the resource (e.g. thesis, articles, etc.). DCMI recommended relement refinement for Date. ',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,19,19);
INSERT INTO MetadataFields VALUES (59,'Education Level','Option','A general statement describing the education or training context. Alternatively, a more specific statement of the location of the audience in terms of its progression through an education or training context. DCMI recommended element refinement for Audience.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,20,20);
INSERT INTO MetadataFields VALUES (60,'Access Rights','Text','Information about who can access the resource or an indication of its security status.\r\nAccess Rights may include information regarding access or restrictions based on privacy, security or other regulations. DCMI recommended element refinement for Rights.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,22,22);
INSERT INTO MetadataFields VALUES (61,'Bibliographic Citation','Text','A bibliographic reference for the resource.\r\nRecommended practice is to include sufficient bibliographic detail to identify the resource as unambiguously as possible, whether or not the citation is in a standard form. DCMI recommended refinement element for Identifier.',0,0,1,1,0,0,0,50,100,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,20030922141719,1,21,21);

-- set up initial controlled name types
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (1, 'Creator', 0);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (2, 'Publisher', 0);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (3, 'Contributor', 0);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (4, 'Subject', 0);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (10, 'Resource Type', 1);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (11, 'Audience', 1);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (12, 'Language', 1);
INSERT INTO ControlledNameTypes (ControlledNameTypeId, ControlledNameTypeName, ControlledNameIsList) VALUES (13, 'Format', 1);

INSERT INTO ControlledNames VALUES (8,'Dataset',10,6);
INSERT INTO ControlledNames VALUES (9,'Image',10,6);
INSERT INTO ControlledNames VALUES (34,'Collection',10,6);
INSERT INTO ControlledNames VALUES (64,'Event',10,6);
INSERT INTO ControlledNames VALUES (65,'Interactive Resource',10,6);
INSERT INTO ControlledNames VALUES (66,'Service',10,6);
INSERT INTO ControlledNames VALUES (67,'Software',10,6);
INSERT INTO ControlledNames VALUES (68,'Sound',10,6);
INSERT INTO ControlledNames VALUES (69,'Text',10,6);
INSERT INTO ControlledNames VALUES (70,'Physical Object',10,6);
INSERT INTO ControlledNames VALUES (88,'Kindergarten',11,NULL);
INSERT INTO ControlledNames VALUES (89,'Grades 1 - 3',11,NULL);
INSERT INTO ControlledNames VALUES (90,'Grades 4 - 6',11,NULL);
INSERT INTO ControlledNames VALUES (91,'Grades 7 - 9',11,NULL);
INSERT INTO ControlledNames VALUES (92,'Grades 10 -12',11,NULL);
INSERT INTO ControlledNames VALUES (93,'Undergraduate students',11,NULL);
INSERT INTO ControlledNames VALUES (94,'Graduate students',11,NULL);
INSERT INTO ControlledNames VALUES (95,'Faculty',11,NULL);
INSERT INTO ControlledNames VALUES (96,'Lifelong learners',11,NULL);
INSERT INTO ControlledNames VALUES (4,'English',12,NULL);
INSERT INTO ControlledNames VALUES (35,'Spanish',12,NULL);
INSERT INTO ControlledNames VALUES (36,'Polish',12,NULL);
INSERT INTO ControlledNames VALUES (43,'Japanese',12,NULL);
INSERT INTO ControlledNames VALUES (72,'richtext',13,7);
INSERT INTO ControlledNames VALUES (12,'pdf',13,7);
INSERT INTO ControlledNames VALUES (71,'plain',13,7);
INSERT INTO ControlledNames VALUES (73,'enriched',13,7);
INSERT INTO ControlledNames VALUES (74,'tab-separated-values',13,7);
INSERT INTO ControlledNames VALUES (75,'html',13,7);
INSERT INTO ControlledNames VALUES (76,'sgml',13,7);
INSERT INTO ControlledNames VALUES (77,'css',13,7);
INSERT INTO ControlledNames VALUES (78,'xml',13,7);
INSERT INTO ControlledNames VALUES (79,'calendar',13,7);
INSERT INTO ControlledNames VALUES (80,'postscript',13,7);
INSERT INTO ControlledNames VALUES (81,'zip',13,7);
INSERT INTO ControlledNames VALUES (82,'mpeg',13,7);
INSERT INTO ControlledNames VALUES (83,'quicktime',13,7);
INSERT INTO ControlledNames VALUES (84,'gif ',13,7);
INSERT INTO ControlledNames VALUES (85,'jpeg',13,7);
INSERT INTO ControlledNames VALUES (86,'tiff',13,7);

INSERT INTO ClassificationTypes (ClassificationTypeId, ClassificationTypeName) VALUES (1, 'Classification');

-- set up default RSS Export configuration options
INSERT INTO RSSConfiguration (EntriesToPublish, ChannelTitle,
            ChannelDescription, ImageUrl, ImageTitle, ImageLink, 
            ImageHeight, ImageWidth, ImageDescription, Language, Copyright, 
            ManagingEditor, Webmaster, PicsRating)
        VALUES(15, 'Online Resource Portal',
            'Channel Description', 'Image Url', 'Image Title', 'Image Link', 
            0, 0, 'Image Description', 'en-us', CONCAT('Copyright ', YEAR(NOW())),  
            'Managing Editor', 'Webmaster', '');

-- set up initial administrator login
INSERT INTO APUsers (UserName, UserPassword, CreationDate) 
        VALUES ('sptadmin', '/KfRBIL.TPL7A', NOW());
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 1);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 2);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 3);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 4);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 5);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 6);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 7);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 8);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 9);
INSERT INTO APUserPrivileges (UserId, Privilege) VALUES (1, 10);

-- set up initial announcements
INSERT INTO Announcements (AnnouncementId, AnnouncementHeading, AnnouncementText, DatePosted, PosterId) VALUES (1, 'Welcome', 'Welcome to your new online resource portal!  You may want to add some welcome text here.', NOW(), 1);
INSERT INTO Announcements (AnnouncementId, AnnouncementHeading, AnnouncementText, DatePosted, PosterId) VALUES (2, 'News', 'News and announcements can also go in this area.', NOW(), 1);

-- set up OAI data
INSERT INTO OAIFormats SET FormatName = "oai_dc", TagName = "oai_dc:dc", SchemaLocation = "http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd";

INSERT INTO OAIFormatNamespaces SET FormatId = "1", NamespaceName = "oai_dc", NamespaceURI = "http://www.openarchives.org/OAI/2.0/oai_dc/";
INSERT INTO OAIFormatNamespaces SET FormatId = "1", NamespaceName = "dc", NamespaceURI = "http://purl.org/dc/elements/1.1/";

INSERT INTO OAIFieldMappings VALUES ('oai_dc',1,'dc:title');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',1,'dc:title');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',2,'dc:title');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',2,'dct:alternative');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',3,'dc:description');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',3,'dc:description');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',4,'dc:identifier');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',4,'dc:identifier');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',6,'dc:source');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',6,'dc:source');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',7,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',7,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',8,'dc:coverage');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',8,'dc:coverage');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',9,'dc:rights');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',9,'dc:rights');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',11,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',11,'dct:issued');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',19,'dc:publisher');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',19,'dc:publisher');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',20,'dc:creator');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',20,'dc:creator');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',21,'dc:contributor');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',21,'dc:contributor');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',22,'dc:subject');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',22,'dc:subject');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',23,'dc:type');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',23,'dc:type');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',24,'dc:language');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',24,'dc:language');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',25,'dct:audience');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',26,'dc:format');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',26,'dc:format');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',27,'dc:subject');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',27,'dc:subject');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',29,'ieee:interactivityType');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',30,'ieee:interactivityLevel');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',31,'ieee:typicalLearningTime');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',32,'dc:description');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',32,'dct:tableOfContents');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',33,'dc:description');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',33,'dct:abstract');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',34,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',34,'dct:valid');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',37,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',37,'dct:modified');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',36,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',36,'dct:available');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',35,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',35,'dct:created');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',38,'dc:format');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',38,'dct:extent');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',39,'dc:format');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',39,'dct:medium');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',40,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',40,'dct:isVersionOf');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',41,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',41,'dct:hasVersion');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',42,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',42,'dct:isReplacedBy');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',43,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',43,'dct:replaces');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',44,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',44,'dct:isRequiredBy');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',45,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',45,'dct:requires');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',46,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',46,'dct:isPartOf');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',47,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',47,'dct:hasPart');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',48,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',48,'dct:isReferencedBy');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',49,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',49,'dct:references');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',50,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',50,'dct:isFormatOf');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',51,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',51,'dct:hasFormat');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',52,'dc:relation');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',52,'dct:conformsTo');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',53,'dc:coverage');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',53,'dct:spatial');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',54,'dc:coverage');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',54,'dct:temporal');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',55,'dc:type');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',55,'dct:mediator');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',56,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',56,'dct:dateAccepted');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',57,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',57,'dct:dateCopyrighted');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',58,'dc:date');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',58,'dct:dateSubmitted');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',59,'dct:educationLevel');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',60,'dc:rights');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',60,'dct:accessRights');
INSERT INTO OAIFieldMappings VALUES ('oai_dc',61,'dc:identifier');
INSERT INTO OAIFieldMappings VALUES ('nsdl_dc',61,'dct:bibliographicCitation');

--
--  'OAIQualifierMappings'
--

INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',13,'dct:Box');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',15,'dct:Period');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',11,'dct:Point');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',6,'dct:DCMIType');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',3,'dct:DDC');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',7,'dct:IMT');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',12,'dct:ISO3166');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',8,'dct:ISO639-2');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',4,'dct:LCC');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',1,'dct:LCSH');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',2,'dct:MESH');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',9,'dct:RFC1766');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',17,'dct:RFC3066');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',14,'dct:TGN');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',5,'dct:UDC');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',10,'dct:URI');
INSERT INTO OAIQualifierMappings VALUES ('nsdl_dc',16,'dct:W3CDTF');
