<?php
#
#   FILE:  SPT--AddNewControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       PrintAddedControlledNames()
#           - displays added controlled names and variants 
#
#   FUNCTIONS EXPECTED:
#           - none
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--Resource.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintAddedControlledName()
{
    global $HTTP_POST_VARS;

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];

    print $F_ControlledName;
    if(!empty($F_Variant))
        print ", Variant (".$F_Variant.")";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function AddControlledName()
{
    global $Session;
    global $DisplayString;
    global $HTTP_POST_VARS;
    global $ResourceId;
    global $AddedNames;
    global $Variants;

    $DB =& new SPTDatabase();

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_ControlledNameTypeId = $HTTP_POST_VARS["F_ControlledNameTypeId"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    $F_Qualifier = $HTTP_POST_VARS["F_Qualifier"];

    # set "--" to NULL
    if(is_null($F_Qualifier) || $F_Qualifier == "--")
        $F_Qualifier = "NULL";

    if((is_null($F_ControlledName) || empty($F_ControlledName))
        && $F_Variant != NULL)
    {
        $Session->PassVariable("ErrorMessage",
            "Error: ControlledName is a required field.");
        PrintAutoRefreshPage("Error Message", "SPT--SearchControlledName.php");
        exit;
    }
    else
    {
        $F_ControlledName = addslashes(trim($F_ControlledName));
        $F_Variant = addslashes(trim($F_Variant));
        if(!empty($F_ControlledName))
        {
            # check to see if it already exists
            $CN = & new ControlledName(NULL, $F_ControlledName, 
                    $F_ControlledNameTypeId, $F_Qualifier, $F_Variant);

            # controlled name found, error        
            if($CN->Status() == CNSTAT_EXISTS)
            {
                $Session->PassVariable("ErrorMessage",
                    "Error: ControlledName '".$F_ControlledName.
                    "' already exists.");
                    PrintAutoRefreshPage("Error Message",
                        "SPT--SearchControlledName.php");     
                exit;
            }

            if(!empty($ResourceId))
            {
                $Resource = & new Resource($ResourceId);
                $Resource->Set($CN->TypeName(), $CN->Id());
            }
        }
    }
}    

# ----- MAIN -----------------------------------------------------------------

$NavDirCorrection = "../";
CheckAuthorization(PRIV_NAMEADMIN);

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

# get and pass through default type id
$DefaultTypeId = $Session->Get("DefaultTypeId");
$Session->PassVariable("DefaultTypeId", $DefaultTypeId);

if(substr($Submit, 0, 7) == "Add New")
    AddControlledName();
else
{
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_ControlledNameTypeId = $HTTP_POST_VARS["F_ControlledNameTypeId"];
    $Session->PassVariable("F_Variant", $F_Variant);
    $Session->PassVariable("F_ControlledName", $F_ControlledName);
    $Session->PassVariable("F_ControlledNameTypeId", $F_ControlledNameTypeId);
    PrintAutoRefreshPage("Add Controlled Names", "SPT--AddControlledName.php");
    exit;
}

#  <0 = temporary resource, >0 = existing resource
if($ResourceId != 0)
{
    PrintAutoRefreshPage("Add New Resource", "SPT--DBEntry.php");
    exit;
}
# just added new controlled name
else
{
    PageTitle("Add Controlled Name Complete");
    include("include/SPT--StandardHtmlPageLoad.php");
}

?>
