<?php
#
#   FILE:  SPT--DBEntry.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNames()
#           - Displays list of controllednames associated with a record
#             and buttons for adding and deleting them
#
#       GetClassification()
#           - Displays list of classifications associated with the record
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--ResourceFactory.php");

PageTitle("Add/Edit Resource Record");
# provide relative path to base SPT directory
$NavDirCorrection = "../";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the heading
function PrintHeading()
{
    global $ResourceId;

    if($ResourceId > 0)
        print "Edit Resource";
    else
        print "Add New Resource";
}

# print DBFieldName
function PrintDBFieldName()
{
    global $Field;

    print $Field->DBFieldName();
}

# print FieldId
function PrintFieldId()
{
    global $Field;

    print $Field->Id();
}

# print FieldId
function PrintDefinition()
{
    global $Field;

    print $Field->Description();
}

# print FieldName
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# print FieldName
function PrintTextFieldSize()
{
    global $Field;

    print $Field->TextFieldSize();
}

# print MaxLength
function PrintMaxLength()
{
    global $Field;

    print $Field->MaxLength();
}

# print FlagOnLabel 
function PrintFlagOnLabel()
{
    global $Field;

    print $Field->FlagOnLabel();
}

# print FlagOffLabel 
function PrintFlagOffLabel()
{
    global $Field;

    print $Field->FlagOffLabel();
}

# print ParagraphCols 
function PrintParagraphCols()
{
    global $Field;

    print $Field->ParagraphCols();
}

# print ParagraphRows
function PrintParagraphRows()
{
    global $Field;

    print $Field->ParagraphRows();
}

# print LabelSuffix 
function PrintLabelSuffix()
{
    global $LabelSuffix;

    print $LabelSuffix;
}

# print Field value
function PrintValue()
{
    global $Value;

    print GetHtmlEscapedString($Value);
}

# display the buttons
function DisplayButtons()
{
    global $ResourceId;

    if($ResourceId > 0)
        DisplayUpdateButtons();
    else
        DisplayAddButton();

    # display cancel button
    DisplayOtherButtons();
}

# print out ResourceId
function PrintResourceId()
{
    global $ResourceId;

    print $ResourceId;
}

# function Process Qualifiers
function ProcessQualifiers()
{
    global $Field;
    global $Result;
    global $QualifierId;

    # display qualifier if item level allowed
    if($Field->UsesQualifiers() && $Field->HasItemLevelQualifiers())
    {
        if(is_object($Result[$Field->Name()." Qualifier"]))
        {
            $Qualifier = $Result[$Field->Name()." Qualifier"]; 
            $QualifierId = $Qualifier->Id();
        }
        else
            $QualifierId = $Field->DefaultQualifier();

        DisplayQualifier();
    }
}

# display all fields
function DisplayAllFields()
{
    global $Result;
    global $LabelSuffix;
    global $Field;
    global $Value;
    global $QualifierId;
    global $User;
    global $ResourceId;
    global $SPTImage;
    global $LastType;

    $Resource = & new Resource($ResourceId);

    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(NULL, MDFORDER_EDITING);

    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            # end the row if last type was OPTION, and current type
            # is not an OPTION
            if($LastType != $Field->Type() && $LastType == MDFTYPE_OPTION)
                EndRowTag();

            if(!$Field->Optional())
                $LabelSuffix = "<span style=\"color:#CC0000\">*</span>";
            else
                $LabelSuffix = NULL;
            # get value if updating record
            $Default = $Field->DefaultValue(); 
            if(!empty($Result[$Field->Name()]))
                $Value = $Result[$Field->Name()];
            else if(isset($Default))
                $Value = $Default;
            else
                $Value = NULL;

            switch($Field->Type())
            {
                case MDFTYPE_NUMBER:
                    if($Field->Name() != "Cumulative Rating")
                        DisplayTextField();
                    break;

                case MDFTYPE_TEXT:
                    DisplayTextField();
                    break;

                case MDFTYPE_PARAGRAPH:
                    DisplayParagraph();
                    break;

                case MDFTYPE_DATE:
                    # get value if updating record
                    if(!empty($Result[$Field->Name()]))
                    {
                        $Date = $Result[$Field->Name()];
                        $Value = $Date->Formatted();
                    }
                    # use current date/time if not set and required
                    if(empty($Value) && !$Field->Optional()) 
                        $Value = date("Y-m-d");

                    DisplayTextField();
                    break;

                case MDFTYPE_TIMESTAMP:
                    if(!empty($Result[$Field->Name()]) && 
                        $Result[$Field->Name()] != "0000-00-00 00:00:00")
                        $Value = $Result[$Field->Name()];
                    # use current date/time if not set
                    else
                        $Value = date("Y-m-d H:i:s");

                    # Don't display Date Last Modified    
                    if($Field->Name() != "Date Last Modified")
                        DisplayTextField();
                    break;

                case MDFTYPE_FLAG:
                    # only allow user to change release flag if he has privilege
                    if($Field->DBFieldName() == "ReleaseFlag")
                    {
                        if($User->HasPriv(PRIV_RELEASEADMIN))
                            DisplayFlagField();
                        # display release flag read/only
                        else
                        {
                            if($Value > 0)
                                $LabelSuffix = $Field->FlagOnLabel();
                            else
                                $LabelSuffix = $Field->FlagOffLabel();
                            DisplayFlagFieldReadOnly();
                        }
                    }
                    else
                        DisplayFlagField();
				    break;

                case MDFTYPE_TREE:
                    DisplayTrees();
                    break;

                case MDFTYPE_OPTION:
                    DisplayOptionField();
                    break;

                case MDFTYPE_CONTROLLEDNAME:
                    DisplayNameBegin();
                    DisplayControlledNames();
                    DisplayNameEnd();
                    break;

                case MDFTYPE_USER:
                    $UserObj = $Value;
                    if(is_object($UserObj))
                    {
                        $UserId = $UserObj->Get("UserId");
                        $UserName = $UserObj->Get("UserName");
                        $UserEmail = $UserObj->Get("Email");     
                    }
                    # unknown UserId
                    if(is_null($UserId)) 
                    {
                        $UserName = "Unknown";
                        $UserEmail = "";
                    }
                    DisplayUserField($Field, $UserName, $UserEmail,
                            $Result["Title"]);

                    break;

                case MDFTYPE_IMAGE:
                    DisplayImageBegin();
                    if(is_object($Resource))
                    {
                        $SPTImage = $Resource->GetByField($Field, TRUE);
                    }
                    DisplayImageEnd();
                    break;
            }
            # suppress qualifiers for options and controlled names 
            if(!($Field->Type() & MDFTYPE_OPTION|MDFTYPE_CONTROLLEDNAME))
                ProcessQualifiers();

            # save type of last processed field
            $LastType = $Field->Type();
        }
    }
}

# print Qualifier option list
function PrintQualifierList()
{
    global $Field;
    global $QualifierId;

    $QualifierFieldName = $Field->DBFieldName()."Qualifier";

    # first entry is "--"
    $Items = $Field->AssociatedQualifierList();
    $Items["--"] = "--";
    ksort($Items);

    PrintOptionList($QualifierFieldName, $Items, $QualifierId,
        0, 1, NULL, false);
}

# print selected for flag label if flag is set
function PrintSelectedIfFlagSet()
{
    global $Value;

    # Must accomodate negative ReleaseFlag used for temp records
    if($Value > 0)
        print " selected";
}

# print selected for flag label if flag not set
function PrintSelectedIfFlagNotSet()
{
    global $Value;

    # Must accomodate negative ReleaseFlag used for temp records
    if($Value <= 0)
        print " selected";
}

# display controlled names and buttons
function DisplayControlledNames()
{
    global $ResourceId;
    global $RowsPerName;
    global $LabelSuffix;
    global $Index;
    global $Field;
    global $Value;
    global $ControlledNameId;
    global $QualifierId;

    # retrieve list of entries for field
    $Resource = & new Resource($ResourceId);
    if(is_object($Resource))
    {
        $Names = $Resource->GetByField($Field);
    }

    # Get the schema
    $Schema = & new MetadataSchema();

    # get array of qualifiers
    $Qualifiers = $Resource->GetQualifierByField($Field, FALSE);
    
    # for each entry
    $Index = 0;
    $RowsPerName = count($Names);
    foreach ($Names as $ControlledNameId => $Value)
    {
        if($Value != "")
        {
            if(is_array($Qualifiers))
                $QualifierId = $Qualifiers[$ControlledNameId];
            else
                $QualifierId = $Qualifiers;
             DisplayControlledNameValue();
        }    
        $Index++;
    }
}

# display Trees associated with this resource 
function DisplayTrees()
{
    global $ResourceId;
    global $ClassificationId;
    global $SubHeading;
    global $QualifierId;
    global $LabelSuffix;
    global $Index;
    global $Field;
    global $GenericId;
    global $RowsPerName;

    $Resource = & new Resource($ResourceId);
    if(is_object($Resource))
        $Classifications = $Resource->Classifications();

    DisplayNameBegin();

    # Get the schema
    $Schema = & new MetadataSchema();

    # get array of qualifiers
    $Qualifiers = $Resource->GetQualifierByField($Field, FALSE);

    $RowsPerName = 0;
    foreach($Classifications as $ClassificationType => $ClassificationTypes)    
    {
        if($ClassificationType == $Field->Name())
        {
            $Index = 0;
            $RowsPerName = count($ClassificationTypes);
            foreach($ClassificationTypes as $GenericId => $Classification)
            {
                $SubHeading = stripslashes($Classification);
                $ClassificationType = stripslashes($ClassificationType);
                $Field = $Schema->GetFieldByName($ClassificationType);
                $ClassificationId = 
                    GetClassificationTypeId($ClassificationType);
                if(is_array($Qualifiers))
                    $QualifierId = $Qualifiers[$GenericId];
                else
                    $QualifierId = $Qualifiers;

                if(!empty($Classification) && isset($Field)) 
                    DisplayClassificationValue();
                $Index++;
            }
        }
    }    
    DisplayNameEnd();
} 

# display option fields
function DisplayOptionField()
{
    global $ResourceId;
    global $Field;
    global $Value;
    global $LabelSuffix;
    global $LastType;
    global $HTTP_GET_VARS;

    # Get the schema
    $Schema = & new MetadataSchema();

    $Resource = & new Resource($ResourceId);
    $Names = $Resource->GetByField($Field);

    if($LastType != MDFTYPE_OPTION)
        StartRowTag();

    if($Field->AllowMultiple())
        $Rows = 4;
    else
        $Rows = 1;

    DisplayOptionBegin();
    print "<br>";

    if(isset($HTTP_GET_VARS["AddNewResource"]))
        $Selected = $Field->DefaultValue();
    else if(isset($ResourceId))
    {
        foreach ($Names as $GenericId => $Value)
        {
            $Selected[] = $GenericId; 
        }
    }
    DisplayControlledNameListForName($Field->DBFieldName(), 
        $Field->Name(), "--", $Selected, 4, 
        $Field->AllowMultiple(), FALSE);
    DisplayOptionEnd();    
}

# return if rows exist or not for controllednames, classifications
function RowsExist()
{
    global $RowsPerName;

    return $RowsPerName;
}

# print ControlledNameId
function PrintControlledNameId()
{
    global $ControlledNameId;

    print $ControlledNameId;
}

# print qualifier name (in parens)
function PrintQualifierName()
{
    global $Field;
    global $QualifierId;

    # only print if it exists
    if($Field->UsesQualifiers() && $QualifierId > 0)
    {
        $Qualifier = & new Qualifier($QualifierId);
        print " <small>(<a href=\"".$Qualifier->Url()."\">".
            $Qualifier->Name()."</a>)</small>";
    }
}

# print ClassificationId
function PrintClassificationId()
{
    global $GenericId;

    print $GenericId;
}

# print SubHeading 
function PrintSubHeading()
{
    global $SubHeading;

    print $SubHeading;
}

# print Index 
function PrintIndex()
{
    global $Index;

    print $Index;
}

# print Url
function PrintUrl()
{
    global $SPTImage;
    global $NavDirCorrection;
    global $Field;
    global $ResourceId;

    $FieldName = $Field->DBFieldName();
    print $NavDirCorrection.
        "/SPT--FullImage.php?ResourceId=${ResourceId}&FieldName=${FieldName}&edit=1";
}

# print ThumbnailUrl
function PrintThumbnailUrl()
{
    global $SPTImage;

    print $SPTImage->ThumbnailUrl();
}

# print ThumbnailUrl
function PrintAltText()
{
    global $SPTImage;

    if(isset($SPTImage))
        print GetHtmlEscapedString($SPTImage->AltText());
}

# print ThumbnailUrl
function ImageExists()
{
    global $SPTImage;

    if(isset($SPTImage))
        return (is_readable($SPTImage->ThumbnailUrl())) ? true : false;
    else
        return false;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process Delete or Duplicate Resource Record
function DeleteDuplicateResourceRecord()
{
    global $HTTP_POST_VARS, $Session, $ResourceId;

    $Session->PassVariable($HTTP_POST_VARS["F_Action"]);
    PrintAutoRefreshPage("Delete/Duplicate Record",
        "SPT--DeleteDuplicateRecord.php");
    exit;
}

# get resource record fields if updating an existing resource
function GetResourceRecord()
{
    global $ResourceId, $Resource, $Result;

    $Resource = & new Resource($ResourceId);
    $Result = $Resource->GetAsArray();
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

$RFactory = & new ResourceFactory();

# see if editing an existing resource
if(isset($HTTP_GET_VARS["ResourceId"]))
{
    $ResourceId = $HTTP_GET_VARS["ResourceId"];
    $RFactory->SetCurrentEditedItemId($ResourceId);
}
# came here from MD side nav "Add New Resource" 
else if(isset($HTTP_GET_VARS["AddNewResource"]))
{
    # clear out any previous old temp resource
    $ResourceId = $RFactory->GetCurrentEditedItemId();
    if(isset($ResourceId))
    {
        $Resource = & new Resource($ResourceId);
        if($Resource->IsTempResource())
        {
            $Resource->Delete();
        }
        $RFactory->ClearCurrentEditedItemId();
    }
    # force creation of new resource below 
    $ResourceId = NULL;
}
# middle of processing an existing record
else
{
    $ResourceId = $RFactory->GetCurrentEditedItemId();
}

# nothing being edited, so create a new resource
if(is_null($ResourceId))
{
    $Resource = & new Resource();
    $ResourceId = $Resource->Id();
    $RFactory->SetCurrentEditedItemId($ResourceId);
}

# pass thru ResourceId
if($ResourceId)
{
    GetResourceRecord();
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
