<?php

#
#   FILE:  SPT--ImportDataExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitImportVars()
{
    global $ImportComplete, $FSeek, $ResourceCount;
    global $ControlledNameCount, $ClassificationCount;

    if(is_null($ImportComplete))
        $ImportComplete = 0;
    if(is_null($FSeek))
        $FSeek = 0;
    if(is_null($ResourceCount))
        $ResourceCount = 0;
    if(is_null($ControlledNameCount))
        $ControlledNameCount = 0;
    if(is_null($ClassificationCount))
        $ClassificationCount = 0;
}

# increment the classification resource count
function IncrementClassificationResourceCount($ClassificationId)
{
    $ClassDB =& new SPTDatabase();

    # do
    do
    {
        # increment resource count for classification
        $ClassDB->Query("UPDATE Classifications "
                ."SET ResourceCount=ResourceCount+1 "
                ."WHERE ClassificationId=".$ClassificationId);

        # set new classification to parent of current classification
        $ClassDB->Query("SELECT ParentId FROM Classifications "
                ."WHERE ClassificationId=".$ClassificationId);
        $Class = $ClassDB->FetchNextRowArray();
        $ClassificationId = $Class["ParentId"];

    # while classification is not null
    } while (($ClassificationId == "0") || ($ClassificationId > 0));
}

# rebuild classification counts
function RebuildClassificationResourceCounts()
{
    # clear resource counts for all classifications
    $ClassDB =& new SPTDatabase();
    $ClassDB->Query("UPDATE Classifications SET ResourceCount=0");

    # for each resource
    $ResourceDB =& new SPTDatabase();
    $ResourceDB->Query("SELECT ResourceId FROM Resources");
    while ($Resource = $ResourceDB->FetchNextRowArray())
    {
        # for each classification assigned to resource
        $ClassDB->Query("SELECT * FROM ResourceClassInts WHERE ResourceId="
                .$Resource["ResourceId"]);
        while ($ClassInt = $ClassDB->FetchNextRowArray())
        {
            # increment resource count for classification and all parents
            IncrementClassificationResourceCount($ClassInt["ClassificationId"]);
        }
    }
}

# first time through, create empty placeholders
function FirstTimeThrough()
{
    global $TotalLineCount, $ResourceCount, $ControlledNameCount, $FSeek;
    global $ClassificationCount, $DB, $fp, $Insert, $InsertArray, $NameArray;
    global $Session, $NumberOfFields, $Debug;

    $Schema = & new MetadataSchema();

    # read in line from import file
    $fline = fgets($fp, 4096);
    $FSeek += strlen($fline);

    if($Debug)
        echo "fline=$fline<br>";

    # parse line from import file
    $Vars = explode("\t", $fline);

    $NumberOfFields = 0;
    foreach($Vars as $Var)
    {
        $Var = trim($Var);
        if (substr($Var, 0, 10) != "Controlled" &&
            $Var != "ClassificationTypeName" &&
            $Var != "ClassificationName" &&
            $Var != "ClassificationTypeId")
        {
            $Field = $Schema->GetFieldByName($Var);
            if(is_null($Field))
            {
                $Session->PassVariable("ImportComplete", $ImportComplete);
                $ErrorMessage = 
                    "Error: Unknown metadata field name = \"".$Var.
                    "\" encountered.<br>".
                    "This must match the field name ".
                    "in the Metadata Field Editor.<br>".
                    "Please select Back and correct the problem ". 
                    "on the first line.";
                $Session->PassVariable("ErrorMessage", $ErrorMessage);
                PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
                $ImportComplete = 1;
                $FSeek = 0;
                exit;
            }
            $DBName = $Field->DBFieldName();

            # build an array of date fields for special handling
            if($Field->Type() & MDFTYPE_DATE)
            {
                $Insert .= $DBName."Begin, ".$DBName."End, ".
                            $DBName."Precision, ";
            }
            # Controlled names are not inserted to Resources
            else if($Field->Type() & 
                (MDFTYPE_CONTROLLEDNAME|MDFTYPE_OPTION|MDFTYPE_TREE))
            {
                ;
            }
            else
            {
                $Insert .= "$DBName, ";
            }
            if($Debug)
                echo "Inserting $DBName, Name array=$Var<br>";
            $InsertArray[] = $DBName;
            $NameArray[] = $Var;
        }
        # don't store names for ControlledName or Classification
        else
        {
            $InsertArray[] = $Var;
        }
        $NumberOfFields++;
    }

    # see if ReleaseFlag, AddedById & LastModifiedId, DateOfRecordCreation
    # have been specified 
    if(!array_search("ReleaseFlag", $InsertArray, TRUE))
        $Insert .= "ReleaseFlag, "; 
    if(!array_search("LastModifiedById", $InsertArray, TRUE))
        $Insert .= "LastModifiedById, "; 
    if(!array_search("AddedById", $InsertArray, TRUE))
        $Insert .= "AddedById, "; 
    if(!array_search("DateOfRecordCreation", $InsertArray, TRUE))
        $Insert .= "DateOfRecordCreation, "; 
    if(!array_search("DateLastModified", $InsertArray, TRUE))
        $Insert .= "DateLastModified, "; 

    # must set ResourceId explicitly
    $Insert .= "ResourceId)";

    # zero out counters
    $TotalLineCount = 1;        # count the first header line
    $ResourceCount = 0;
    $ControlledNameCount = 0;
    $ClassificationCount = 0;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $DB, $fp, $Session, $FSeek, $Title, $ImportComplete, $NameArray;
    global $User, $ResourceCount, $ControlledNameCount, $ClassificationCount;
    global $TotalLineCount, $ReleaseFlag, $Insert, $InsertArray, $User;
    global $ControlledName, $ControlledNameTypeName, $NumberOfFields;
    global $Debug;

    $Schema = & new MetadataSchema();
    $Factory =& new ResourceFactory();

    $LineCount = 0;

    # user current user for AddedById, LastModifiedById
    # current date for DateOfRecordCreation
    $CurrentUserId = $User->Get("UserId");
    $TodaysDate = date("Y-m-d H:i:s");

    while (!feof($fp) && $LineCount < 50 && $ImportComplete == 0)
    {
        # read in line from import file
        $fline = fgets($fp, 16384);

        if($Debug)
            echo "fline=$fline<br>";
    
        # update variables 
        $LineCount++;
        $TotalLineCount++;
        $ControlledName = array();
        $ControlledNameTypeName = array();
        $Session->PassVariable("TotalLineCount", $TotalLineCount);
        $FSeek += strlen($fline);
        $Session->PassVariable("FSeek", $FSeek);

        $Value = NULL;    
        # parse line from import file
        $Vars = explode("\t", $fline);
        $NumberOfVars = count($Vars);

        # bail out if line was empty or end of file encountered
        if($NumberOfVars < 1 || feof($fp))
        {
            $ImportComplete = 1;
            break;
        }
        
        # make sure number of vars on line match number of fields in header
        if($NumberOfVars != $NumberOfFields)
        {
            $Session->PassVariable("ImportComplete", $ImportComplete);
            $ErrorMessage =
                "Error: incorrect field count on line $TotalLineCount.<br>". 
                "Expected $NumberOfFields, encountered $NumberOfVars<br>".
                "Correct the problem and try importing again.<br>"; 
           $Session->PassVariable("ErrorMessage", $ErrorMessage);
           PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
            $ImportComplete = 1;
            $FSeek = 0;
            exit;
        }
        
        # process each var
        foreach($Vars as $Index => $Var)
        {
            if($Debug)
                echo "InsertArray=".$InsertArray[$Index]."<br>";
            if($InsertArray[$Index] == "ReleaseFlag")
            {
                # -1 means use the value in the file
                if($ReleaseFlag == -1)
                    $Value .= "\"".addslashes($Var)."\", "; 
                else
                    $Value .= "\"".$ReleaseFlag."\", "; 
            }
            else if($InsertArray[$Index] == "AddedById")
            {
                $DBName = $InsertArray[$Index];
                global ${"$DBName"};

                # use value from file if set
                if(!empty($Var))
                    ${"$DBName"} = $Var;
                # otherwise default to current user
                else
                    ${"$DBName"} = $CurrentUserId;
                $Value .= "\"".${"$DBName"}."\", "; 
            }
            else if($InsertArray[$Index] == "LastModifiedById")
            {
                $DBName = $InsertArray[$Index];
                global ${"$DBName"};
                # use value from file if set
                if(!empty($Var))
                    ${"$DBName"} = $Var;
                # otherwise default to current user
                else
                    ${"$DBName"} = $CurrentUserId;
                $Value .= "\"".${"$DBName"}."\", "; 
            }
            else if($InsertArray[$Index] == "DateOfRecordCreation" ||
                    $InsertArray[$Index] == "DateLastModified")
            {
                $DBName = $InsertArray[$Index];
                global ${"$DBName"};

                # assume "date time" format
                if(!empty($Var)) 
                {
                    $DORC = explode(" ", $Var);

                    # parse date part
                    $Date = & new SPTDate($DORC[0]);
                    $DateBegin = $Date->BeginDate();

                    # add in time if present
                    ${"$DBName"} = $DateBegin." ".$DORC[1];
                }    
                else 
                    ${"$DBName"} = $TodaysDate;
                $Value .= "\"".${"$DBName"}."\", "; 
            }
            else if(substr($InsertArray[$Index], 0, 10) == "Controlled")
            {
                $DBName = trim($InsertArray[$Index]);
                global ${"$DBName"};
                if($DBName == "ControlledNameTypeName" && !empty($Var))
                {
                    $ControlledNameTypeName[] = $Var;
                }
                else if($DBName == "ControlledName" && !empty($Var))
                {
                    $ControlledName[] = $Var;
                }
            }
            else if($InsertArray[$Index] == "ClassificationTypeName" ||
                $InsertArray[$Index] == "ClassificationType" ||
                $InsertArray[$Index] == "ClassificationName" ||
                $InsertArray[$Index] == "ClassificationTypeId")
            {
                $DBName = trim($InsertArray[$Index]);
                global ${"$DBName"};
                ${"$DBName"} = $Var;
                if($DBName == "ClassificationTypeName" && !empty($Var))
                {
                    $ClassificationTypeId = GetClassificationTypeId($Var);
                }
                else if($DBName == "ClassificationTypeId" && !empty($Var))
                {
                    $ClassificationTypeId = $Var;
                }
                else if($DBName == "ClassificationName" && !empty($Var))
                {
                    $ClassificationName = $Var;
                }
            }
            # special handling required for dates
            else
            {
                $Field = $Schema->GetFieldByName($NameArray[$Index]);
                if($Debug)
                {
                    echo "Name=".$NameArray[$Index].
                        ", Index=$Index, Var=$Var<br>";
                    if(!is_null($Field))    
                        echo "Field Name = ".$Field->Name()."<br>";
                }
                if(!is_null($Field) && ($Field->Type() & MDFTYPE_DATE))
                {
                    $DBName = trim($InsertArray[$Index]);
                    $Date = & new SPTDate($Var);
                    $DateBegin = $Date->BeginDate();
                    $DateEnd = $Date->EndDate();
                    $DatePrecision = $Date->Precision();
                    $Value .= "\"".$DateBegin."\", ";
                    $Value .= "\"".$DateEnd."\", ";
                    $Value .= "\"".$DatePrecision."\", ";

                    global ${"$DateBegin"};
                    global ${"$DateEnd"};
                    global ${"$DatePrecision"};
                }
                # controlled name field
                else if(!is_null($Field) && $Field->Type() & 
                    (MDFTYPE_CONTROLLEDNAME | MDFTYPE_OPTION))
                {
                    $DBName = trim($InsertArray[$Index]);
                    global ${"$DBName"};
                    $ControlledNameTypeName[] = $Field->Name();
                    $ControlledName[] = $Var;
                }
                # classification type field
                else if(!is_null($Field) && $Field->Type() & MDFTYPE_TREE)
                {
                    $DBName = trim($InsertArray[$Index]);
                    global ${"$DBName"};
                    $ClassificationTypeId = 
                        GetClassificationTypeId($Field->Name());
                    $ClassificationName = $Var;
                    if($Debug)
                        echo "DBName=$DBName, TypeId=$ClassificationTypeId, Name=$ClassificationName<br>";
                }
                else
                {
                    $DBName = $InsertArray[$Index];
                    global ${"$DBName"};
                    $Value .= "\"".addslashes($Var)."\", "; 
                    ${"$DBName"} = addslashes($Var);
                }
            }
        }

        # see if ReleaseFlag, AddedById, LastModifiedId, DateOfRecord Creation
        # have been set
        if(!array_search("ReleaseFlag", $InsertArray, TRUE))
        {
            # user has indicated use file value, but not specified in header
            # so default to unreleased in that case
            if($ReleaseFlag == -1)
                $ReleaseFlag = 0;
            $Value .= "\"".$ReleaseFlag."\", "; 
        }
        if(!array_search("LastModifiedById", $InsertArray, TRUE))
            $Value .= "\"".$CurrentUserId."\", "; 
        if(!array_search("AddedById", $InsertArray, TRUE))
            $Value .= "\"".$CurrentUserId."\", "; 
        if(!array_search("DateOfRecordCreation", $InsertArray, TRUE))
            $Value .= "\"".$TodaysDate."\", "; 
        if(!array_search("DateLastModified", $InsertArray, TRUE))
            $Value .= "\"".$TodaysDate."\", "; 
        
        # RESOURCES
        # see if the resource already exists in the DB
        # if Title is empty, then use last Resource Id

        if(!empty($Title) && $Title != $LastTitle)
        {
            $query = "Select * from Resources where Title=\"".$Title.
                    "\" AND Description=\"".$Description."\"";
            $DB->Query($query);

            if($DB->NumRowsSelected() == 0)
            {
                # get next available ResourceId, and set explicitly
                $ResourceId = $Factory->GetNextItemId();
                $Value .= "\"".$ResourceId."\")";

                $query = "Insert into Resources (";
                $query .= $Insert;
                $query .= " Values ( ";
                $query .= $Value;

                if($Debug)
                    echo "Insert query=$query<br>";
                $DB->Query($query);
                $LastTitle = $Title;

                # keep track of number of resources added
                $ResourceCount++;
                $Session->PassVariable("ResourceCount", $ResourceCount);
    
                # now reselect the record just added
#                $query = "Select LAST_INSERT_ID() AS ResourceId from Resources";
#                $DB->Query($query);
            }
            else if($DB->NumRowsSelected() > 1)
            {
                $Session->PassVariable("ImportComplete", $ImportComplete);
                $ErrorMessage = 
                    "Error: Multiple Resources with Title = \"".$Title.
                    "\" encountered.<br>".
                    "Please select Back and correct the problem on line ".
                    $TotalLineCount.".";
                $Session->PassVariable("ErrorMessage", $ErrorMessage);
                PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
                $ImportComplete = 1;
                $FSeek = 0;
                exit;
            }
            else
            {
                # should only be one matching Resources record
                $result = $DB->FetchNextRowArray();
                $ResourceId = $result[ResourceId];
            }
        }
    
        # CONTROLLED NAMES
    
        # first look up the name in ControlledNameTypes to get the id
        if(is_array($ControlledNameTypeName))
        {
            foreach($ControlledNameTypeName as $Index => $CNTN)
            {
                if(!empty($CNTN))
                {
                    $CNTN = addslashes($CNTN);
                    # check to see if the ControlledName already exists or not
                    $query = "Select ControlledNameTypeId from ".
                        "ControlledNameTypes ".
                        "where ControlledNameTypeName=\"".$CNTN."\"";

                    if($Debug)
                        echo "query=$query<br>";    
                    $DB->Query($query);
    
                    # doesn't exist, that's an error
                    if($DB->NumRowsSelected() == 0)
                    {
                        $Session->PassVariable("ImportComplete",
                            $ImportComplete);
                        $ErrorMessage =
                            "Invalid ControlledNameTypeName encountered: ".
                            $CNTN." on line ".$TotalLineCount;
                        $Session->PassVariable("ErrorMessage", $ErrorMessage);
                        PrintAutoRefreshPage("Import Data", 
                            "SPT--ImportData.php");
                        $ImportComplete = 1;
                        $FSeek = 0;
                        exit;
                    }
                    # found it, now get the ControlledNameTypeId
                    else
                    {
                        $result = $DB->FetchNextRowArray();
                        $ControlledNameTypeId = $result["ControlledNameTypeId"];
                    }
                    # get the actual ControlledName
                    $CN = addslashes($ControlledName[$Index]);
                    if(!empty($CN))
                    {
                        # check to see if the ControlledName already exists
                        $query = "Select ControlledNameId from ".
                            "ControlledNames ".
                            "where ControlledName=\"".$CN."\" ".
                            "and ControlledNameTypeId=\"".
                            $ControlledNameTypeId."\"";
                    }
                    # empty, so don't process
                    else
                    {
                        continue;
                    }        
                    if($Debug)
                        echo "search query=$query<br>";
                    $DB->Query($query);
    
                    # this ControlledName doesn't exist, so add it in
                    if($DB->NumRowsSelected() == 0)
                    {
                        $query = "Insert into ControlledNames(". 
                                "ControlledNameId, ".
                                "ControlledName, ".
                                "ControlledNameTypeId)".
                                "Values ( ".
                                "NULL,".
                                "\"$CN\", ".
                                "\"$ControlledNameTypeId\")";

                        if($Debug)
                            echo "insert CN query=$query<br>";
                        $DB->Query($query);
    
                        $ControlledNameCount++;         
                        $Session->PassVariable("ControlledNameCount", 
                            $ControlledNameCount);
    
                        # now get the record just added
                        $query = "Select ControlledNameId ".
                            "from ControlledNames ".
                            "where ControlledName=\"".$CN."\" ".
                            "and ControlledNameTypeId=\"".
                            $ControlledNameTypeId."\"";
                        if($Debug)    
                            echo "query=$query<br>";
                        $DB->Query($query);
                    }
                    else if($DB->NumRowsSelected() > 1)
                    {
                        $Session->PassVariable("ImportComplete", 
                            $ImportComplete);
                        $ErrorMessage  =
                            "Error: Multiple ControlledNames with value = \"".
                            $CN.
                            "\" found on Line $TotalLineCount.<br>";
                        $Session->PassVariable("ErrorMessage", $ErrorMessage);
                        PrintAutoRefreshPage("Import Data", 
                            "SPT--ImportData.php");
                        $ImportComplete = 1;
                        $FSeek = 0;
                        exit;
                    }

                    # should only be one matching ControlledName record
                    $result = $DB->FetchNextRowArray();
                    $ControlledNameId = $result[ControlledNameId];

                    if(isset($ResourceId) && $ResourceId > 0)
                    {
                        # see if intersection record for this ControlledName
                        # already exists
                        $query = "Select ResourceId from ResourceNameInts ".
                            "where ResourceId = \"".$ResourceId."\" ".
                            "and ControlledNameId = \" ".$ControlledNameId."\"";
                        if($Debug)        
                            echo "query=$query<br>"; 
                        $DB->Query($query);
    
                        # if no intersection record, insert one
                        if($DB->NumRowsSelected() == 0)
                        {
                            $query = "Insert into ResourceNameInts(".
                                "ResourceId, ".
                                "ControlledNameId)".
                                "Values ( ".
                                "\"$ResourceId\", ".
                                "\"$ControlledNameId\")";
                            if($Debug)    
                                echo "query=$query<br>";
                            $DB->Query($query);
                        }
                    }
                }
            }
        }
                    
        # CLASSIFICATIONS

        if(!empty($ClassificationName))
        {
            # split class into individual subject pieces
            $ClassName = trim($ClassificationName);
            $Pieces = preg_split("/--/", $ClassName);

            # start with current parent set to null
            $ParentId = -1;
    
            # start with class string set to null
            $ClassString = "";
    
            # reset class depth
            $Depth = 0;
    
            # for each piece
            foreach ($Pieces as $Piece)
            {
                # strip off any extraneous whitespace
                $Piece = addslashes(trim($Piece));
    
                # add piece to class string
                if ($ClassString != "") {  $ClassString .= " -- ";  }
                $ClassString = $ClassString.$Piece;
    
                # if piece does not exist with current parent
                $query = "SELECT * FROM Classifications WHERE ".
                    " SegmentName = '".$Piece."'".
                    " AND ParentId = ".$ParentId.
                    " AND ClassificationTypeId = ".$ClassificationTypeId;

                if($Debug)
                    echo $query."<br>";

                $DB->Query($query);

                if ($DB->NumRowsSelected() < 1)
                {
                    # add new class entry
                    $query = sprintf("INSERT INTO Classifications (".
                            "ClassificationTypeId, ".
                            "ClassificationName, ".
                            "Depth, ".
                            "ParentId, ".
                            "SegmentName) VALUES ".
                        "($ClassificationTypeId, '%s', %d, %d, '%s')",
                            $ClassString,
                            $Depth,
                            $ParentId,
                            $Piece);

                    if($Debug)
                        echo "class query=$query<br>";
                    $DB->Query($query);

                    if($Debug)             
                        printf("<b>Class = &quot;%s&quot;</b><br>\n",
                            $ClassString);
    
                    $ClassificationCount++;
                    $Session->PassVariable("ClassificationCount",
                        $ClassificationCount);
                
                    # set parent to entry just added
                    $DB->Query("SELECT LAST_INSERT_ID() AS InsertId ".
                        "FROM Classifications");
                    $Record = $DB->FetchNextRowArray();
                    $ParentId = $Record["InsertId"];
                }
                else
                {
                    # set parent to current entry
                    $Record = $DB->FetchNextRowArray();
                    $ParentId = $Record["ClassificationId"];
                }
                # increment class depth
                $Depth++;
            }
        }
    
        if($ClassName == "")
            $ParentId = $ClassificationId;

        if(isset($ResourceId) && $ResourceId > 0)
        {
            # check for existing intersection record    
            $query = "Select ResourceId from ResourceClassInts where ".
                    "ResourceId = \"".$ResourceId."\" ".
                    "and ClassificationId = \" ".$ParentId."\"";

            if($Debug)    
                echo "query=$query<br>";
            $DB->Query($query);
    
            # if no intersection record, insert one in
            if($DB->NumRowsSelected() == 0)
            {
                # add classification link to point to new classification
                $DB->Query("Insert into ResourceClassInts(".
                                "ResourceId, ClassificationId)".
                            "VALUES(".
                                "\"$ResourceId\", ".
                                "\"$ParentId\")");
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB =& new SPTDatabase();
$ClassDB =& new SPTDatabase();

InitImportVars();

# check for Cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    $ImportComplete = 1;
    PrintAutoRefreshPage("System Administration", 
        $NavDirCorrection."SPT--SysAdmin.php");
    exit;
}

$Debug = $HTTP_POST_VARS["Debug"];
if($Debug)
{
    echo "filename=".$HTTP_POST_FILES['F_FileName']['tmp_name']."<br>";
    echo "Total Line Count = ".$TotalLineCount."<br>";
}

# open import file for reading
if (is_uploaded_file($HTTP_POST_FILES['F_FileName']['tmp_name']))
{
    # zero length or tiny file
    if($HTTP_POST_FILES['F_FileName']['size'] == 0)
    {
        $ErrorMessage = "Error: File doesn't exist or is empty.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
        exit;
    }

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $TempFile = dirname($ScriptFileName).
        "/".$NavDirCorrection."TempStorage/".
        $_FILES['F_FileName']['name'];

    copy($HTTP_POST_FILES['F_FileName']['tmp_name'], $TempFile);
    $fp = fopen($TempFile, 'r');
    unlink($HTTP_POST_FILES['F_FileName']['tmp_name']);
}
else if($FSeek > 0)
{
    $fp = fopen($TempFile, 'r');
}
else
{
    switch($HTTP_POST_FILES['F_FileName']['error'])
    {
        # no error; possible file attack!
        case 0:
            $ErrorMessage = "There was a problem with your upload.";
            break;

        # uploaded file exceeds the upload_max_filesize directive in php.ini
        case 1:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;

        # uploaded file exceeds the MAX_FILE_SIZE directive that
        # was specified in the html form
        case 2:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;
            
        # uploaded file was only partially uploaded
        case 3:
            $ErrorMessage = 
                "The file you are trying upload was only partially uploaded.";
            break;

        # no file was uploaded
        case 4:
            $ErrorMessage = "You must select a file for upload.";
            break;

        # a default error, just in case!
        default:
            echo "There was a problem with your upload.";
            break;
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
    exit;
}

# first time through
if($FSeek == 0)
{
    FirstTimeThrough();
}

# echo "FSeek=$FSeek, FileName=$F_FileName<br>";

# seek to the next line
if($FSeek > 0)
{
    fseek($fp, $FSeek);
}

# the main work happenes here
DoWhileLoop();

# end of file reached?
if (feof($fp) || $ImportComplete)
{
    RebuildClassificationResourceCounts();
    $ImportComplete = 1;
}
# register some key variables for other html code
$Session->PassVariable("ReleaseFlag", $ReleaseFlag);
$Session->PassVariable("ImportComplete", $ImportComplete);
$Session->PassVariable("ResourceCount", $ResourceCount);
$Session->PassVariable("ControlledNameCount", $ControlledNameCount);
$Session->PassVariable("ClassificationCount", $ClassificationCount);
$Session->PassVariable("TotalLineCount", $TotalLineCount);
$Session->PassVariable("InsertArray", $InsertArray);
$Session->PassVariable("NameArray", $NameArray);
$Session->PassVariable("Insert", $Insert);
$Session->PassVariable("FSeek", $FSeek);
$Session->PassVariable("TempFile", $TempFile);
$Session->PassVariable("NumberOfFields", $NumberOfFields);

#  Time to auto-refresh?
if($ImportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ImportDataExecute.php";
}

PageTitle("Import Data");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");

if ($ImportComplete == 1)
{
    fclose($fp);
    # remove temporary uploaded file
    unlink($TempFile);
}

?>
