<?php
#
#   FILE:  SPT--SearchClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintResourceId()
#       - print out ResourceId
#
#       DisplayClassificationInfo()
#       - displays classification info from a query
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print out Resource Id
function ClassificationsExist()
{
    global $NumRows;

    return $NumRows;
}

# function to see if Form variable F_Class is empty or not
function SearchEntered()
{
    global $F_Class;

    return (empty($F_Class)) ? false : true;
}

# function to print ClassificationName
function PrintClassificationName()
{
    global $ClassificationName;

    print $ClassificationName;
}

# function to print ClassificationTypeName
function PrintClassificationTypeName()
{
    global $Field;

    print $Field->Name();
}

# function to print ClassificationId
function PrintClassificationId()
{
    global $ClassificationId;

    print $ClassificationId;
}

# function to print ClassificationId
function PrintIndex()
{
    global $Index;

    print $Index;
}

# function to print ResourceCount 
function PrintResourceCount()
{
    global $ResourceCount;

    print $ResourceCount;
}

# display classification info
function DisplayClassificationInfo()
{
    global $F_Class;
    global $HTTP_POST_VARS;
    global $DB;
    global $User;
    global $ResourceId;
    global $NumRows;
    global $Index;
    global $ResourceCount;
    global $ClassificationName;
    global $ClassificationId;
    global $Field;

    if(!empty($F_Class))
    {
        $F_Class = stripslashes($F_Class);
        trim($F_Class);

        # extract ClassificationTypeId
        $ClassificationTypeId = GetClassificationTypeId($Field->Name());
    
        # replace white space with wild cards 
        $F_Class = str_replace(" ", ".*.", $F_Class);       

        # this query gets us close
        $Query = "Select * from Classifications ".
                "WHERE (ClassificationName REGEXP \"$F_Class\") ".
                "AND ClassificationTypeId=$ClassificationTypeId ".
                "ORDER BY ClassificationName";

        $DB->Query("$Query");
    
        $Index=0;

        $NumRows = $DB->NumRowsSelected();
     
        if($NumRows > 0)
        {
            DisplayHeading();
            while($Index < $DB->NumRowsSelected())
            {
      
                $Result = $DB->FetchNextRowArray();
                $ClassificationName = $Result["ClassificationName"];    
                $ClassificationId = $Result["ClassificationId"];
                $ResourceCount = $Result["ResourceCount"];
                DisplayClassificationSelection();
                $Index++;
            }
            DisplayAssignButtons();
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

$Schema = & new MetadataSchema();

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

# grab entry information from database
$DB =& new SPTDatabase();

# class is gotten from previous form
$F_Class = stripslashes($HTTP_POST_VARS["F_Class"]);

# Determine which tree we should search
$FieldId = $Session->Get("FieldId");
$Field = $Schema->GetField($FieldId);
$Session->PassVariable("FieldId", $FieldId);

# handle Cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

trim($F_Class);

PageTitle("Assign Classifications (".$Field->Name().")");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");


?>
