<?php
#
#   FILE:  SPT--UpdateControlledNameList.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove list value
function RemoveListValue()
{
    global $HTTP_POST_VARS, $DB;

    while (list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if(ereg("cnid_([0-9]+)", $Var, $Regs))
        {
            if(!empty($Value))
            { 
                $CN = & new ControlledName($Value);
                $CN->Delete();
            }
        }
    }
}

# add list value
function AddListValue()
{
    global $DB, $ErrorMessages, $Session, $F_NewValue, $F_NewQualifierId;
    global $ControlledNameTypeId;

    # escape quotes
    $F_NewValue = addslashes($F_NewValue);

    # force "--" selection to NULL
    if(is_null($F_NewQualifierId) || $F_NewQualifierId == "--")
        $F_NewQualifierId = "NULL";
    
    # first check to see if it already exists
    if(!empty($F_NewValue))
    {
        $CN = & new ControlledName(NULL, $F_NewValue, $ControlledNameTypeId,
                $F_NewQualifierId);

        # exists, report error
        if($CN->Status() == CNSTAT_EXISTS)
        {
            $ErrorMessages[] = "<b>Error: </b>".$F_NewValue." already exists";
            return;
        }
        # otherwise, it has been added 
    }
    else
        $ErrorMessages[] = "<b>Error: </b>No Value Entered";
}

# update list value
function UpdateListValue()
{
    global $HTTP_POST_VARS, $DB;
    global $ControlledNameTypeId;

    $Type = GetControlledNameType($ControlledNameTypeId);
    $Schema = & new MetadataSchema();
    $Field = $Schema->GetFieldByName($Type);

    # initialize QualifierId to NULL
    $QualifierId = "NULL";

    while (list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if(ereg("cnid_([0-9]+)", $Var, $Regs))
        {
            if(isset($Value))
                $ControlledNameId = $Value;
            continue;
        }
        if(ereg("cn_([0-9]+)", $Var, $Regs))
        {
            $Value = trim($Value);
            $ControlledName = addslashes($Value);
            if($Field->HasItemLevelQualifiers())
                continue;
        }
        if(ereg("qid_([0-9]+)", $Var, $Regs))
        {
            $QualifierId = $Value;
            if($QualifierId == "--")
                $QualifierId = "NULL";
        }

        # do the update 
        if(!empty($ControlledName) && isset($ControlledNameId))
        { 
            $CN = & new ControlledName($ControlledNameId);
            $CN->Name($ControlledName);
            $CN->TypeId($ControlledNameTypeId);
            $CN->QualifierId($QualifierId);
            $ControlledNameId = NULL;
        }
    }
}

# remove default option value for advanced search
function RemoveDefault()
{
    global $ControlledNameTypeId;

    $Type = GetControlledNameType($ControlledNameTypeId);
    # Get the schema
    $Schema = & new MetadataSchema();

   # Get the field that matches this type
   $Field = $Schema->GetFieldByName($Type);
   $Field->DefaultValue($NULL);
}

# set default option value for advanced search
function SetDefault()
{
    global $HTTP_POST_VARS, $ControlledNameTypeId;

    while (list($var, $value) = each ($HTTP_POST_VARS))
    {
        if(ereg("cnid_([0-9]+)",$var,$regs))
        {
            if($value != "")
            { 
                $Type = GetControlledNameType($ControlledNameTypeId);
                # Get the schema
                $Schema = & new MetadataSchema();

                # Get the fields for the schema
                $Field = $Schema->GetFieldByName($Type);
                $Field->DefaultValue($value);
                break;
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

# grab entry information from database
$DB =& new SPTDatabase();

$F_NewValue = $HTTP_POST_VARS["F_NewValue"];
$F_NewQualifierId = $HTTP_POST_VARS["qid_"];
$Submit = $HTTP_POST_VARS["Submit"];

$ControlledNameTypeId = $Session->Get("ControlledNameTypeId");

# check for Cancel button from previous screen
if($Submit=="Cancel")
{
    PrintAutoRefreshPage("SPT Metadata Tool", "SPT--MDHome.php");
    exit;
}
else if(substr($Submit, 0, 15) == "Remove Selected")
{
    RemoveListValue();
}
else if(substr($Submit, 0, 15) == "Update Selected")
{
    UpdateListValue();
}
else if(substr($Submit, 0, 3) == "Add" ||
    (empty($Submit) && isset($F_NewValue)))
{
    AddListValue();
}
else if(substr($Submit, 0, 3) == "Set")
{
    SetDefault();
}
else if(substr($Submit, 0, 14) == "Remove Default")
{
    RemoveDefault();
}
else if(isset($Submit))
{
    $ControlledNameTypeName = $Submit;
}

$Session->PassVariable("ControlledNameTypeName");
$Session->PassVariable("ErrorMessages");
PrintAutoRefreshPage("Edit Option Lists",
    "SPT--EditControlledNameList.php");

?>
