<?php
#
#   FILE:  SPT--AdvancedSearch.php
#
#   FUNCTIONS PROVIDED:
#       PrintAdvancedSearchEntries()
#           - prints entries found as a result of an advanced search
#
#   FUNCTIONS EXPECTED:
#       PrintSearchResult($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - used to print entry found as a result of an advanced search
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--SearchEngine.php");

PageTitle("Advanced Search Results");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# get count of flagged files
function GetFlaggedFilesCount()
{
    global $HTTP_SERVER_VARS, $NavDirCorrection;
    
    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";

    if(is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while(!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if(empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

# print resource entry found as a result of an advanced search 
function PrintSearchResults()
{
    global $SearchResults;
    global $User;
    global $HTTP_POST_VARS;

    $F_Response = $HTTP_POST_VARS["F_Response"];

    # make sure search has been done
    PerformSearch();
    
    # suppress certain fields
    $DisplayDescription = True;
    $DisplayUrl = True;
    if($F_Response == "Title")
    {
        $DisplayUrl = False;
        $DisplayDescription = False;
    }
    else if($F_Response == "TitleUrl")
    {
        $DisplayDescription = False;
    }

    # for each search result entry up to the limit to be displayed
    foreach ($SearchResults as $ResourceId => $Score)
    {
        $Resource =& new Resource($ResourceId);

        PrintSearchResult($Resource,
            "SPT--FullRecord.php?ResourceId=${ResourceId}",
            $User->HasPriv(PRIV_RESOURCEADMIN),
            "MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
            $Resource->ScaledCumulativeRating(), NULL, 
            $DisplayUrl, $DisplayDescription);
    }
}

function PrintSearchString()
{
    global $SearchCriteria;

    print(str_replace("\"", "&quot;", stripslashes($SearchCriteria)));
}

function PrintTotalNumberOfResults()
{
    global $Engine;

    # make sure search has been done
    PerformSearch();

    print($Engine->NumberOfResults());
}

function PrintStartingResultNumber()
{
    global $StartingResult;
    global $Engine;

    # make sure search has been done
    PerformSearch();

    if ($Engine->NumberOfResults() == 0)
    {
        print("0");
    }
    else
    {
        print($StartingResult + 1);
    }
}

function PrintEndingResultNumber()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Engine;

    # make sure search has been done
    PerformSearch();

    print(min(($StartingResult + $ResultsPerPage), $Engine->NumberOfResults()));
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Engine;

    # make sure search has been done
    PerformSearch();

    return (($StartingResult + $ResultsPerPage) < $Engine->NumberOfResults()) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $F_Response;
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $F_LastModifiedBy;
    global $Editing;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);
    print("SPT--AdvancedSearch.php?ss=1&rpp=".$ResultsPerPage."&sr=".
        $NewStartingResult."&fr=".$F_Response."&rf=".$F_ReleaseFlag.
        "&ab=".$F_AddedBy."&lmb=".$F_LastModifiedBy."&Editing=".$Editing);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $F_Response;
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $Editing;

    $NewStartingResult = $StartingResult + $ResultsPerPage;
    print("SPT--AdvancedSearch.php?ss=1&rpp=".$ResultsPerPage."&sr=".
        $NewStartingResult."&fr=".$F_Response."&rf=".$F_ReleaseFlag.
        "&ab=".$F_AddedBy."&lmb=".$F_LastModifiedBy."&Editing=".$Editing);
}

function NoResultsFound()
{
    global $Engine;

    # make sure search has been done
    PerformSearch();

    return ($Engine->NumberOfResults() == 0) ? TRUE : FALSE;
}

function SearchWasAdvanced()
{
    global $SearchStrings;
    return isset($SearchStrings) ? TRUE : FALSE;
}

function PrintSearchTime()
{
    global $Engine;

    # make sure search has been done
    PerformSearch();

    printf("%.3f", $Engine->SearchTime());
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $Engine;

    # make sure search has been done
    PerformSearch();

    print(min($ResultsPerPage, ($Engine->NumberOfResults() - ($StartingResult + $ResultsPerPage))));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PreProcessVariables()
{
    global $Session, $F_Response, $F_ReleaseFlag, $F_AddedBy;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $SearchCriteria, $SearchStrings;
    global $StartingResult, $ResultsPerPage, $F_MaxRecords;
    global $fr, $rf, $ab, $lmb, $rpp, $sr, $ss, $vn, $vv;
    global $F_Response, $F_LastModifiedBy;

    # strip out extra backslashes from text fields
    $F_TextField1 = stripslashes($F_TextField1);
    $F_TextField2 = stripslashes($F_TextField2);
    $F_TextField3 = stripslashes($F_TextField3);
    $F_TextField4 = stripslashes($F_TextField4);

    # grab starting result number if passed in
    if (isset($sr))
        $StartingResult = $sr;
    else
        $StartingResult = 0;
    $Session->PassVariable("sr", $StartingResult);

    # grab results per page if passed in
    if(isset($rpp))
        $ResultsPerPage = $rpp;
    else
        $ResultsPerPage = $F_MaxRecords;
    $Session->PassVariable("rpp", $ResultsPerPage);

    # special case of linked ControlledNames or Classifications
    if(isset($vn) && isset($vv))
    {
        $ss = 1;
        $SearchStrings = NULL;
        $SearchCriteria = NULL;
        $SearchStrings[$vn] = stripslashes($vv);
        if(is_numeric($vv))
            $vv = GetControlledName($vv);
        $SearchCriteria = $vn." equals ".$vv;
        $F_ReleaseFlag = 1;
        $F_MaxRecords = 20;
        $ResultsPerPage = $F_MaxRecords;
    }

    # do Option lists and Flags
    if(!isset($ss))
    {
        unset($GLOBALS["SearchStrings"]);
        unset($GLOBALS["SearchCriteria"]);

        ProcessOptionLists();
        ProcessFlags();
    }

    # grab display response
    if(isset($fr))
        $Response = $fr;

    # grab release flag
    if(isset($rf))
        $F_ReleaseFlag = $rf;

    # grab added by user
    if(isset($ab))
        $F_AddedBy = $ab;

    # grab last modified by user
    if(isset($lmb))
        $F_LastModifiedBy = $lmb;
}

function ParseAndStoreArguments()
{
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $F_LastModifiedBy;
    global $SearchStrings;
    global $SearchCriteria;

    # set release flag to "only released records" if not already set
    if (!isset($F_ReleaseFlag)) {  $F_ReleaseFlag = 1;  }

    # add release flag to search strings if not set to "all records"
    if ($F_ReleaseFlag != "All") 
    {  
        $SearchStrings["Release Flag"] = $F_ReleaseFlag;  
    }

    # add "record added by" to search strings if not set to "anyone"
    if (strlen($F_AddedBy) && ($F_AddedBy != "All"))
    {  
        $DB =& new SPTDatabase();
        $NewUser =& new User($DB, (int)$F_AddedBy);

        $SearchStrings["Added By Id"] = $F_AddedBy;  
        $SearchCriteria .= "<br>Added By equals ".$F_AddedBy;
    }

    # add "record added by" to search strings if not set to "anyone"
    if (strlen($F_LastModifiedBy) && ($F_LastModifiedBy != "All"))
    {  
        $DB =& new SPTDatabase();
        $NewUser =& new User($DB, (int)$F_LastModifiedBy);

        $SearchStrings["Last Modified By Id"] = $F_LastModifiedBy;  
        $SearchCriteria .= "<br>Last Modified By equals ".$F_LastModifiedBy;
    }
}

# Peform the Search
function PerformSearch()
{
    global $SysConfig;
    global $Engine;
    global $SearchString;
    global $SearchStrings;
    global $SearchResults;
    global $StartingResult;
    global $ResultsPerPage;
    global $Editing;

    # bail out if we've already done search

    static $AlreadyPerformedSearch;
    if ($AlreadyPerformedSearch) { return; }
    $AlreadyPerformedSearch = TRUE;

    # create search engine
    $Engine = new SPTSearchEngine;

    # set OR/AND terms status
    $Engine->SearchTermsRequiredByDefault(
            $SysConfig->SearchTermsRequired());

    # add filter function if defined in HTML file
    if (function_exists("FilterSearchResults"))
    {
        $Engine->AddResultFilterFunction("FilterSearchResults");
    }

    # if advanced search
    if (isset($SearchStrings))
    {
        # check for no search criteria (other than Release Flag)
        if(!InMetadataTool() && count($SearchStrings) == 1)
        {
            unset($SearchStrings);
            $SearchStrings = array();
        }
            
        # add in search keywords if set
        if (isset($SearchString))
        {
            $SearchStrings["Keyword"] = $SearchString;
        }

	    # perform fielded search
        $SearchResults = $Engine->FieldedSearch(
                $SearchStrings, $StartingResult, $ResultsPerPage);
    }
    else
    {
        # perform keyword search
        $SearchResults = $Engine->Search(
                stripslashes($SearchString), $StartingResult, $ResultsPerPage);
    }
}

# function to process a search field for the query
function ProcessSearchField($Search, $Field)
{
    global $SearchStrings, $SearchCriteria;

    if(!empty($Field))
    {
        $SearchStrings[$Search] .= " ".$Field;
        $SearchCriteria .= "<br>".$Search." contains ".$Field;
    }
}

# function to process Option lists for the query
function ProcessOptionLists()
{
    global $HTTP_POST_VARS;
    global $SearchStrings;
    global $SearchCriteria;
    global $CumulativeRating;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        $Values = $HTTP_POST_VARS["$DBName"];

        if(is_array($Values))
        {
            foreach($Values as $Value)
            {
                # check for enabled fields
                if($Field->Enabled() && $Value != "No Limit" && !empty($Value))
                {
                    $SearchStrings[$FName][] = $Value;
                    $SearchCriteria .= "<br>$FName equals ".$Value;
                }
            }
        }
    }
    # special case cumulative rating
    $Field = $Schema->GetFieldByName("Cumulative Rating");
    if($Field->IncludeInAdvancedSearch())
    {
       if(is_array($CumulativeRating))
        {
            foreach($CumulativeRating as $Value)
            {
                if($Value != "No Limit" && !empty($Value))
                {
                    switch($Value)
                    {
                        case 0:
                            $Stars = "Not Rated";
                            $Operator = "is ";
                            $Value = "NULL";
                            break;
                        case 20:
                            $Stars = "*";
                            $Operator = ">= ";
                            break;
                        case 40:
                            $Stars = "**";
                            $Operator = ">= ";
                            break;
                        case 60:
                            $Stars = "***";
                            $Operator = ">= ";
                            break;
                        case 80:
                            $Stars = "****";
                            $Operator = ">= ";
                            break;
                        case 100:
                            $Stars = "*****";
                            $Operator = "= ";
                            break;
                        default:
                            $Stars = "No Limit";
                            break;
                    }
                    $SearchStrings["Cumulative Rating"][] = $Operator.$Value;
                    $SearchCriteria .= "<br>Cumulative Rating ".
                        $Operator.$Stars;
                }
            }
        }
    }
}

# function to process flags for the query
function ProcessFlags()
{
    global $HTTP_POST_VARS;
    global $SearchStrings;
    global $SearchCriteria;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        $Value = $HTTP_POST_VARS["$DBName"];

        # get on and off labels
        if($Value)
            $Label = $Field->FlagOnLabel();
        else
            $Label = $Field->FlagOffLabel();

        # check for enabled fields
        if($Field->Enabled())
        {
            if(is_numeric($Value))
            {
                $SearchStrings[$FName] = $Value;
                $SearchCriteria .= "<br>$FName equals ".$Label;
            }
        }
    }
}

# function to process Option lists for user searches 
function GetOptions()
{
    global $HTTP_POST_VARS;

    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->DBFieldName();
        $Value = $HTTP_POST_VARS["$DBName"];

        # check for enabled fields
        if($Field->Enabled())
        {
            $Options .= "$FName, ";
            $OptionValues .= "\"".$Value."\", ";
        }
    }
}

# function to get flags for the user search
function GetFlags()
{
    global $HTTP_POST_VARS;

    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->DBFieldName();
        $Value = $HTTP_POST_VARS["$DBName"];

        # check for enabled fields
        if($Field->Enabled())
        {
            if(is_numeric($Value))
            {
                $Flags .= "$FName, ";
                $FlagValues .= "\"".$Value."\", ";
            }
        }
    }
}

# build a "|" separated string from an array
function BuildArrayString($Array)
{
    $String = "\"";
    $Count = 0;
    foreach($Array as $Value)
    {
        if($Value == "No Limit")
            return "";

        # build string
        if(!empty($Value))
        {
            if($Count)
                $String .= "|${Value}";
            else
                $String .= "${Value}";
        }
        $Count++;
     }
     $String .= "\", ";
     return $String;
}

# save search for user agents
function SaveUserAgentSearch()
{
    global $HTTP_POST_VARS, $F_Response, $CumulativeRating, $Editing;
    global $Submit, $DB, $User, $Session, $SearchId;
    global $F_SearchCat1, $F_SearchCat2, $F_SearchCat3, $F_SearchCat4;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $F_MaxRecords, $F_AddedBy, $F_LastModifiedBy, $F_ReleaseFlag;
    global $SearchCriteria;

    $UserId = $User->Get("UserId");
    $UserName = $User->Get("UserName");

    $Schema = & new MetadataSchema();

    # don't allow saving searches if user no longer logged in
    if($User->IsLoggedIn() == FALSE)
    {
        $ErrorMessages[] = "ERROR: You must log in before saving searches.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        if($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Error Found", $Target);
        exit;
    }

    # see if UserSearch by this SearchId already exists
    if($SearchId)
    {
        $OldSearch = TRUE;
        
        $query = "SELECT * FROM UserSearch where UserId=$UserId and ".
            "SearchId = \"".$SearchId."\"";
        $DB->Query($query);
        $Entry = $DB->FetchNextRowArray();

        if ( isset( $HTTP_POST_VARS["F_SearchName"] ) )
            $SearchName = $HTTP_POST_VARS["F_SearchName"];
        else
            $SearchName = $Entry["SearchName"];

        # yes, delete it and add in new user search
        if($DB->NumRowsSelected() > 0)
        {
            $query = "DELETE FROM UserSearch where UserId=$UserId and ".
                "SearchId = \"".$SearchId."\"";
            $DB->Query($query);
        }
    }
    # not loading an existing search, so create unique search name
    else
    {
        $OldSearch = FALSE;

        $query = "Select max(SearchId) as MaxSearchId from UserSearch";
        $DB->Query($query);
        $Entry = $DB->FetchNextRowArray();
        $SearchId = $Entry["MaxSearchId"] + 1;
        $SearchName = $UserName.$SearchId;
    }

    # process options
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        $Value = $HTTP_POST_VARS["$DBName"];

        if($Field->Enabled() && is_array($Value))
        {
            $String = BuildArrayString($Value);
            if(!empty($String))
            {
                $Options .= "$DBName, ";
                $OptionValues .= $String;
            }
        }
    }

    # process flags    
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $DBName = $Field->DBFieldName();
        $Value = $HTTP_POST_VARS["$DBName"];

        # check for enabled fields
        if($Field->Enabled())
        {
            if(is_numeric($Value))
            {
                $Flags .= "$DBName, ";
                $FlagValues .= "\"".$Value."\", ";
            }
        }
    }

    # process culmulative rating (only one)
    if(is_array($CumulativeRating))
    {
       $String = BuildArrayString($CumulativeRating);
       if(!empty($String))
       {
           $CumRating .= "CumulativeRating, ";
           $CumRatingValues .= $String;
       }
    }

    # check ReleaseFlag for All
    if(is_null($F_ReleaseFlag) || $F_ReleaseFlag == "All")
       $F_ReleaseFlag = "NULL";

    # now insert new User Search Parameters
    $query = "INSERT INTO UserSearch (UserId, SearchId, SearchName, ".
            "SearchCat1, SearchText1, ".
            "SearchCat2, SearchText2, ".
            "SearchCat3, SearchText3, ".
            "SearchCat4, SearchText4, ".
            "AddedBy, LastModifiedBy, ReleaseFlag, ".
            "SearchCriteria, ".
            $Options.$Flags.$CumRating.
            "Display, MaxRecords, Frequency) ".
            "Values (\"$UserId\", NULL, \"".addslashes($SearchName)."\", ".
            "\"$F_SearchCat1\", \"".addslashes($F_TextField1)."\", ".
            "\"$F_SearchCat2\", \"".addslashes($F_TextField2)."\", ".
            "\"$F_SearchCat3\", \"".addslashes($F_TextField3)."\", ".
            "\"$F_SearchCat4\", \"".addslashes($F_TextField4)."\", ".
            "\"$F_AddedBy\", \"$F_LastModifiedBy\", $F_ReleaseFlag, ".
            "\"$SearchCriteria\", ".
            $OptionValues.$FlagValues.$CumRatingValues.
            "\"$F_Response\", \"$F_MaxRecords\", \"Once a day\")";

#    echo "query=$query<br>";
    $DB->Query($query);

    # extract last insert id to get real SearchId
    $SearchId = $DB->Query(
                    "SELECT LAST_INSERT_ID() AS SearchId FROM UserSearch",
                    "SearchId");

    $Session->PassVariable("SearchCriteria", $SearchCriteria);
    
    if($OldSearch)
        PrintAutoRefreshPage("Saved Searches", "SPT--SavedSearch.php");
    else
    {
        $Session->PassVariable("SearchId", $SearchId);
        PrintAutoRefreshPage("New Saved Search", "SPT--NewSavedSearch.php");
    }
    exit;
}

# load search for user agents
function LoadUserAgentSearch()
{
    global $HTTP_POST_VARS, $F_Response, $CumulativeRating, $Editing;
    global $Submit, $DB, $User, $Session, $SearchName, $SearchId;
    global $F_SearchCat1, $F_SearchCat2, $F_SearchCat3, $F_SearchCat4;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $F_MaxRecords, $F_AddedBy, $F_LastModifiedBy, $F_ReleaseFlag;

    $UserId = $User->Get("UserId");

    $Schema = & new MetadataSchema();

    if($SearchId)
    {
        $query = "SELECT * FROM UserSearch where UserId=$UserId and ".
                "SearchId = \"".$SearchId."\"";

        $DB->Query($query);
        $Entry = $DB->FetchNextRowArray();

        # verify saved search values still available
        for($Index=1; $Index<5; $Index++)
        {
            $SearchCat = "SearchCat".$Index;
            $Field = $Schema->GetFieldByName($Entry["$SearchCat"]);

            if(is_object($Field))
            {
                if(!$Field->Viewable() && !$Editing)
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not viewable to public.";
                        
                if(!$Field->Enabled())
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not enabled.";

                if(count($ErrorMessages))
                    $Session->PassVariable("ErrorMessages", $ErrorMessages);
            }
        }

        $Session->PassVariable("Entry", $Entry);
        $Session->PassVariable("SearchId", $SearchId);
        $Session->PassVariable("EditSearch", ($Session->Get("EditSearch") == 1));
        if($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Advanced Search", $Target);
        exit;
    }
    else
    {
        $ErrorMessages[] = "ERROR: No Saved Search To Load";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        if($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Error Found", $Target);
        exit;
    }
}

# function to append ResourceIds to Export File
function CreateExportFile()
{
    global $Session, $SearchResults, $HTTP_SERVER_VARS;
    global $SearchStrings, $sr, $ss, $rpp, $ResultsPerPage;
    global $StartingResult;

    $OldSearchResults = $Session->Get("SearchResults");
    $StartingResult = 0;
    $ResultsPerPage = 999999999;
    PerformSearch();

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $ActualPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/TempStorage/InputData";

    $fp = fopen($ActualPath, "aw");

    foreach ($SearchResults as $ResourceId => $Score)
    {
        fwrite($fp, $ResourceId."\n");
    }
    fclose($fp);
    $ss = 1;

    $SearchResults = $OldSearchResults;

    # redo search to display normal limit of resources
    $ResultsPerPage = $rpp;
    $StartingResult = $sr;
}

# function to remove export file
function RemoveExportFile()
{
    global $HTTP_SERVER_VARS, $ResultsPerPage, $StartingResult, $rpp, $sr;
    global $Session, $SearchResults, $ss;

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $ActualPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/TempStorage/InputData";

    unlink($ActualPath);

    $ss = 1;
    $StartingResults = 0;
    $ResultsPerPage = 999999999;
    PerformSearch();
    $SearchResults = $Session->Get("SearchResults");
    $ResultsPerPage = $rpp;
    $StartingResult = $sr;
}

# ----- MAIN -----------------------------------------------------------------

$F_Response = $HTTP_POST_VARS["F_Response"];
$F_ReleaseFlag = $HTTP_POST_VARS["F_ReleaseFlag"];
$F_AddedBy = $HTTP_POST_VARS["F_AddedBy"];
$F_LastModifiedBy = $HTTP_POST_VARS["F_LastModifiedBy"];
$F_MaxRecords = $HTTP_POST_VARS["F_MaxRecords"];
$F_SearchCat1 = $HTTP_POST_VARS["F_SearchCat1"];
$F_SearchCat2 = $HTTP_POST_VARS["F_SearchCat2"];
$F_SearchCat3 = $HTTP_POST_VARS["F_SearchCat3"];
$F_SearchCat4 = $HTTP_POST_VARS["F_SearchCat4"];
$F_TextField1 = $HTTP_POST_VARS["F_TextField1"];
$F_TextField2 = $HTTP_POST_VARS["F_TextField2"];
$F_TextField3 = $HTTP_POST_VARS["F_TextField3"];
$F_TextField4 = $HTTP_POST_VARS["F_TextField4"];

$fr = $HTTP_GET_VARS["fr"];
$rf = $HTTP_GET_VARS["rf"];
$ab = $HTTP_GET_VARS["ab"];
$lmb = $HTTP_GET_VARS["lmb"];
$ss = $HTTP_GET_VARS["ss"];
$vn = $HTTP_GET_VARS["vn"];
$vv = $HTTP_GET_VARS["vv"];

if(isset($HTTP_GET_VARS["Submit"]))
    $Submit = $HTTP_GET_VARS["Submit"];
else
    $Submit = $HTTP_POST_VARS["Submit"];

if(isset($HTTP_GET_VARS["Editing"]))
    $Editing = $HTTP_GET_VARS["Editing"];
else
    $Editing = $Session->Get("Editing");
if(isset($HTTP_GET_VARS["rpp"]))
    $rpp = $HTTP_GET_VARS["rpp"];
else
    $rpp = $Session->Get("rpp");

if(isset($HTTP_GET_VARS["sr"]))
    $sr = $HTTP_GET_VARS["sr"];
else
    $sr = $Session->Get("sr");

if(isset($HTTP_GET_VARS["SearchId"]))
    $SearchId = $HTTP_GET_VARS["SearchId"];
else
    $SearchId = $Session->Get("SearchId");

$SearchCriteria = $Session->Get("SearchCriteria");

# setup variables as needed
PreProcessVariables();

# build up search criteria for display purposes
ProcessSearchField($F_SearchCat1, $F_TextField1);
ProcessSearchField($F_SearchCat2, $F_TextField2);
ProcessSearchField($F_SearchCat3, $F_TextField3);
ProcessSearchField($F_SearchCat4, $F_TextField4);

ParseAndStoreArguments();

# strip out slashes from SearchCriteria
$SearchCriteria = stripslashes($SearchCriteria);
$SearchCriteria = str_replace('"', "&quot;", $SearchCriteria);  # ":

# remove <br> at beginning of $SearchCriteria
if(substr($SearchCriteria, 0, 4) == "<br>")
    $SearchCriteria = substr($SearchCriteria, 4);

# grab entry information from database
$DB =& new SPTDatabase();

# check for export
if(substr($Submit, 0, 4) == "Flag")
{
    $SearchStrings = $Session->Get("SearchStrings");
    CreateExportFile();
}
else if(substr($Submit, 0, 5) == "Clear")
{
    $SearchStrings = $Session->Get("SearchStrings");
    RemoveExportFile();
}
else if(substr($Submit, 0, 4) == "Save")
{
    SaveUserAgentSearch();
}
else if(substr($Submit, 0, 6) == "Search")
{
    # fall through to below and display search results
}
else if(isset($SearchId))
{
    LoadUserAgentSearch();
}

$Session->PassVariable("SearchStrings", $SearchStrings);
$Session->PassVariable("SearchCriteria", $SearchCriteria);

include("include/SPT--StandardHtmlPageLoad.php");
$Session->PassVariable("SearchResults", $SearchResults);
$Session->PassVariable("Editing", $Editing);

?>
