<?php
#
#   FILE:  SPT--DBAddFieldComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--Classification.php");

#PageTitle("Add Database Field Complete");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# populate the tree field with data from specified file
function PopulateTree($Field, $FileName)
{
    $DB =& new SPTDatabase();

    if(!file_exists($FileName))
        return FALSE;

    $FP = fopen($FileName, 'r');

    $ClassificationTypeId = GetClassificationTypeId($Field->Name());
    while(!feof($FP))
    {
        $ClassificationName = fgets($FP, 16384);

        # last line read, exit
        if(empty($ClassificationName))
            break;
            
        $NewClass = & new Classification(NULL, $ClassificationName,
                            $ClassificationTypeId);
    }
    return TRUE;
}

# save form field data to the field object
function SaveFormData()
{
    global $HTTP_POST_VARS;
    global $Schema;
    global $F_FieldId;
    global $Session;

    # get the field 
    $Field = $Schema->GetField($F_FieldId);

    if($Field->RequiredBySPT())
    {
        $F_FieldName = $Session->Get("F_FieldName");
        $F_Enabled = $Session->Get("F_Enabled");
        $F_Optional = $Session->Get("F_Optional");
    }
    else
    {
        $F_FieldName = $HTTP_POST_VARS["F_FieldName"];
        $F_Enabled = $HTTP_POST_VARS["F_Enabled"];
        $F_Optional = $HTTP_POST_VARS["F_Optional"];
    }
    $F_Viewable = $HTTP_POST_VARS["F_Viewable"];
    $F_DefaultValue = $HTTP_POST_VARS["F_DefaultValue"];
    $F_UsesQualifiers = $HTTP_POST_VARS["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $HTTP_POST_VARS["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $HTTP_POST_VARS["F_DefaultQualifier"];
    $F_IncludeInKeywordSearch = $HTTP_POST_VARS["F_IncludeInKeywordSearch"];
    $F_IncludeInAdvancedSearch = $HTTP_POST_VARS["F_IncludeInAdvancedSearch"];
    $F_SearchWeight = $HTTP_POST_VARS["F_SearchWeight"];
    $F_TextFieldSize = $HTTP_POST_VARS["F_TextFieldSize"];
    $F_MaxLength = $HTTP_POST_VARS["F_MaxLength"];
    $F_MinValue = $HTTP_POST_VARS["F_MinValue"];
    $F_MaxValue = $HTTP_POST_VARS["F_MaxValue"];
    $F_DateFormat = $HTTP_POST_VARS["F_DateFormat"];
    $F_ParagraphRows = $HTTP_POST_VARS["F_ParagraphRows"];
    $F_ParagraphCols = $HTTP_POST_VARS["F_ParagraphCols"];
    $F_FlagOnLabel = $HTTP_POST_VARS["F_FlagOnLabel"];
    $F_FlagOffLabel = $HTTP_POST_VARS["F_FlagOffLabel"];
    $F_AllowMultiple = $HTTP_POST_VARS["F_AllowMultiple"];
    $F_Description = $HTTP_POST_VARS["F_Description"];
    $F_DefaultAltText = $HTTP_POST_VARS["F_DefaultAltText"];
    $F_MaxHeight = $HTTP_POST_VARS["F_MaxHeight"];
    $F_MaxWidth = $HTTP_POST_VARS["F_MaxWidth"];
    $F_MaxPreviewHeight = $HTTP_POST_VARS["F_MaxPreviewHeight"];
    $F_MaxPreviewWidth = $HTTP_POST_VARS["F_MaxPreviewWidth"];
    $F_MaxThumbnailHeight = $HTTP_POST_VARS["F_MaxThumbnailHeight"];
    $F_MaxThumbnailWidth = $HTTP_POST_VARS["F_MaxThumbnailWidth"];

    # set the attributes
    $Field->Name(addslashes($F_FieldName));
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);

    if(!empty($F_Description)) $Field->Description(addslashes($F_Description));
    if(!empty($F_DateFormat)) $Field->DateFormat(addslashes($F_DateFormat));
    if(!empty($F_FlagOnLabel)) $Field->FlagOnLabel(addslashes($F_FlagOnLabel));
    if(!empty($F_FlagOffLabel)) 
        $Field->FlagOffLabel(addslashes($F_FlagOffLabel));
    if(!empty($F_DefaultAltText)) 
        $Field->DefaultAltText(addslashes($F_DefaultAltText));
    
    if(is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if($F_SearchWeight < 1) $F_SearchWeight = 1;
        if($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }
    if(is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if(is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if(is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if(is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if(is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if(is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if(is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if(is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if(is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if(is_numeric($F_MaxPreviewHeight)) 
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if(is_numeric($F_MaxPreviewWidth)) 
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if(is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if(is_numeric($F_MaxThumbnailWidth)) 
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);
}

# add new field
function AddNewField()
{
    global $HTTP_POST_VARS;
    global $Session;
    global $ErrorMessage;
    global $Schema;
    global $F_FieldId;

    $F_FieldType = $Session->Get("F_FieldType");
    $F_FieldName = $HTTP_POST_VARS["F_FieldName"];
    $F_Enabled = $HTTP_POST_VARS["F_Enabled"];
    $F_Optional = $HTTP_POST_VARS["F_Optional"];
    $F_Viewable = $HTTP_POST_VARS["F_Viewable"];
    $F_DefaultValue = $HTTP_POST_VARS["F_DefaultValue"];
    $F_UsesQualifiers = $HTTP_POST_VARS["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $HTTP_POST_VARS["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $HTTP_POST_VARS["F_DefaultQualifier"];
    $F_IncludeInKeywordSearch = $HTTP_POST_VARS["F_IncludeInKeywordSearch"];
    $F_IncludeInAdvancedSearch = $HTTP_POST_VARS["F_IncludeInAdvancedSearch"];
    $F_SearchWeight = $HTTP_POST_VARS["F_SearchWeight"];
    $F_TextFieldSize = $HTTP_POST_VARS["F_TextFieldSize"];
    $F_MaxLength = $HTTP_POST_VARS["F_MaxLength"];
    $F_MinValue = $HTTP_POST_VARS["F_MinValue"];
    $F_MaxValue = $HTTP_POST_VARS["F_MaxValue"];
    $F_DateFormat = $HTTP_POST_VARS["F_DateFormat"];
    $F_ParagraphRows = $HTTP_POST_VARS["F_ParagraphRows"];
    $F_ParagraphCols = $HTTP_POST_VARS["F_ParagraphCols"];
    $F_FlagOnLabel = $HTTP_POST_VARS["F_FlagOnLabel"];
    $F_FlagOffLabel = $HTTP_POST_VARS["F_FlagOffLabel"];
    $F_AllowMultiple = $HTTP_POST_VARS["F_AllowMultiple"];
    $F_Description = $HTTP_POST_VARS["F_Description"];
    $F_DefaultAltText = $HTTP_POST_VARS["F_DefaultAltText"];
    $F_MaxHeight = $HTTP_POST_VARS["F_MaxHeight"];
    $F_MaxWidth = $HTTP_POST_VARS["F_MaxWidth"];
    $F_MaxPreviewHeight = $HTTP_POST_VARS["F_MaxPreviewHeight"];
    $F_MaxPreviewWidth = $HTTP_POST_VARS["F_MaxPreviewWidth"];
    $F_MaxThumbnailHeight = $HTTP_POST_VARS["F_MaxThumbnailHeight"];
    $F_MaxThumbnailWidth = $HTTP_POST_VARS["F_MaxThumbnailWidth"];

#   echo "FieldType=$F_FieldType, FieldName=$F_FieldName<br>";

    # test for required fields
    CheckRequiredFields();

    # get the field 
    $Field = $Schema->GetField($F_FieldId);

    # check for NULL which indicates error or duplicate name
    if(is_null($Field))
    {
        $ErrorMessage = "ERROR: Unable to add field, duplicate field name.";
        SetErrorMessage();
    }

    # set the attributes
    $Field->Name(addslashes($F_FieldName));
    if($Field->Status() != MDFSTAT_OK)
    {
        if($Field->Status() == MDFSTAT_DUPLICATENAME)
        {
            $ErrorMessage = "ERROR: Duplicate field name.";
            SetErrorMessage();
        }
        else if($Field->Status() == MDFSTAT_ILLEGALNAME)
        {
            $ErrorMessage = "ERROR: Illegal field name.";
            SetErrorMessage();
        }
    }
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);

    if(!empty($F_Description)) $Field->Description(addslashes($F_Description));
    if(!empty($F_DateFormat)) $Field->DateFormat(addslashes($F_DateFormat));
    if(!empty($F_FlagOnLabel)) $Field->FlagOnLabel(addslashes($F_FlagOnLabel));
    if(!empty($F_FlagOffLabel)) 
        $Field->FlagOffLabel(addslashes($F_FlagOffLabel));
    if(!empty($F_DefaultAltText)) 
        $Field->DefaultAltText(addslashes($F_DefaultAltText));
    
    if(is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if($F_SearchWeight < 1) $F_SearchWeight = 1;
        if($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }
    if(is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if(is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if(is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if(is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if(is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if(is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if(is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if(is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if(is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if(is_numeric($F_MaxPreviewHeight)) 
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if(is_numeric($F_MaxPreviewWidth)) 
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if(is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if(is_numeric($F_MaxThumbnailWidth)) 
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);

    # all new fields are by default NOT required by SPT
    $Field->RequiredBySPT("0");
    
    # now set the type
    $Field->Type($F_FieldType);

    # convert the field from temp to real
    $Field->IsTempItem(FALSE);
    $F_FieldId = $Field->Id();
}

# update an existing field
function UpdateField()
{
    global $HTTP_POST_VARS, $Session, $Schema, $F_FieldId, $ErrorMessage;

    $F_FieldType = $Session->Get("F_FieldType");

    # Get the field 
    $Field = $Schema->GetField($F_FieldId);

    if($Field->RequiredBySPT())
    {
        $F_FieldName = $Session->Get("F_FieldName");
        $F_Enabled = $Session->Get("F_Enabled");
        $F_Optional = $Session->Get("F_Optional");
    }
    else
    {
        $F_FieldName = $HTTP_POST_VARS["F_FieldName"];
        $F_Enabled = $HTTP_POST_VARS["F_Enabled"];
        $F_Optional = $HTTP_POST_VARS["F_Optional"];
    }
    $F_Viewable = $HTTP_POST_VARS["F_Viewable"];
    $F_DefaultValue = $HTTP_POST_VARS["F_DefaultValue"];
    $F_UsesQualifiers = $HTTP_POST_VARS["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $HTTP_POST_VARS["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $HTTP_POST_VARS["F_DefaultQualifier"];
    $F_IncludeInKeywordSearch = $HTTP_POST_VARS["F_IncludeInKeywordSearch"];
    $F_IncludeInAdvancedSearch = $HTTP_POST_VARS["F_IncludeInAdvancedSearch"];
    $F_SearchWeight = $HTTP_POST_VARS["F_SearchWeight"];
    $F_TextFieldSize = $HTTP_POST_VARS["F_TextFieldSize"];
    $F_MaxLength = $HTTP_POST_VARS["F_MaxLength"];
    $F_MinValue = $HTTP_POST_VARS["F_MinValue"];
    $F_MaxValue = $HTTP_POST_VARS["F_MaxValue"];
    $F_DateFormat = $HTTP_POST_VARS["F_DateFormat"];
    $F_ParagraphRows = $HTTP_POST_VARS["F_ParagraphRows"];
    $F_ParagraphCols = $HTTP_POST_VARS["F_ParagraphCols"];
    $F_FlagOnLabel = $HTTP_POST_VARS["F_FlagOnLabel"];
    $F_FlagOffLabel = $HTTP_POST_VARS["F_FlagOffLabel"];
    $F_AllowMultiple = $HTTP_POST_VARS["F_AllowMultiple"];
    $F_Description = $HTTP_POST_VARS["F_Description"];
    $F_DefaultAltText = $HTTP_POST_VARS["F_DefaultAltText"];
    $F_MaxHeight = $HTTP_POST_VARS["F_MaxHeight"];
    $F_MaxWidth = $HTTP_POST_VARS["F_MaxWidth"];
    $F_MaxPreviewHeight = $HTTP_POST_VARS["F_MaxPreviewHeight"];
    $F_MaxPreviewWidth = $HTTP_POST_VARS["F_MaxPreviewWidth"];
    $F_MaxThumbnailHeight = $HTTP_POST_VARS["F_MaxThumbnailHeight"];
    $F_MaxThumbnailWidth = $HTTP_POST_VARS["F_MaxThumbnailWidth"];
    $F_PopulateTree = $HTTP_GET_VARS["F_PopulateTree"];

#    echo "FieldType=$F_FieldType, FieldName=$F_FieldName<br>";

    # test for required fields
    CheckRequiredFields();

    # check for valid name
    $Field->Name(addslashes($F_FieldName));
    if($Field->Status() != MDFSTAT_OK)
    {
        if($Field->Status() == MDFSTAT_DUPLICATENAME)
        {
            $ErrorMessage = "ERROR: Duplicate field name.";
            SetErrorMessage();
        }
        else if($Field->Status() == MDFSTAT_ILLEGALNAME)
        {
            $ErrorMessage = "ERROR: Illegal field name.";
            SetErrorMessage();
        }
    }

    # percolate DefaultQualifier for tree fields
    if ($F_FieldType == MDFTYPE_TREE)
    {
        SetQualifierIdForClassifications();
    }

    # set the attributes
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);
    $Field->Type($F_FieldType);

    $Field->Description(addslashes($F_Description));
    $Field->DefaultValue(addslashes($F_DefaultValue));
    $Field->DateFormat(addslashes($F_DateFormat));
    $Field->FlagOnLabel(addslashes($F_FlagOnLabel));
    $Field->FlagOffLabel(addslashes($F_FlagOffLabel));
    $Field->DefaultAltText(addslashes($F_DefaultAltText));

    if(is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if($F_SearchWeight < 1) $F_SearchWeight = 1;
        if($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }

    if(is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if(is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if(is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if(is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if(is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if(is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if(is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if(is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if(is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if(is_numeric($F_MaxPreviewHeight))
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if(is_numeric($F_MaxPreviewWidth))
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if(is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if(is_numeric($F_MaxThumbnailWidth))
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);
}

# delete a field
function DeleteField()
{
    global $F_FieldId, $Schema;
    
    # drop the field
    $Field = $Schema->DropField($F_FieldId);

    # remove from OAIFieldMappings too
    $DB = & new SPTDatabase();
    $DB->Query("Delete from OAIFieldMappings where SPTFieldId=".$F_FieldId);
}

# function to set DefaultQualifier at all levels in a tree
# if not already set to some other value
function SetQualifierIdForClassifications()
{
    global $HTTP_POST_VARS;

    $F_UsesQualifiers = $HTTP_POST_VARS["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $HTTP_POST_VARS["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $HTTP_POST_VARS["F_DefaultQualifier"];

    $DB = & new SPTDatabase();

    if($F_UsesQualifiers && $F_DefaultQualifier && $F_HasItemLevelQualifiers)
    {
        $DB->Query("Select * from Classifications");
        while($Result = $DB->FetchNextRowArray())
        {
            $Class = & new Classification($Result["ClassificationId"]);
            $OldQualifierId = $Class->QualifierId();
            $Qualifier = & new Qualifier($OldQualifierId);

            # check if qualifier already assigned and is legit
            if(is_null($OldQualifierId) || $OldQualifierId == 0 ||
                is_null($Qualifier->Name()))
            {
                    $Class->QualifierId($F_DefaultQualifier);
            }
        }
    }
}

function CheckRequiredFields()
{
    global $HTTP_POST_VARS;
    global $ErrorMessage;
    global $Session;

    if(isset($HTTP_POST_VARS["F_FieldName"]))
        $F_FieldName = $HTTP_POST_VARS["F_FieldName"];
    else
        $F_FieldName = $Session->Get("F_FieldName");
    if(isset($HTTP_POST_VARS["F_FieldType"]))
        $F_FieldType = $HTTP_POST_VARS["F_FieldType"];
    else
        $F_FieldType = $Session->Get("F_FieldType");
    $F_TextFieldSize = $HTTP_POST_VARS["F_TextFieldSize"];
    $F_MaxLength = $HTTP_POST_VARS["F_MaxLength"];
    $F_ParagraphRows = $HTTP_POST_VARS["F_ParagraphRows"];
    $F_ParagraphCols = $HTTP_POST_VARS["F_ParagraphCols"];
    $F_FlagOnLabel = $HTTP_POST_VARS["F_FlagOnLabel"];
    $F_FlagOffLabel = $HTTP_POST_VARS["F_FlagOffLabel"];
    $F_Description = $HTTP_POST_VARS["F_Description"];
    $F_DefaultAltText = $HTTP_POST_VARS["F_DefaultAltText"];

    if(empty($F_FieldName))
    {
        $ErrorMessage = "ERROR: Missing required FieldName Field.";
        SetErrorMessage();
    }
    if(empty($F_Description))
    {
        $ErrorMessage = "ERROR: Missing required Description Field.";
        SetErrorMessage();
    }

    switch($F_FieldType)
    {
        case MDFTYPE_TEXT:
            if(empty($F_TextFieldSize))
            {
                $ErrorMessage = "ERROR: Missing required TextFieldSize Field.";
                SetErrorMessage();
            }
            if(empty($F_MaxLength))
            {
                $ErrorMessage = "ERROR: Missing required MaxLength Field.";
                SetErrorMessage();
            }
            break;

        case MDFTYPE_PARAGRAPH:
            if(empty($F_ParagraphRows))
            {
                $ErrorMessage = "ERROR: Missing required ParagraphRows Field.";
                SetErrorMessage();
            }
            if(empty($F_ParagraphCols))
            {
                $ErrorMessage = "ERROR: Missing required ParagraphCols Field.";
                SetErrorMessage();
            }
            break;
            
        case MDFTYPE_FLAG:
            if(empty($F_FlagOnLabel))
            {
                $ErrorMessage = "ERROR: Missing required FlagOnLabel Field.";
                SetErrorMessage();
            }
            if(empty($F_FlagOffLabel))
            {
                $ErrorMessage = "ERROR: Missing required FlagOffLabel Field.";
                SetErrorMessage();
            }
            break;
            
        case MDFTYPE_IMAGE:
            if(empty($F_DefaultAltText))
            {
                $ErrorMessage = "ERROR: Missing required DefaultAltText Field.";
                SetErrorMessage();
            }
            break;
    }
}

function SetErrorMessage()
{
    global $ErrorMessage, $Session, $HTTP_POST_VARS;

    $F_FieldName = $HTTP_POST_VARS["F_FieldName"];
    $F_FieldType = $HTTP_POST_VARS["F_FieldType"];
    $F_Enabled = $HTTP_POST_VARS["F_Enabled"];
    $F_Optional = $HTTP_POST_VARS["F_Optional"];
    $F_Viewable = $HTTP_POST_VARS["F_Viewable"];
    $F_DefaultValue = $HTTP_POST_VARS["F_DefaultValue"];
    $F_UsesQualifiers = $HTTP_POST_VARS["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $HTTP_POST_VARS["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $HTTP_POST_VARS["F_DefaultQualifier"];
    $F_IncludeInKeywordSearch = $HTTP_POST_VARS["F_IncludeInKeywordSearch"];
    $F_IncludeInAdvancedSearch = $HTTP_POST_VARS["F_IncludeInAdvancedSearch"];
    $F_SearchWeight = $HTTP_POST_VARS["F_SearchWeight"];
    $F_TextFieldSize = $HTTP_POST_VARS["F_TextFieldSize"];
    $F_MaxLength = $HTTP_POST_VARS["F_MaxLength"];
    $F_MinValue = $HTTP_POST_VARS["F_MinValue"];
    $F_MaxValue = $HTTP_POST_VARS["F_MaxValue"];
    $F_DateFormat = $HTTP_POST_VARS["F_DateFormat"];
    $F_ParagraphRows = $HTTP_POST_VARS["F_ParagraphRows"];
    $F_ParagraphCols = $HTTP_POST_VARS["F_ParagraphCols"];
    $F_FlagOnLabel = $HTTP_POST_VARS["F_FlagOnLabel"];
    $F_FlagOffLabel = $HTTP_POST_VARS["F_FlagOffLabel"];
    $F_AllowMultiple = $HTTP_POST_VARS["F_AllowMultiple"];
    $F_Description = $HTTP_POST_VARS["F_Description"];
    $F_DefaultAltText = $HTTP_POST_VARS["F_DefaultAltText"];
    $F_MaxHeight = $HTTP_POST_VARS["F_MaxHeight"];
    $F_MaxWidth = $HTTP_POST_VARS["F_MaxWidth"];
    $F_MaxPreviewHeight = $HTTP_POST_VARS["F_MaxPreviewHeight"];
    $F_MaxPreviewWidth = $HTTP_POST_VARS["F_MaxPreviewWidth"];
    $F_MaxThumbnailHeight = $HTTP_POST_VARS["F_MaxThumbnailHeight"];
    $F_MaxThumbnailWidth = $HTTP_POST_VARS["F_MaxThumbnailWidth"];

    $Session->PassVariable("ErrorMessage");
    $Session->PassVariable("F_FieldName");
    $Session->PassVariable("F_FieldType");
    $Session->PassVariable("F_Description");
    $Session->PassVariable("F_Enabled");
    $Session->PassVariable("F_Optional");
    $Session->PassVariable("F_Viewable");
    $Session->PassVariable("F_DefaultValue");
    $Session->PassVariable("F_UsesQualifiers");
    $Session->PassVariable("F_HasItemLevelQualifiers");
    $Session->PassVariable("F_DefaultQualifier");
    $Session->PassVariable("F_IncludeInKeywordSearch");
    $Session->PassVariable("F_IncludeInAdvancedSearch");
    $Session->PassVariable("F_SearchWeight");
    $Session->PassVariable("F_TextFieldSize");
    $Session->PassVariable("F_MaxLength");
    $Session->PassVariable("F_MinValue");
    $Session->PassVariable("F_MaxValue");
    $Session->PassVariable("F_DateFormat");
    $Session->PassVariable("F_ParagraphRows");
    $Session->PassVariable("F_ParagraphCols");
    $Session->PassVariable("F_FlagOnLabel");
    $Session->PassVariable("F_FlagOffLabel");
    $Session->PassVariable("F_AllowMultiple");
    $Session->PassVariable("F_DefaultAltText");
    $Session->PassVariable("F_MaxHeight");
    $Session->PassVariable("F_MaxWidth");
    $Session->PassVariable("F_MaxPreviewHeight");
    $Session->PassVariable("F_MaxPreviewWidth");
    $Session->PassVariable("F_MaxThumbnailHeight");
    $Session->PassVariable("F_MaxThumbnailWidth");
    PrintAutoRefreshPage("Add Database Field", "SPT--DBAddField.php");
    exit;
}

# remove Qaulifier assocation for this field
function RemoveQualifierAssociation()
{
    global $HTTP_POST_VARS, $F_FieldId, $Schema;

    # Get the field
    $Field = $Schema->GetField($F_FieldId);

    $F_AllowedQualifiers = $HTTP_POST_VARS["F_AllowedQualifiers"];
    if(isset($F_AllowedQualifiers) && $F_AllowedQualifiers != "--")
        $Field->UnassociateWithQualifier($F_AllowedQualifiers);   
}

# add Qualifier assocation for this field
function AddQualifierAssociation()
{ 
    global $HTTP_POST_VARS, $F_FieldId, $Schema;

    # Get the field
    $Field = $Schema->GetField($F_FieldId);
    
    $F_AvailableQualifiers = $HTTP_POST_VARS["F_AvailableQualifiers"];
    if(isset($F_AvailableQualifiers) && $F_AvailableQualifiers != "--")
        $Field->AssociateWithQualifier($F_AvailableQualifiers);   

}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN);

$Schema = & new MetadataSchema();
$F_FieldId = $Schema->GetCurrentEditedItemId();

if($HTTP_POST_VARS["Submit"] == "Add New Field")
{
    AddNewField();
    $Session->PassVariable("F_FieldName");
    PrintAutoRefreshPage("Database Add Field Confirmation", 
        "SPT--DBConfirmAddField.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if($HTTP_POST_VARS["Submit"] == "Update Field")
{
    UpdateField();
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if($HTTP_POST_VARS["Submit"] == "Add Another Field")
{
    PrintAutoRefreshPage("Add Database Field", "SPT--DBAddField.php");
    $Schema->ClearCurrentEditedItemId();
    exit;    
}
else if($HTTP_POST_VARS["Submit"] == "Edit Fields")
{
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if(substr($HTTP_POST_VARS["Submit"], 0, 6) == "Delete")
{
    if($HTTP_POST_VARS["OkayToDelete"])
    {
        DeleteField();
        PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
        $Schema->ClearCurrentEditedItemId();
        exit;
    }
    else
    {
        $Session->PassVariable("F_FieldName");
        PrintAutoRefreshPage("Confirm Delete Database Field", 
            "SPT--DBConfirmDeleteField.php");
        exit;
    }
}
else if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    # delete temporary field and clear current edit id
    if(isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        if($Field->IsTempItem())
            DeleteField();
    }
    $Schema->ClearCurrentEditedItemId();
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    exit;
}
else if($HTTP_POST_VARS["Submit"] == "Remove ==>")
{
    SaveFormData();
    RemoveQualifierAssociation();
}
else if($HTTP_POST_VARS["Submit"] == "<== Add")
{
    SaveFormData();
    AddQualifierAssociation();
}
else if($HTTP_POST_VARS["Submit"] == "Populate")
{
    $F_PopulateTree = $HTTP_POST_VARS["F_PopulateTree"];
    if(!empty($F_PopulateTree))
    {
        $Field = $Schema->GetField($F_FieldId);
        if($Field->Type() == MDFTYPE_TREE)
        {
            $Status = PopulateTree($Field, $F_PopulateTree);
            if($Status == FALSE)
            {
                $ErrorMessage = "WARNING: Cannot populate tree.".
                "\"$F_PopulateTree\" not found";
            }
            else
            {
                $ErrorMessage = 
                    "Field populated successfully.";
            }
        }
    }
    else
    {
        $ErrorMessage = "You must select a taxonomy.";
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Populate Tree Field", "SPT--DBPopulateTree.php");
    exit;
}
else if(isset($HTTP_POST_VARS["Submit"]))
{
    SaveFormData();
    $F_FieldType = $HTTP_POST_VARS["Submit"];
}

$Session->PassVariable("F_FieldType");
PrintAutoRefreshPage("Database Add Field", "SPT--DBAddField.php");

?>
