<?PHP

#
#   FILE:  SPT--EditOAIConfig.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--QualifierFactory.php");
require_once("include/SPT--SPTOAIServer.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to return sys config info (for insertion into forms)
function PrintOaiIdDomain() {  PrintValue("OaiIdDomain");  }
function PrintOaiIdPrefix() {  PrintValue("OaiIdPrefix");  }
function PrintOaiEarliestDate() {  PrintValue("OaiEarliestDate");  }
function PrintSelectedIfOaiDate()
{
    global $SysConfig;
    if ($SysConfig->OaiDateGranularity() == "DATE") {  print("selected");  }
}

function PrintSelectedIfOaiDateTime()
{
    global $SysConfig;
    if ($SysConfig->OaiDateGranularity() == "DATETIME") {  print("selected");  }
}

function PrintOAIRows()
{
    global $FormatList, $Label, $Field, $FieldId, $Current, $Format;

    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(NULL, MDFORDER_DISPLAY);

    $SPTOAIServer = & new SPTOAIServer();
    $FormatList = $SPTOAIServer->FormatList();

    # only grap non-Dublin Core fields
    foreach($Fields as $Field)
    {
        if($Field->Enabled() && !FieldIsDublinCore())
        {
            $Label = $Field->Name();
            $FieldId = $Field->Id();
            PrintSPTField();

            foreach($FormatList as $Format)
            {
                $Current = LookUpCurrent($Label, $Format);
                PrintFormatField();
            }
        }
    }
}

# function to print qualifier rows
function PrintQualifierRows()
{
    global $QualifierName, $QualifierId, $SchemaCurrent, $Format;

    $SPTOAIServer = & new SPTOAIServer();
    $FormatList = $SPTOAIServer->FormatList();

    $QFactory = & new QualifierFactory();
    $QualifierList = $QFactory->QualifierList();

    foreach($QualifierList as $QualifierId => $QualifierName)
    {
        # only display non-Dublin Core qualifiers
        if(!QualifierIsDublinCore())
        {
            PrintQualifierField();        
            foreach($FormatList as $Format)
            {
                $SchemaCurrent = LookUpQualifierSchema($QualifierName, $Format);
                PrintQualifierSchemaField();
            }
        }
    }
}

# function to print qualifier label
function PrintQualifierFieldLabel()
{
    global $QualifierName;

    print $QualifierName.":";
}

# function to print headings
function PrintHeadings()
{
    global $Label;

    $SPTOAIServer = & new SPTOAIServer();
    $FormatList = $SPTOAIServer->FormatList();

    # metadata field labels
    $Label = "Metadata Fields";
    PrintHeading();

    # oai field labels
    foreach($FormatList as $Label)
    {
        PrintHeading();
    }
}

# function to print heading label
function PrintHeadingLabel()
{
    global $Label;

    print $Label;
}

# function to print qualifier schema list
function PrintQualifierSchemaList()
{
    global $SchemaCurrent, $QualifierId, $Format;

    $SPTOAIServer = & new SPTOAIServer();
    $QualifierList = $SPTOAIServer->FormatQualifierList($Format);
    if(count($QualifierList) > 0)
    {
        foreach($QualifierList as $QualifierName)
            $Items[$QualifierName] = $QualifierName;
        $Items["Unmapped"] = "Unmapped";
        ksort($Items);

        PrintOptionList("qualifier_".$Format."_".$QualifierId, $Items,
            $SchemaCurrent, 0, 1, NULL, false);
    }
}

# function to print SPTField label
function PrintSPTFieldLabel()
{
    global $Label;

    print $Label.":";
}

# function to print SPTField label
function PrintSPTFieldId()
{
    global $FieldId;

    print $FieldId.":";
}

# function to print OAI format field list
function PrintFormatFieldList()
{
    global $Current, $FieldId, $Format;

    $SPTOAIServer = & new SPTOAIServer();
    $ElementList = $SPTOAIServer->FormatElementList($Format);
    foreach($ElementList as $Element)
        $Items[$Element] = $Element;
    $Items["Unmapped"] = "Unmapped";
    ksort($Items);

    PrintOptionList("field_".$Format."_".$FieldId, $Items, $Current, 0, 1,
        NULL, false);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function FieldIsDublinCore()
{
    global $Field;

    $DublinCoreFields = array(
        "Title", 
        "Creator", 
        "Subject", 
        "Description",
        "Publisher", 
        "Contributor", 
        "Date Issued",
        "Resource Type",
        "Format", 
        "Url", 
        "Source", 
        "Language", 
        "Relation", 
        "Coverage", 
        "Rights", 
        "Audience",
        "Alternate Title",
        "Classification",
        "Typical Learning Time",
        "Is Version Of",
        "Has Version",
        "Is Replaced By",
        "Replaces",
        "Is Required By",
        "Requires",
        "Is Part Of",
        "Has Part",
        "Is Referenced By",
        "References",
        "Is Format Of",
        "Has Format",
        "Conforms To",
        "Spatial",
        "Temporal",
        "Access Rights",
        "Bibliographic Citation",
        "Table of Contents",
        "Abstract",
        "Valid Date",
        "Modified Date",
        "Available Date",
        "Creation Date",
        "Date Accepted",
        "Date Copyrighted",
        "Date Submitted",
        "Interactivity Type",
        "Interactivity Level",
        "Extent",
        "Medium",
        "Mediator",
        "Education Level");

    return in_array($Field->Name(), $DublinCoreFields);     
}

function QualifierIsDublinCore()
{
    global $QualifierName;

    $DublinCoreQualifiers = array("DCMI Box", "DCMI Period", "DCMI Point",
        "DCMI Type Vocabulary", "DDC", "IMT", "ISO 3166", "ISO 639-2",
        "LCC", "LCSH", "MeSH", "RFC 1766", "RFC 3066", "TGN", "UDC",
        "URI", "W3C-DTF");

    return in_array($QualifierName, $DublinCoreQualifiers);
}

function LookUpCurrent($LocalFieldName, $FormatName)
{
    $SPTOAIServer = & new SPTOAIServer();

    # look up value in OAIFieldMappings
    return $SPTOAIServer->GetFieldMapping($FormatName, $LocalFieldName);
}

function LookUpQualifierSchema($LocalQualifierName, $FormatName)
{
    $SPTOAIServer = & new SPTOAIServer();

    # look up value in OAIFieldMappings
    return $SPTOAIServer->GetQualifierMapping($FormatName, $LocalQualifierName);
}

function PrintValue($ValueName)
{
    global $SysConfig;  
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(${$FormVar});
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print($SysConfig->{$ValueName}());  
    }
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("OAI Configuration");
CheckAuthorization(PRIV_SYSADMIN);

include("include/SPT--StandardHtmlPageLoad.php");

?>
