<?php

#
#   FILE:  SPT--Home.php
#
#   FUNCTIONS PROVIDED:
#       PrintAnnouncementsTableRows()
#           - outputs HTML for News & Announcements table
#       PrintNewResourceTableRows()
#           - outputs HTML for New Resources table
#       NumAnnouncementRows()
#           - returns the number or Announcements to be displayed 
#
#   FUNCTIONS EXPECTED:
#       PrintAnnouncementRow($Headline, $DatePosted, $PosterName, $Text, 
#                   $EditOkay, $EditLink)
#           - called to print line in News & Announcements table
#       PrintNoAnnouncementsMessage()
#           - called to print message that there were no announcements
#       PrintNewResourceRow($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - called to print line in New Resources table
#       PrintNoResourcesMessage()
#           - called to print message that there were no resources to display
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Resource.php");
PageTitle("Home");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function AnnouncementsEnabled()
{
    global $SysConfig;

    return $SysConfig->AnnouncementsEnabled();
}

function PrintPrevAnnouncementLink()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $AnnouncementOffset = $HTTP_GET_VARS["AnnouncementOffset"];

    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $AnnouncementOffset + $NumAnnouncements;

    print "SPT--Home.php?AnnouncementOffset=$Offset";
}

function PrintNextAnnouncementLink()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $AnnouncementOffset = $HTTP_GET_VARS["AnnouncementOffset"];

    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $AnnouncementOffset - $NumAnnouncements;

    print "SPT--Home.php?AnnouncementOffset=$Offset";
}

function NextAnnouncementsAvailable()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $AnnouncementOffset = $HTTP_GET_VARS["AnnouncementOffset"];
    
    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    return ($AnnouncementOffset >= $NumAnnouncements) ? TRUE : FALSE;
}

function PreviousAnnouncementsAvailable()
{
    global $MoreAnnouncements;
    return $MoreAnnouncements;
}

function PrintNumberOfAnnouncements()
{
    global $SysConfig;
    print $SysConfig->NumAnnounceOnHomePage();
}

function PrintAnnouncementsTableRows()
{
    global $User;
    global $DB;
	global $SysConfig;
	global $MoreAnnouncements;
    global $HTTP_GET_VARS;

    $AnnouncementOffset = $HTTP_GET_VARS["AnnouncementOffset"];

    if(is_null($AnnouncementOffset))
        $AnnouncementOffset = 0;
        
    # if function to supply announcement DB query is available
    if (function_exists("SupplyAnnouncementDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyAnnouncementDisplayQuery(
                $MaxNumberOfDaysToGoBackForAnnouncements,
                $SysConfig->NumAnnounceOnHomePage());
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Announcements "
                ."ORDER BY DatePosted DESC "
                ."LIMIT ${AnnouncementOffset}, "
                ."999999999";
    }

    # query database for appropriate announcements
    $AnnouncementDB = new SPTDatabase();
    $AnnouncementDB->Query($DisplayQuery);

    # determine number of announcements to display
    $MaxNumberOfAnnouncementsToDisplay=min($SysConfig->NumAnnounceOnHomePage(),
        $AnnouncementDB->NumRowsSelected());

    # determine if previous link should be displayed or not
    $MoreAnnouncements = ($AnnouncementDB->NumRowsSelected() <=
            $MaxNumberOfAnnouncementsToDisplay) ? false : true;

    # if announcements found
    if ($AnnouncementDB->NumRowsSelected() > 0)
    {
        $Index = 0;
        # for each announcement
        while ($Index++ < $MaxNumberOfAnnouncementsToDisplay)
        {
            $Announcement = $AnnouncementDB->FetchNextRowArray();
            
            # format date for display
            $DatePosted = date("M j", strtotime($Announcement["DatePosted"]));

            # get name of person who posted announcement
            $Poster =& new User($DB, (int)$Announcement["PosterId"]);
            $PosterName = $Poster->Get("UserName");
            if (strlen($PosterName) < 1) {  $PosterName = "(unknown)";  }

            # print row with announcement info
            PrintAnnouncementRow(
                    $Announcement["AnnouncementHeading"],
                    $DatePosted,
                    $PosterName,
                    $Announcement["AnnouncementText"],
                    $User->HasPriv(PRIV_NEWSADMIN),
                    "SPT--EditAnnouncement.php?F_Editing=1&F_Id=".
                    $Announcement["AnnouncementId"]);
        }
    }
    else
    {
        # print row with "no announcements" notice
        PrintNoAnnouncementsMessage();
    }
}

function NumAnnouncementRows()
{
    global $DB;
	global $SysConfig;
    global $HTTP_GET_VARS;

    # if function to supply announcement DB query is available
    if (function_exists("SupplyAnnouncementDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyAnnouncementDisplayQuery(
                $MaxNumberOfDaysToGoBackForAnnouncements,
                $SysConfig->NumAnnounceOnHomePage());
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Announcements "
                ."ORDER BY DatePosted DESC "
                ."LIMIT 0, "
                ."999999999";
    }

    # query database for appropriate announcements
    $AnnouncementDB = new SPTDatabase();
    $AnnouncementDB->Query($DisplayQuery);
    return $AnnouncementDB->NumRowsSelected();

}


function PrintPrevResourceLink()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $ResourceOffset = $HTTP_GET_VARS["ResourceOffset"];

    $NumResources = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $ResourceOffset + $NumResources;

    print "SPT--Home.php?ResourceOffset=$Offset";
}

function PrintNextResourceLink()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $ResourceOffset = $HTTP_GET_VARS["ResourceOffset"];

    $NumResources = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $ResourceOffset - $NumResources;

    print "SPT--Home.php?ResourceOffset=$Offset";
}

function NextResourcesAvailable()
{
    global $SysConfig;
    global $HTTP_GET_VARS;

    $ResourceOffset = $HTTP_GET_VARS["ResourceOffset"];
    
    $NumResources = $SysConfig->NumAnnounceOnHomePage();
    return ($ResourceOffset >= $NumResources) ? TRUE : FALSE;
}

function PreviousResourcesAvailable()
{
    global $MoreResources;
    return $MoreResources;
}

function PrintNumberOfResources()
{
    global $SysConfig;
    print $SysConfig->NumResourcesOnHomePage();
}

function PrintNewResourceTableRows()
{
    global $User;
    global $DB;
    global $MoreResources;
	global $SysConfig;
    global $HTTP_GET_VARS;

    $MaxDescriptionLength = 250;
    $MaxUrlLength = 60;
    $ResourceOffset = $HTTP_GET_VARS["ResourceOffset"];

    if(is_null($ResourceOffset))
        $ResourceOffset = 0;

    # default values
    $MaxNumberOfResourcesToDisplay = $SysConfig->NumResourcesOnHomePage();
    $MaxNumberOfDaysToGoBackForResources = 3650;

    # if function to supply resource DB query is available
    if (function_exists("SupplyResourceDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyResourceDisplayQuery(
                $MaxNumberOfDaysToGoBackForResources,
                $MaxNumberOfResourcesToDisplay);
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Resources WHERE "
                ."DateOfRecordCreation > DATE_SUB(NOW(), "
                ."INTERVAL ${MaxNumberOfDaysToGoBackForResources} DAY) "
                ."AND ReleaseFlag = 1 "
                ."AND ResourceId >= 0 "
                ."ORDER BY DateOfRecordCreation DESC "
                ."LIMIT ${ResourceOffset}, 999999999";
    }

    # query database for appropriate resources
    $ResourceDB = new SPTDatabase();
    $ResourceDB->Query($DisplayQuery);

    # determine whether "Previous" link should be displayed
    $ResourceCount = $ResourceDB->NumRowsSelected();
    $MoreResources = ($ResourceCount <= $MaxNumberOfResourcesToDisplay) ? FALSE : TRUE;

    # if resources found
    if ($ResourceDB->NumRowsSelected() > 0)
    {
        # for each resource
        $Index = 0;
        while (($Index < $MaxNumberOfResourcesToDisplay)
                && ($Index < $ResourceCount))
        {
            $Record = $ResourceDB->FetchNextRowArray();

            # print entry
            $ResourceId = $Record["ResourceId"];
            $Resource =& new Resource($ResourceId);
            PrintNewResourceRow($Resource,
                    "SPT--FullRecord.php?ResourceId=${ResourceId}",
                    $User->HasPriv(PRIV_RESOURCEADMIN),
                    "MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
                    $Resource->ScaledCumulativeRating());

            # move to next entry
            $Index++;
        }
    }
    else
    {
        # print row with "no resources" notice
        PrintNoResourcesMessage();
    }
}


# ----- MAIN -----------------------------------------------------------------

# load header, set the character set
header("Content-type: text/html; charset=".$SysConfig->DefaultCharacterSet(),
        true);

# (we don't use CorrespondingHtmlFile() here because 
#       we may be accessed as "index.php")
include(FindUIFile("include/SPT--StandardPageStart.html"));
include(FindUIFile("SPT--Home.html"));
include(FindUIFile("include/SPT--StandardPageEnd.html"));


?>
