<?php

#
#   FILE:  SPT--ImportUsersExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitImportVars()
{
    global $ImportComplete, $FSeek, $UserCount;

    if(is_null($ImportComplete))
        $ImportComplete = 0;
    if(is_null($FSeek))
        $FSeek = 0;
    if(is_null($UserCount))
        $UserCount = 0;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $DB, $fp, $Session, $FSeek, $Title, $ImportComplete;
    global $User, $UserCount, $LineCount;

    $LineCount = 0;

    while (!feof($fp) && $LineCount < 500 && $ImportComplete == 0)
    {
        # read in line from import file
        $fline = fgets($fp, 4096);

#        echo "fline=$fline<br>";
    
        # update variables 
        $LineCount++;
        $Session->PassVariable("LineCount", $LineCount);
        $FSeek += strlen($fline);
        $Session->PassVariable("FSeek", $FSeek);

        $Value = NULL;    
        # parse line from import file
        $Vars = explode("\t", $fline);

        # should be 11 variables per line
        if(count($Vars) != 11)
        {
            $ErrorMessage = "Error: Wrong number of fields on Line ".$LineCount;
            $Session->PassVariable("ErrorMessage", $ErrorMessage);
            PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
            exit;
        }

        # initial the vars
        $UserName = $Vars[0];
        $UserPassword = $Vars[1];
        $Email = $Vars[2];
        $Website = $Vars[3];
        $RealName = $Vars[4];
        $Address1 = $Vars[5];
        $Address2 = $Vars[6];
        $City = $Vars[7];
        $State = $Vars[8];
        $Country = $Vars[9];
        $Zipcode = $Vars[10];

        # default UserPassword to UserName if blank
        if(empty($UserPassword))
            $UserPassword = $UserName;

        # encrypt the password
        $UserPassword = crypt($UserPassword);

        # bail out if line was empty or end of file encountered
        if(is_null($UserName) || feof($fp))
        {
            break;
        }

        $query = "Insert into APUsers (".
                        "UserName, ".
                        "UserPassword, ".
                        "CreationDate, ".
                        "Email, ".
                        "Website, ".
                        "RealName, ".
                        "AddressLineOne, ".
                        "AddressLineTwo, ".
                        "City, ".
                        "State, ".
                        "Country, ".
                        "Zipcode, ".
                        "ActiveUI)".
                " Values (\"$UserName\", ".
                         "\"$UserPassword\", ".
                         "\"".strftime("%Y-%m-%d")."\", ".
                         "\"$Email\", ".
                         "\"$Website\", ".
                         "\"$RealName\", ".
                         "\"$Address1\", ".
                         "\"$Address2\", ".
                         "\"$City\", ".
                         "\"$State\", ".
                         "\"$Country\", ".
                         "\"$Zipcode\", ".
                         "\"SPTUI--Default\")";
    
#       echo "Query=".$query."<br>";

        $DB->Query($query);
    
        # keep track of number of resources added
        $UserCount++;
        $Session->PassVariable("UserCount", $UserCount);
    }
}

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB =& new SPTDatabase();
$ClassDB =& new SPTDatabase();

InitImportVars();

# check for Cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    $ImportComplete = 1;
    PrintAutoRefreshPage("System Administration", "SPT--SysAdmin.php");
    exit;
}

# register some key variables for other html code
$Session->PassVariable("ImportComplete", $ImportComplete);

if(is_uploaded_file($HTTP_POST_FILES['F_FileName']['tmp_name']))
{
    # zero length or tiny file
    if($HTTP_POST_FILES['F_FileName']['size'] == 0)
    {
        $ErrorMessage = "Error: File doesn't exist or is empty.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
        exit;
    }

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $TempFile = dirname($ScriptFileName).
        "/".$NavDirCorrection."TempStorage/".
        $_FILES['F_FileName']['name'];

    copy($HTTP_POST_FILES['F_FileName']['tmp_name'], $TempFile);

    $fp = fopen($TempFile, 'r');
    unlink($HTTP_POST_FILES['F_FileName']['tmp_name']);
}
else if($FSeek > 0)
{
    $fp = fopen($TempFile, 'r');
}
else
{
    switch($HTTP_POST_FILES['F_FileName']['error'])
    {
        # no error; possible file attack!
        case 0:
            $ErrorMessage = "There was a problem with your upload.";
            break;

        # uploaded file exceeds the upload_max_filesize directive in php.ini
        case 1:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;

        # uploaded file exceeds the MAX_FILE_SIZE directive that
        # was specified in the html form
        case 2:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;
            
        # uploaded file was only partially uploaded
        case 3:
            $ErrorMessage = 
                "The file you are trying upload was only partially uploaded.";
            break;

        # no file was uploaded
        case 4:
            $ErrorMessage = "You must select a file for upload.";
            break;

        # a default error, just in case!
        default:
            echo "There was a problem with your upload.";
            break;
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
    exit;
}

# the main work happenes here
DoWhileLoop();

# end of file reached?
if(feof($fp) || $ImportComplete)
{
    $ImportComplete = 1;
}
$Session->PassVariable("ImportComplete", $ImportComplete);
$Session->PassVariable("UserCount", $UserCount);
$Session->PassVariable("Insert", $Insert);
$Session->PassVariable("FSeek", $FSeek);
$Session->PassVariable("TempFile", $TempFile);

#  Time to auto-refresh?
if($ImportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ImportUsersExecute.php";
}

PageTitle("Import Users");
include("include/SPT--StandardHtmlPageLoad.php");

if ($ImportComplete == 1)
{
    fclose($fp);
    # remove temporary uploaded file
    unlink($TempFile);
}

?>
