<?PHP

# load database access settings
require_once(dirname(__FILE__)."/SPT--Config.php");
require_once(dirname(__FILE__)."/../Axis--User.php");
require_once(dirname(__FILE__)."/SPT--SystemConfiguration.php");
require_once(dirname(__FILE__)."/SPT--SPTDatabase.php");

# define privilege levels for SPT
define("PRIV_SYSADMIN", 1);
define("PRIV_NEWSADMIN", 2);
define("PRIV_RESOURCEADMIN", 3);
define("PRIV_FORUMADMIN", 4);
define("PRIV_CLASSADMIN", 5);
define("PRIV_NAMEADMIN", 6);
define("PRIV_RELEASEADMIN", 7);
define("PRIV_USERADMIN", 8);
define("PRIV_POSTTOFORUMS", 9);
define("PRIV_POSTCOMMENTS", 10);
define("PRIV_USERDISABLED", 11);
$PrivDescriptions = array(
        PRIV_SYSADMIN       => "System Administrator",
        PRIV_NEWSADMIN      => "News Administrator",
        PRIV_RESOURCEADMIN  => "Resource Administrator",
        PRIV_FORUMADMIN     => "Forum Administrator",
        PRIV_CLASSADMIN     => "Classification Administrator",
        PRIV_NAMEADMIN      => "Controlled Name Administrator",
        PRIV_RELEASEADMIN   => "Release Flag Administrator",
        PRIV_USERADMIN      => "User Account Administrator",
        # following are user permissions, not admin priveleges
        PRIV_POSTTOFORUMS   => "Can Post To Forums",
        PRIV_POSTCOMMENTS   => "Can Post Resource Comments"
        );

# SPT <--> CWIS version mapping
# (this must match the similar maps in:
#     SPT--InstallComplete.php,
#     include/SPT--Common.php,
#     SPT--BuildRelease, and
#     sptinstall)
$SPT_SPTCWISVersionMap = array(
        "1.1.4" => "0.9.0",
        "1.1.5" => "0.9.1",
        "1.1.6" => "0.9.2",
        "1.1.7" => "0.9.3",
        "1.1.8" => "0.9.4",
        "1.2.0" => "1.0.0",
        "1.2.1" => "1.0.1",
        "1.2.2" => "1.1.0",
        );


class ErrorList {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function ErrorList()
    {
        $this->Messages = array();
        $this->FormMessages = array();
    }

    function AddMessage($Text, $FormFieldName = NULL)
    {
        if ($FormFieldName)
        {
            $this->FormMessages[$FormFieldName] = $Text;
        }
        else
        {
            $this->Messages[] = $Text;
        }
    }

    function GetMessagesAsUList()
    {
        $Text = "<ul>\n";
        foreach ($this->Messages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        foreach ($this->FormMessages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        $Text .= "</ul>\n";

        return $Text;
    }

    function HasErrors()
    {
        return (count($this->Messages) + count($this->FormMessages)) ? true : false;
    }

    function GetMessageForField($FormFieldName)
    {
        return $this->FormMessages[$FormFieldName];
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Messages;
    var $FormMessages;

}

# load system, session, and user information
$DB        =& new SPTDatabase();
$SysConfig =& new SystemConfiguration($DB);
$Session   =& new Session($DB);
$User      =& new User($Session);

# load technical info if user is system administrator
if ($User->HasPriv(PRIV_SYSADMIN)) 
{
    if (file_exists("VERSION"))
    {
        $VersionArray = file("VERSION");
    }
    else
    {
        $VersionArray = file("../VERSION");
    }
    $SPT_SoftwareVersion = chop($VersionArray[0]);
    if (SoftwareIsCWIS())
    {
        $SPT_SoftwareVersionToDisplay = $SPT_SPTCWISVersionMap[$SPT_SoftwareVersion];
    }
    else
    {
        $SPT_SoftwareVersionToDisplay = $SPT_SoftwareVersion;
    }
}

# get around register_globals possibly being set to OFF
if (isset($HTTP_POST_VARS))
{
    foreach ($HTTP_POST_VARS as $VarName => $VarValue)
    {
        if (!empty($VarValue))
        {
            $$VarName = $VarValue;
        }
    }
}
if (isset($HTTP_GET_VARS))
{
    foreach ($HTTP_GET_VARS as $VarName => $VarValue)
    {
        if (!empty($VarValue))
        {
            $$VarName = $VarValue;
        }
    }
}

# strip PHP-inserted backslashes out of any incoming form variables
if (get_magic_quotes_gpc() && count($HTTP_POST_VARS))
{
    foreach ($HTTP_POST_VARS as $Key => $Value) {  if (is_string($$Key)) {  $$Key = stripslashes($Value);  $HTTP_POST_VARS[$Key] = $$Key;  }  }
}

function SoftwareIsCWIS()
{
    global $SPT_DefaultUI;
    return ($SPT_DefaultUI == "SPTUI--CWIS") ? TRUE : FALSE;
}

function UserIsLoggedIn()
{
    global $User;
    return $User->IsLoggedIn();
}

function LogMsg($Msg)
{
    $Output = fopen("/tmp/PhpLogMsg.log", "a");
    fwrite($Output, date("Y-m-d H:i  ").$Msg."\n");
    fclose($Output);
}

function FindUIFile($FileName)
{
    global $User;
    global $SysConfig;
    global $SPT_DefaultUI;

    # if user is logged in and multiple UIs are allowed or user is sys admin
    if ($User->IsLoggedIn() && ($SysConfig->AllowMultipleUIsEnabled() || $User->HasPriv(PRIV_SYSADMIN)))
    {
        # use UI selected by user
        $ActiveUI = $User->Get("ActiveUI");
    }
    else
    {
        # use default system UI
        $ActiveUI = $SysConfig->DefaultActiveUI();
    }

    # if file is in active UI directory
    if (file_exists($ActiveUI."/".$FileName))
    {
        # use file from active UI directory
        $FileName = $ActiveUI."/".$FileName;
    }
    else
    {
        # if file is in default UI directory
        if (file_exists($SPT_DefaultUI."/".$FileName))
        {
            # use file from default UI directory
            $FileName = $SPT_DefaultUI."/".$FileName;
        }
    }

    # return (possibly) revised name to caller
    return $FileName;
}

function PrintCurrentThemeDir()
{
    global $SysConfig;
    print($SysConfig->CurrentTheme());
}

function CorrespondingHtmlFile()
{
    global $HTTP_SERVER_VARS;
    global $NavDirCorrection;

    # strip off current directory to get our file name as a relative path
    $FileName = basename($HTTP_SERVER_VARS["SCRIPT_FILENAME"]);

    # replace ".php" with ".html" in our file name
    $FileName = preg_replace("/\.php$/", ".html", $FileName);

    # select file from UI directory if available
    $FileName = FindUIFile($FileName);

    # return resulting file name to caller
    return $FileName;
}

function CheckAuthorization($AuthFlag, $AuthFlag2 = NULL, $AuthFlag3 = NULL, $AuthFlag4 = NULL, $AuthFlag5 = NULL, $AuthFlag6 = NULL)
{
    # pull in global values in case page loaded assumes they're available
    global $DB;
    global $Session;
    global $User;
    global $SysConfig;

    # provide relative path to base SPT directory
    if(InMetadataTool())
        $NavDirCorrection = "../";

    if ($User->HasPriv($AuthFlag, $AuthFlag2, $AuthFlag3, $AuthFlag4, $AuthFlag5, $AuthFlag6))
    {
        return;
    }
    else
    {
        include("include/SPT--UnauthorizedAccess.php");
        exit();
    }
}

function ErrorOut($Message)
{
    # pull in global values in case files loaded assume they're available
    global $DB;
    global $Session;
    global $User;
    global $SysConfig;

    # provide relative path to base SPT directory
    if(InMetadataTool())
        $NavDirCorrection = "../";

    include(FindUIFile("include/SPT--StandardPageStart.html"));
    print($Message);
    include(FindUIFile("include/SPT--StandardPageEnd.html"));
    exit(0);
}

function GetClassTypeName($ClassTypeId)
{
    $ClassTypeDB =& new SPTDatabase();
    $ClassTypeDB->Query("SELECT ClassificationTypeName "
            ."FROM ClassificationTypes "
            ."WHERE ClassificationTypeId=".$ClassTypeId);
    $Record = $ClassTypeDB->FetchNextRowArray();

    # return name to caller
    return $Record["ClassificationTypeName"];
}

function getmicrotime()
{
    list($usec, $sec) = explode(" ", microtime()); 
    return ((float)$usec + (float)$sec); 
}

function PrintErrorMessageList()
{
    global $ErrorMessages;

    if (isset($ErrorMessages))
    {
        if ($ErrorMessages->HasErrors())
        {
            print($ErrorMessages->GetMessagesAsUList());
        }
    }
}

function PageTitle($NewTitle = NULL)
{
    global $SysConfig;
    static $Title;

    if (isset($NewTitle))
    {  
        if (strlen($SysConfig->PortalName()) > 0)
        {
            $Title = $SysConfig->PortalName()." - ".$NewTitle;  
        }
        else
        {
            $Title = $NewTitle;  
        }
    }
    return $Title;
}

function GetActiveUIOptionList($Selected)
{
    # start out with empty list
    $Text = "";

    # for each file in current directory
    $Dir = dir(".");
    while (($DirEntry = $Dir->read()) !== FALSE)
    {
        # if file is UI directory
        if (is_dir($DirEntry) && preg_match("/SPTUI--[a-zA-Z]+/", $DirEntry))
        {
            # read UI name (if available)
            $UIName = "";
            $UINameFile = $DirEntry."/NAME";
            if (is_readable($UINameFile))
            {
                $FHandle = fopen($UINameFile, "r");
                $UIName = fgets($FHandle, 64);
                fclose($FHandle);
            }
            if (strlen($UIName) < 1) {  $UIName = $DirEntry;  }

            # print option tag for UI
            if ($DirEntry == $Selected) {  $Select = " selected";  } else {  $Select = "";  }
            $Text .= "<option value=\"${DirEntry}\"${Select}>${UIName}</option>\n";
        }
    }

    # return list to caller
    return $Text;
}

function GetThemeOptionList($Selected)
{
    # start out with empty list
    $Text = "";

    # for each file in current interface directory
    global $SysConfig;
    $Dir = dir("./".$SysConfig->DefaultActiveUI()."/Themes");
    while (($DirEntry = $Dir->read()) !== FALSE)
    {
        # if file is directory
        $FullDirName = "./".$SysConfig->DefaultActiveUI()."/Themes/".$DirEntry;
        if (is_dir($FullDirName) && preg_match("/Theme--[a-zA-Z]+/", $DirEntry))
        {
            # read UI name (if available)
            $UIName = "";
            $UINameFile = $FullDirName."/NAME";
            if (is_readable($UINameFile))
            {
                $FHandle = fopen($UINameFile, "r");
                $UIName = fgets($FHandle, 64);
                fclose($FHandle);
            }
            if (strlen($UIName) < 1) {  $UIName = $DirEntry;  }

            # print option tag for UI
            if ($DirEntry == $Selected) {  $Select = " selected";  } else {  $Select = "";  }
            $Text .= "<option value=\"${DirEntry}\"${Select}>${UIName}</option>\n";
        }
    }

    # return list to caller
    return $Text;
}

# Character set encoding hard-coded here for now
function GetCharacterSetOptionList($Selected)
{
    $CharSets = array("ISO-8859-1", "UTF-8");

    foreach($CharSets as $CharSet)
    {
        if($Selected == $CharSet)
            $Select = " selected";
        else
            $Select = NULL;
            
        $Text .= "<option value=\"$CharSet\"$Select>$CharSet</option>\n";
    }
    return $Text;
}

function InMetadataTool()
{
    global $HTTP_SERVER_VARS;
    global $Editing;

    if ((strstr($HTTP_SERVER_VARS["PHP_SELF"], "/MetadataTool/")
                    && (strstr($HTTP_SERVER_VARS["PHP_SELF"], "SPT--ImportData") == FALSE)
                    && (strstr($HTTP_SERVER_VARS["PHP_SELF"], "SPT--EditControlledNameTypes") == FALSE))
            || (strstr($HTTP_SERVER_VARS["PHP_SELF"],
                    "SPT--BrowseResources.php") && $Editing)
            || (strstr($HTTP_SERVER_VARS["PHP_SELF"],
                    "SPT--Advanced.php") && $Editing)
            || (strstr($HTTP_SERVER_VARS["PHP_SELF"],
                    "SPT--AdvancedSearch.php") && $Editing))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function SearchTermHandlingIsAnd()
{
    global $SysConfig;
    return ($SysConfig->SearchTermsRequired()); 
}

function CloseTags($Tag, $Text)
{
    # if there are a greater number of opening tags than closing tags
    if (preg_match_all("/<".$Tag.">/i", $Text, $Dummy) > preg_match_all("/<\\/".$Tag.">/i", $Text, $Dummy))
    {
        # add closing tag to text
        $Text .= "</".$Tag.">";
    }

    # return (possibly) revised text to caller
    return $Text;
}

# retrieve PHP configuration settings via call to phpinfo()
function GetPhpInfo()
{
    # grab PHP info page
    ob_start();
    phpinfo();
    $InfoPage = ob_get_contents();
    ob_end_clean();   
  
    # start by assuming that no info is available
    $Info = array();
  
    # for each section on page
    $PageChunks = explode("<h2", $InfoPage);
    foreach ($PageChunks as $PageChunk)
    {
        # pull out module/section name
        preg_match("/<a name=\"module_([^<>]*)\">/", $PageChunk, $Piece);
        $ModuleName = $Piece[1];
      
        # pull out info values from HTML tables
        preg_match_all("/<tr[^>]*><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td>/Ux", 
                       $PageChunk, $LocalValue);
        preg_match_all("/<tr[^>]*><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td>/Ux", 
                       $PageChunk, $MasterValue);
                              
        # store "local" info values
        foreach ($LocalValue[0] as $MatchString => $Dummy)
        {
            $Info[$ModuleName][strip_tags($LocalValue[1][$MatchString])] = 
                    array(strip_tags($LocalValue[2][$MatchString]));
        }
      
        # store "master" info values
        foreach ($MasterValue[0] as $MatchString => $Dummy)
        {
            $Info[$ModuleName][strip_tags($MasterValue[1][$MatchString])] = 
                    array(strip_tags($MasterValue[2][$MatchString]), strip_tags($MasterValue[3][$MatchString]));
        }               
    }

    # return info to caller
    return $Info;
}


?>
