<?php

require_once(dirname(__FILE__)."/SPT--Common.php");


class SystemConfiguration {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SystemConfiguration($DB = NULL)
    {
        # load current system config info from database
        if ($DB == NULL) {  $DB =& new SPTDatabase();  }
        $DB->Query("SELECT * FROM SystemConfiguration");
        $Record = $DB->FetchRow();
        $this->TopLinkString = stripslashes($Record["TopLinkString"]);
        $this->TopLinkBeginLetter = stripslashes($Record["TopLinkBeginLetter"]);
        $this->TopLinkEndLetter = stripslashes($Record["TopLinkEndLetter"]);
        $this->AdminEmail = stripslashes($Record["AdminEmail"]);
        $this->PasswordMailSubject = 
            stripslashes($Record["PasswordMailSubject"]);
        $this->PasswordMailBody = stripslashes($Record["PasswordMailBody"]);
        $this->PortalName = stripslashes($Record["PortalName"]);
        $this->DefaultActiveUI = stripslashes($Record["DefaultActiveUI"]);
        $this->CurrentTheme = stripslashes($Record["CurrentTheme"]);
        $this->DefaultCharacterSet = stripslashes($Record["DefaultCharacterSet"]);
        $this->NumClassesPerBrowsePage = $Record["NumClassesPerBrowsePage"];
        $this->ClassificationTypeId = $Record["ClassificationTypeId"];
        $this->SearchTermsRequired = $Record["SearchTermsRequired"];
        $this->AnnouncementsEnabled = $Record["AnnouncementsEnabled"];
        $this->ForumsEnabled = $Record["ForumsEnabled"];
        $this->AllowMultipleUIsEnabled = $Record["AllowMultipleUIsEnabled"];
        $this->ResourceLaunchesNewWindowEnabled = 
            $Record["ResourceLaunchesNewWindowEnabled"];
        $this->UserAgentsEnabled = $Record["UserAgentsEnabled"];
        $this->ResourceRatingsEnabled = $Record["ResourceRatingsEnabled"];
        $this->ResourceCommentsEnabled = $Record["ResourceCommentsEnabled"];
        $this->ReleaseFlagApproved = $Record["ReleaseFlagApproved"];
        $this->SearchDBEnabled = $Record["SearchDBEnabled"];
        $this->RecommenderDBEnabled = $Record["RecommenderDBEnabled"];
        $this->NumAnnounceOnHomePage = $Record["NumAnnounceOnHomePage"];
        $this->NumResourcesOnHomePage = $Record["NumResourcesOnHomePage"];
        $this->LegalNotice = $Record["LegalNotice"];
        $this->OaiIdDomain = $Record["OaiIdDomain"];
        $this->OaiIdPrefix = $Record["OaiIdPrefix"];
        $this->OaiEarliestDate = $Record["OaiEarliestDate"];
        $this->OaiDateGranularity = $Record["OaiDateGranularity"];
        $this->AboutText = $Record["AboutText"];
        $this->ContactName = $Record["ContactName"];
        $this->ContactEmail = $Record["ContactEmail"];
        $this->Organization = $Record["Organization"];
        $this->OrganizationType = $Record["OrganizationType"];
        $this->SiteType = $Record["SiteType"];
        $this->OkayToListSite = $Record["OkayToListSite"];
        $this->LastRegisteredOn = $Record["LastRegisteredOn"];

        # load UI configuration info
        $DB->Query("SELECT * FROM UIStyleConfiguration");
        $Record = $DB->FetchRow();
        $this->LogoFileName = $Record["LogoFileName"];
        $this->LogoAltText = $Record["LogoAltText"];
        $this->LogoWidth = $Record["LogoWidth"];
        $this->LogoHeight = $Record["LogoHeight"];
    }

    # data access methods
    function TopLinkString($NewValue = NULL) {  return $this->AccessDBValue("TopLinkString", $NewValue);  }
    function TopLinkBeginLetter($NewValue = NULL) {  return $this->AccessDBValue("TopLinkBeginLetter", $NewValue);  }
    function TopLinkEndLetter($NewValue = NULL) {  return $this->AccessDBValue("TopLinkEndLetter", $NewValue);  }
    function AdminEmail($NewValue = NULL) {  return $this->AccessDBValue("AdminEmail", $NewValue);  }
    function PasswordMailSubject($NewValue = NULL) {  return $this->AccessDBValue("PasswordMailSubject", $NewValue);  }
    function PasswordMailBody($NewValue = NULL) {  return $this->AccessDBValue("PasswordMailBody", $NewValue);  }
    function PortalName($NewValue = NULL) {  return $this->AccessDBValue("PortalName", $NewValue);  }
    function DefaultActiveUI($NewValue = NULL) {  return $this->AccessDBValue("DefaultActiveUI", $NewValue);  }
    function CurrentTheme($NewValue = NULL) {  return $this->AccessDBValue("CurrentTheme", $NewValue);  }
    function DefaultCharacterSet($NewValue = NULL) {  return $this->AccessDBValue("DefaultCharacterSet", $NewValue);  }
    function SearchTermsRequired($NewValue = NULL) {  return $this->AccessDBValue("SearchTermsRequired", $NewValue);  }
    function AnnouncementsEnabled($NewValue = NULL) {  return $this->AccessDBValue("AnnouncementsEnabled", $NewValue);  }
    function ForumsEnabled($NewValue = NULL) {  return $this->AccessDBValue("ForumsEnabled", $NewValue);  }
    function AllowMultipleUIsEnabled($NewValue = NULL) {  return $this->AccessDBValue("AllowMultipleUIsEnabled", $NewValue);  }
    function ResourceLaunchesNewWindowEnabled($NewValue = NULL) {  return $this->AccessDBValue("ResourceLaunchesNewWindowEnabled", $NewValue);  }
    function UserAgentsEnabled($NewValue = NULL) {  return $this->AccessDBValue("UserAgentsEnabled", $NewValue);  }
    function ResourceRatingsEnabled($NewValue = NULL) {  return $this->AccessDBValue("ResourceRatingsEnabled", $NewValue);  }
    function ResourceCommentsEnabled($NewValue = NULL) {  return $this->AccessDBValue("ResourceCommentsEnabled", $NewValue);  }
    function ReleaseFlagApproved($NewValue = NULL) {  return $this->AccessDBValue("ReleaseFlagApproved", $NewValue);  }
    function SearchDBEnabled($NewValue = NULL) {  return $this->AccessDBValue("SearchDBEnabled", $NewValue);  }
    function RecommenderDBEnabled($NewValue = NULL) {  return $this->AccessDBValue("RecommenderDBEnabled", $NewValue);  }
    function NumAnnounceOnHomePage($NewValue = NULL) {  return $this->AccessDBValue("NumAnnounceOnHomePage", $NewValue);  }
    function NumResourcesOnHomePage($NewValue = NULL) {  return $this->AccessDBValue("NumResourcesOnHomePage", $NewValue);  }
    function LegalNotice($NewValue = NULL) {  return $this->AccessDBValue("LegalNotice", $NewValue);  }
    function NumClassesPerBrowsePage($NewValue = NULL) 
    {  
        # if new classes per browse page has been specified
        if (isset($NewValue) && ($NewValue != $this->NumClassesPerBrowsePage))
        {
            # clear all classification links
            $this->TopLinkString("");
            $DB =& new SPTDatabase();
            $DB->Query("UPDATE Classifications SET LinkString=''");
        }

        return $this->AccessDBValue("NumClassesPerBrowsePage", $NewValue);  
    }
    function ClassificationTypeId($NewValue = NULL) {  return $this->AccessDBValue("ClassificationTypeId", $NewValue);  }
    function OaiIdDomain($NewValue = NULL) {  return $this->AccessDBValue("OaiIdDomain", $NewValue);  }
    function OaiIdPrefix($NewValue = NULL) {  return $this->AccessDBValue("OaiIdPrefix", $NewValue);  }
    function OaiEarliestDate($NewValue = NULL) {  return $this->AccessDBValue("OaiEarliestDate", $NewValue);  }
    function OaiDateGranularity($NewValue = NULL) {  return $this->AccessDBValue("OaiDateGranularity", $NewValue);  }
    function AboutText($NewValue = NULL) { return $this->AccessDBValue("AboutText", $NewValue); }

    function ContactName($NewValue = NULL) { return $this->AccessDBValue("ContactName", $NewValue); }
    function ContactEmail($NewValue = NULL) { return $this->AccessDBValue("ContactEmail", $NewValue); }
    function Organization($NewValue = NULL) { return $this->AccessDBValue("Organization", $NewValue); }
    function OrganizationType($NewValue = NULL) { return $this->AccessDBValue("OrganizationType", $NewValue); }
    function SiteType($NewValue = NULL) { return $this->AccessDBValue("SiteType", $NewValue); }
    function OkayToListSite($NewValue = NULL) { return $this->AccessDBValue("OkayToListSite", $NewValue); }
    function LastRegisteredOn($NewValue = NULL) { return $this->AccessDBValue("LastRegisteredOn", $NewValue); }

    function LogoFileName() {  return $this->LogoFileName;  }
    function LogoAltText() {  return $this->LogoAltText;  }
    function LogoWidth() {  return $this->LogoWidth;  }
    function LogoHeight() {  return $this->LogoHeight;  }

    function HasRegistered() {  return strlen($this->LastRegisteredOn) ? TRUE : FALSE;  }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $TopLinkString;
    var $TopLinkBeginLetter;
    var $TopLinkEndLetter;
    var $AdminEmail;
    var $PasswordMailSubject;
    var $PasswordMailBody;
    var $PortalName;
    var $DefaultActiveUI;
    var $CurrentTheme;
    var $DefaultCharacterSet;
    var $NumClassesPerBrowsePage;
    var $ClassificationTypeId;
    var $SearchTermsRequired;
    var $AnnouncementsEnabled;
    var $ForumsEnabled;
    var $AllowMultipleUIsEnabled;
    var $ResourceLaunchesNewWindow;
    var $UserAgentsEnabled;
    var $ResourceRatingsEnabled;
    var $ResourceCommentsEnabled;
    var $ReleaseFlagApproved;
    var $SearchDBEnabled;
    var $RecommenderDBEnabled;
    var $NumAnnounceOnHomePage;
    var $NumResourcesOnHomePage;
    var $LegalNotice;
    var $OaiIdDomain;
    var $OaiIdPrefix;
    var $OaiEarliestDate;
    var $OaiDateGranularity;
    var $LogoFileName;
    var $LogoAltText;
    var $LogoWidth;
    var $LogoHeight;
    var $AboutText;
    var $ContactName;
    var $ContactEmail;
    var $Organization;
    var $OrganizationType;
    var $SiteType;
    var $OkayToListSite;
    var $LastRegisteredOn;

    function AccessDBValue($FieldName, $NewValue)
    {
        # if new value was passed in
        if ($NewValue !== NULL)
        {
            # set our copy to new value
            $this->{$FieldName} = $NewValue;

            # save new value in database
            $DB =& new SPTDatabase();
            if (is_string($NewValue))
            {
                $DB->Query("UPDATE SystemConfiguration SET "
                        .$FieldName."='".addslashes($NewValue)."' ");
            }
            else
            {
                $DB->Query("UPDATE SystemConfiguration SET "
                        .$FieldName."=".$NewValue." ");
            }
        }

        # pass current value back to caller
        return $this->{$FieldName};
    }
}


?>
