﻿// Settings variables
var Prefix        = "Suggestions";              // The prefix applied to the names of the results
var TextPrefix    = "ST_";              // The prefix applied to the text that appears when a search is complete
var Searching     = "SuggestInputSearch";       // The class name applied to the input when searching
var InputError    = "SuggestInputError";        // The class name applied to the text box upon error
var Inner         = "SuggestResultsInner";      // The class name applied to the results
var InnerMessage  = "SuggestResultsMessage";    // The class name applied to messages
var InnerHover    = "SuggestResultsInnerHover"; // The class name applied when hovering over a result
var InnerError    = "SuggestResultsError";      // The class name applied to suggest errors
var ContainerName = "SuggestResultsTop";        // The name of the results container
var TypeAhead     = true; // (De)Activates the type ahead functionality
var Delay         = true; // (De)Activates the typing delay
var SuggestDelay  = 800;  // The amount of delay (milliseconds) between key presses before the AJAX request is sent
var MinimumLength = 2;    // The minimum length allowed for a search query
var BorderWidth   = 1;    // The border width of the results layer

///// Nothing below this line should need editing -----

// Initialize variables
var PreviousTime     = null; // Stores the last time the suggest function was called
var DelayTimeout     = null; // The delay timeout used to delay the AJAX requests
var SelectedResult   = null; // The currently selected result
var HaltSafari       = null; // Fixes the Safari bug, which duplicates the navigation event
var OriginalValue    = null; // Stores the original value of the input box
var Length           = null; // Stores length values
var TextContainer    = null; // Stores the current text container after searching
var Position         = [];   // Stores position values
var Size             = [];   // Stores size values
var Results          = [];   // Stores the results
//var ResultsContainer = new GetElement("SuggestResultsTop"); // The element that holds the results

function Suggest(Element)
{
    // Get all of the necessary variables
    var FieldId   = Element.getAttribute("FieldId");
    var FieldName = Element.getAttribute("FieldName");
    var InputId   = Element.getAttribute("InputId");
    var Code      = KeyCode; // To preserve the original key code value
    var MainForm  = Element.parentNode.parentNode.parentNode.parentNode.parentNode; // The main form
    ResultsContainer = new GetElement(ContainerName);

    // Disables form submit on ENTER, if not already applied. For Macs
    if (MainForm.onsubmit === null || MainForm.onsubmit === undefined)
    {
        DisableOnSubmit(MainForm);
    }
    
    // Apply the onfocus function, if not already applied
    if (Element.onfocus === undefined)
    {
        Element.onfocus = function()
            {
                if (RemovePadding(Element.value) !== "")
                {
                    DisableOnSubmit(MainForm);
                }
            };
    }

    // Apply the onblur function to re-enable the form
    Element.onblur = function()
        {                                                        
            // Hide the results and re-allow form submissions
            HideElement(ResultsContainer);
            Element.parentNode.parentNode.parentNode.parentNode.parentNode.onsubmit = null;
        };
    

    // If ENTER or any navigation buttons are pressed
    if (Code == 13 || (Code > 36 && Code < 41))
    {
        // Fix for Safari navigation bug
        if (HaltSafari === true){return false;}
        HaltSafari = true;
        setTimeout(function(){HaltSafari = false;}, 1);
        
        if (Code === 13 && CheckForWaste(RemovePadding(Element.value)) === false) // ENTER pressed
        {
            // Set the classification and reset the selected result
            if (ResultsContainer.style.display == "none" || SelectedResult === null)
            {
                SetClassification(Element.value, Element, InputId, FieldName);
            }
            else
            {
                SetClassification(SelectedResult.innerHTML, Element, InputId, FieldName);
            }
            SelectedResult = new GetElement(Prefix + "0");
        }
        else if (Code === 38) // Up arrow pressed
        {
            // Position the cursor at the end. For proper positioning on Macs
            Element.select();

            // If a higher-level result exists
            if (SelectedResult.previousSibling)
            {
                // Change the classes, hover on the previous result
                SetElementClass(SelectedResult, Inner);
                SetElementClass(SelectedResult.previousSibling, InnerHover);

                // Get the new selected result and set the input equal to it
                SelectedResult = SelectedResult.previousSibling;
                Element.value = SelectedResult.innerHTML;
            }
            else // Restore the original value if up is pressed on the first result
            {
                Element.value = OriginalValue;
            }
        }
        else if (Code === 40) // Down arrow
        {
            if (SelectedResult.nextSibling) // If a lower-level result exists
            {
                // Change the classes, hover on the next result
                SetElementClass(SelectedResult, Inner);
                SetElementClass(SelectedResult.nextSibling, InnerHover);

                // Get the new selected result and set the input equal to it
                SelectedResult = SelectedResult.nextSibling;
                Element.value = SelectedResult.innerHTML;
            }
        }
        return;
    }
    else if (CheckForWaste(RemovePadding(Element.value)) === true) // Check for wasteful queries
    {
        // Hide the results and remove the class of the input box
        HideElement(ResultsContainer);
        SetElementClass(Element, "");
        return;
    }
    // If the current value, minus padding whitespace, is not equal to the previous value
    else if (RemovePadding(Element.value) != OriginalValue)
    {
        // To reduce useless AJAX requests, run only after a delay if enabled
        if (Delay === true)
        {
            var CurrentTime = new Date();
            CurrentTime     = CurrentTime.getTime();
            if ((PreviousTime + SuggestDelay) > CurrentTime)
            {
                // Set the new previous time
                PreviousTime = CurrentTime;
                
                // Variable is used to reset the timeout
                DelayTimeout = setTimeout(function(){Suggest(Element);}, SuggestDelay);
                return;
            }
            clearTimeout(DelayTimeout);
        }
        
        // The AJAX request to the remote file
        SendRequest("SPT--AJAXDropdown.php", "Action=Classification&Argument=" + Element.value +
            "&FieldId=" + FieldId, function(Response)
            {
                // Set the searching class of the input box and get its original value
                SetElementClass(Element, Searching);
                OriginalValue = Element.value;
                    
                if (Response.indexOf("|") != -1)
                {
                    // Get the orginal input length, set the response to an array, and clear the results
                    Length = Element.value.length;
                    Results = Response.split("|");
                    ResultsContainer.innerHTML = "";
                    
                    // Loop through the response and put it into the results container with formatting
                    for (var i = 0; Results[i]; i++)
                    {
                        if (Results[i].charAt(0) == "~")
                        {
                            Results[i] = Results[i].substr(1);
                            ResultsContainer.innerHTML += "<li name='" + Prefix + i + "' id='" + Prefix + i + 
                                "' class='" + InnerMessage + "'>" + Results[i] + "</li>";
                        }
                        else
                        {
                            ResultsContainer.innerHTML += "<li name='" + Prefix + i + "' id='" + Prefix + i + 
                                "' class='" + Inner + "'>" + Results[i] + "</li>";
                        }
                    }

                    // Set a variable equal to the first result
                    var FirstResult = GetElement(Prefix + "0");
                    
                    // If type-ahead is enabled and a letter is pressed
                    if (TypeAhead !== false && (Code > 46 && Code < 112) || (Code > 123))
                    {                       
                        // Determines if the first result and what is typed are similar
                        if (Element.value.substr(0, Length) == FirstResult.innerHTML.substr(0,Length))
                        {
                            // Set the input equal to the first result
                            Element.value = FirstResult.innerHTML;
                            
                            // Select the additions
                            SelectInputText(Element, Length, Element.value.length);
                        }
                        
                        // Stops the cursor from repositioning to the end of the input box
                        TypeAhead = false;
                        setTimeout(function(){TypeAhead = true;}, SuggestDelay);
                    }
                    
                    // The next three functions overcome bugs
                    SetClassEvent(Inner, "mousedown", function()
                        {
                            SetClassification(this.innerHTML, Element, InputId, FieldName);
                        }
                    );
                    
                    SetClassEvent(Inner, "mouseover", function()
                        {
                            SetElementClass(this, InnerHover);
                        }
                    );
                    
                    SetClassEvent(Inner, "mouseout", function()
                        {
                            // If the hovered result isn't already selected
                            if (this.getAttribute("name") != SelectedResult.getAttribute("id"))
                            {
                                SetElementClass(this, Inner);
                            }
                        }
                    );

                    // Set the class of the first result
                    SetElementClass(FirstResult, InnerHover);
                    
                    // Set the position/width (equal to the input box) and show the results container
                    Position = new GetElementPosition(Element);
                    Size     = new GetElementSize(Element);
                    ResultsContainer.style.width = (Size.Width - BorderWidth * 2) + "px";
                    ResultsContainer.style.top   = (Position.Top + Size.Height) + "px";
                    ResultsContainer.style.left  = Position.Left + "px";
                    ShowElement(ResultsContainer);

                    // Reset to the default
                    SelectedResult = GetElement(Prefix + "0");
                    
                    // Show the results and remove the class from the input
                    SetElementClass(Element.name, "");
                }
                else if (Response !== "") // If an error was returned
                {
                    // Set the class and HTML of the results container
                    SetElementClass(Element, InputError);
                    ResultsContainer.innerHTML = "<div class='" + InnerError + "'>" + Response + "</div>";
                    
                    // Set the position/width (equal to the input box) and show the results container
                    Position = new GetElementPosition(Element);
                    Size     = new GetElementSize(Element);
                    ResultsContainer.style.width = (Size.Width - BorderWidth * 2) + "px";
                    ResultsContainer.style.top   = (Position.Top + Size.Height) + "px";
                    ResultsContainer.style.left  = Position.Left + "px";
                    ShowElement(ResultsContainer);
                }
            }
        );
    }
}

function SetClassification(Classification, Element, InputId, FieldName)
{
    // Set the input box value. Get the text container and set its properties
    TextContainer           = new GetElement(TextPrefix + FieldName + InputId);
    Element.value           = Classification;
    TextContainer.innerHTML = Classification;
    
    // Hide the input box and show the text container
    HideElement(Element);
    TextContainer.style.display = "block";
    
    // Make the next input visible
    FieldHidden = new GetElement( FieldName + "Hidden" );
    if (FieldHidden.value == InputId)
    {
        FieldHidden.value = parseInt( FieldHidden.value ) + 1;
        Field = new GetElement( FieldName + FieldHidden.value );
        ShowElement(Field);
    }
    
    // Re-enable form submission, hide the results, and focus the next input
    Element.parentNode.parentNode.parentNode.parentNode.parentNode.onsubmit = null;
    HideElement(ResultsContainer);

    Element.nextSibling.nextSibling.focus();
}

//
function ApplyTextFunction(Element){
    var InputElement = new GetElement(Element.getAttribute("InputName")+
            Element.getAttribute("InputId"));
    InputElement.value = Element.innerHTML;
    ShowElement(InputElement);
    HideElement(Element);

    setTimeout(function(){InputElement.focus();}, 20);
}

// Apply the focus rules
function InputFocus(Element)
{
    // If the element is not blank, disable form submission
    if (RemovePadding(Element.value) !== ""){
        DisableOnSubmit(Element.parentNode.parentNode.parentNode.parentNode.parentNode);
    }
}

// Separates the checks from the "Suggest" function
function CheckForWaste(Text)
{
    // Checks to the element
    if (Text === "" || Text.length <= MinimumLength)
    {
        return true;
    }

    return false;
}

function DisableOnSubmit(Element)
{
    Element.onsubmit = function(){return false;};
}

// Compatible key code functions
WindowEvent = window.Event ? true : false;
if (WindowEvent)
{
    window.captureEvents(Event.KEYDOWN);
    window.onkeydown = GetKeyCode;
}
else
{
    document.onkeydown = GetKeyCode;
}
