<?php

#
#   FILE:  SPT--ExportDataExecute.php
#
#   FUNCTIONS PROVIDED:
#       ExportComplete()
#       PrintResourceCount()
#       PrintExportLink()
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# see if export is complete
function ExportComplete()
{
    global $Session;

    $ExportComplete = $Session->Get("ExportComplete");

    return ($ExportComplete == 1) ? true : false;
}

# print Resource Count
function PrintResourceCount()
{
    global $Session;

    print $Session->Get("ResourceCount");
}

# print link to downloadable exported file
function PrintExportLink()
{
    global $Session, $NavDirCorrection;

    print "<a href=\"".$NavDirCorrection.$Session->Get("FileName")."\">";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# eliminate an array element
function EliminateArrayElement($Array, $Indice)
{
   if (array_key_exists($Indice, $Array))
   {
       $temp = $Array[0];
       $Array[0] = $Array[$Indice];
       $Array[$Indice] = $temp;
       array_shift($Array);
      
       //reacomodamos índices
       for ($i = 0 ; $i < $Indice ; $i++)
       {
           $dummy = $Array[$i];
           $Array[$i] = $temp;
           $temp = $dummy;
       }
   }
   return $Array;
}

# init variables -- first time thru they will be null
function InitExportVars()
{
    global $ExportComplete, $FSeek, $ResourceCount, $TotalLineCount;
    global $InputLineCount;

    if (is_null($ExportComplete))
        $ExportComplete = 0;
    if (is_null($FSeek))
        $FSeek = 0;
    if (is_null($ResourceCount))
        $ResourceCount = 0;
    if (is_null($InputLineCount))
        $InputLineCount = 0;
    if (is_null($TotalLineCount))
        $TotalLineCount = 0;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $fpi, $fpo, $Session, $ExportComplete;
    global $User, $ResourceCount, $FSeek, $TotalLineCount;

    # build partial query for dynamic fields
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields();

    # write out the header line only on first time
    if (!empty($fpo) && $FSeek == 0)
    {
        $Header = NULL;   
        # loop through each field
        foreach ($Fields as $Field)
        {
            if ($Field->Enabled() && $Field->Type() != MDFTYPE_IMAGE)
            {
                $Header .= $Field->Name()."\t";
            }
        }
        # replace trailing tab with newline
        $Header = substr($Header, 0, strlen($Header)-1)."\n";
        fwrite($fpo, $Header);
    }

    $InputLineCount = 0;

    while (!feof($fpi) && $InputLineCount < 50 && $ExportComplete == 0)
    {
        $ResourceId = fgets($fpi, 4096);
        $FSeek += strlen($ResourceId);
        $ResourceId = trim($ResourceId);

        if (empty($ResourceId))
            break;
        
        $ResourceCount++;
        $InputLineCount++;

        # get the all the values for the resource
        $Resource = & new Resource($ResourceId);            
        $Result = $Resource->GetAsArray();

        # must iterate over each ControlledName, Option, and Classification
        $NotDoneYet = TRUE;
        while ($NotDoneYet)
        {
            $NotDoneYet = FALSE;
            $Record = NULL;
            
            # loop through each field
            foreach ($Fields as $Field)
            {
                if ($Field->Enabled())
                {
                    $FName = $Field->Name();

                    # skip images
                    if ($Field->Type() & MDFTYPE_IMAGE)
                    {
                        continue;
                    }
                    # process Dates
                    else if ($Field->Type() & MDFTYPE_DATE)
                    {
                        $Date = $Result["$FName"];
                        $Record .= $Date->Formatted();
                    }
                    # User fields
                    else if ($Field->Type() & MDFTYPE_USER)
                    {
                        $TempUser = $Result["$FName"];
                        $Record .= $TempUser->Get("UserName");
                    }
                    # Controlled names and options
                    else if ($Field->Type() & 
                        (MDFTYPE_CONTROLLEDNAME|MDFTYPE_OPTION))
                    {
                        if (count($Result["$FName"]) > 0)
                        {
                            $NotDoneYet = TRUE;
                            $Record .= array_pop($Result["$FName"]);
                        }
                    }
                    # Trees
                    else if ($Field->Type() & MDFTYPE_TREE)
                    {
                        if (count($Result["$FName"]) > 0)
                        {
                            $Class = array_pop($Result["$FName"]);
                            $NotDoneYet = TRUE;
                            $Record .= $Class->FullName();
                        }
                    }
                    else
                    {
                        # strip out linefeeds, carriage returns, and tabs
                        $DataValue = $Result["$FName"];
                        $DataValue = preg_replace("/([\t\r\n])/", " ", 
                                        $DataValue);
                        $Record .= $DataValue;
                    }
                }
                $Record .= "\t";
            }
            # replace last tab with a newline
            $Record = substr($Record, 0, strlen($Record)-1)."\n";
            if (!empty($fpo))
                fwrite($fpo, $Record);
        }
    }
}

# function to get list of matching files
function ListDir($DirPath, $Pattern)
{
    static $ResultArray = array();  

    $Handle = opendir($DirPath);
    while ($File = readdir($Handle))
    {
        if ($File == '.' || $File == '..')
            continue;
        if (is_dir($DirPath.$File))
            continue;
        else if (preg_match($Pattern, $File))
            $ResultArray[]=$DirPath.$File;
    }
    closedir($Handle);
    return $ResultArray;
}

# ----- MAIN -----------------------------------------------------------------

$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$ClassDB =& new SPTDatabase();

if (isset($_SERVER["PATH_TRANSLATED"])
        && strlen($_SERVER["PATH_TRANSLATED"]))
{
    $ScriptFileName = $_SERVER["PATH_TRANSLATED"];
}
elseif (isset($_SERVER["SCRIPT_FILENAME"])
        && strlen($_SERVER["SCRIPT_FILENAME"]))
{
    $ScriptFileName = $_SERVER["SCRIPT_FILENAME"];
}
elseif (isset($_SERVER["PATH_INFO"])
        && strlen($_SERVER["PATH_INFO"]))
{
    $ScriptFileName = $_SERVER["PATH_INFO"];
}
$TempDir = dirname($ScriptFileName).
            "/".$NavDirCorrection."TempStorage/";

# make sure destination dir exists 
if (!file_exists($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " doesn't exist.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Export Data", "SPT--ExportData.php");
    exit;
}

# make sure destination dir is writable
if (!is_writable($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " is not writable.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Export Data", "SPT--ExportData.php");
    exit;
}
    
# open import file for reading
$InputPath = $Session->Get("InputPath");
if (is_null($InputPath))    
{
    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";
}

if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

if ($Submit == "Cancel")
{
    PrintAutoRefreshPage("System Administration",$NavDirCorrection.
        "SPT--SysAdmin.php");
    exit;
}

# export all records, create new InputData file
if ($Submit == "Export All Resources")
{
    $RFactory = & new ResourceFactory();
    $Resources = $RFactory->GetItemIds();

    $fp = fopen($InputPath, "w");

    foreach ($Resources as $ResourceId)
    {
       fwrite($fp, $ResourceId."\n");
    }
    fclose($fp);
}

InitExportVars();

# open input file for reading
if (is_readable($InputPath))
{
    $fpi = fopen($InputPath, "r");
}
else
{
    $ErrorMessage = "Cannot open Resource ID Filename: $InputPath<br>";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Export Data", "SPT--ExportData.php");
    exit;
}

# open export path
$ExportPath = $Session->Get("ExportPath");
if (is_null($ExportPath))
{
    $FileName = "TempStorage/Metadata_".date("YmdHis").".txt";
    $ExportPath = dirname($ScriptFileName)."/".$NavDirCorrection.$FileName;

    # remove any old exported files
    $OldExportFiles = ListDir(dirname($ScriptFileName)."/".$NavDirCorrection.
        "TempStorage/", "/^Metadata_.*\.txt$/");

    if (is_array($OldExportFiles))
    {
        foreach ($OldExportFiles as $OldFile)
        {
            unlink($OldFile);
        }
    }
}

$fpo = fopen($ExportPath, "a");
if ($fpo == FALSE)
{
    $ErrorMessage = "Cannot open Export Filename: $ExportPath<br>";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Export Data", "SPT--ExportData.php");
    exit;
}

# seek to the next line
if ($FSeek > 0)
{
    fseek($fpi, $FSeek);
}

# the main work happenes here
DoWhileLoop();

if (feof($fpi))
{
    $ExportComplete = 1;
}

$Session->PassVariable("ExportComplete", $ExportComplete);
$Session->PassVariable("ResourceCount", $ResourceCount);
$Session->PassVariable("FileName", $FileName);
$Session->PassVariable("TotalLineCount", $TotalLineCount);
$Session->PassVariable("FSeek", $FSeek);
$Session->PassVariable("InputPath", $InputPath);
$Session->PassVariable("ExportPath", $ExportPath);

#  Time to auto-refresh?
if ($ExportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ExportDataExecute.php";
}

PageTitle("Export Data");
include("include/SPT--StandardHtmlPageLoad.php");

if ($ExportComplete == 1)
{
    fclose($fpi);
    fclose($fpo);
    unlink($InputPath);
}

?>
