<?PHP
#
#   FILE:  SPT--ForgottenPasswordComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("Axis--User.php");
require_once("Axis--UserFactory.php");
require_once("include/SPT--Common.php");
PageTitle("Password Assistance Request Completed");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# retrieve user name or e-mail address entered
$F_UserName = isset($_POST["F_UserName"]) ? $_POST["F_UserName"] 
        : (isset($_GET["UN"]) ? $_GET["UN"] : NULL);

# if e-mail address was entered
$UserFactory = new UserFactory($DB);
if (User::IsValidLookingEMailAddress($F_UserName))
{
    # use e-mail address field for search
    $SearchField = "EMail";
    $SearchString = User::NormalizeEMailAddress($F_UserName);
    $ErrorCode = "EMAILNOTFOUND";
}
# else if user name was entered
elseif (User::IsValidUserName($F_UserName))
{
    # use name field for search
    $SearchField = "UserName";
    $SearchString = User::NormalizeUserName($F_UserName);
    $ErrorCode = "NAMENOTFOUND";
}
else
{
    # set error code for no value supplied
    $ErrorCode = "INVALIDNAME";
}

# if search parameters found
if (isset($SearchField))
{
    # search for matching user
    $Users = $UserFactory->FindUsers(
            $SearchString, $SearchField, "CreationDate", 0, 1);
}
$TargetUser = (isset($Users) && count($Users)) ? array_pop($Users) : NULL;

# if matching user was found
if ($TargetUser)
{
    # get forgotten password message text
    $MailTemplate = $SysConfig->PasswordResetMailSubject()."\n"
            .$SysConfig->PasswordResetMailBody();

    # set up any needed substitutions to message text
    $ResetUrlParameters = "?UN=".urlencode($TargetUser->Get("UserName"))
            ."&RC=".$TargetUser->GetResetCode();
    $ResetUrl = str_replace("ForgottenPasswordComplete", "ResetPassword",
            $_SERVER["SCRIPT_URI"]).$ResetUrlParameters;
    $ManualResetUrl = str_replace("ForgottenPasswordComplete",
            "ManuallyResetPassword", $_SERVER["SCRIPT_URI"]);
    $OurSubstitutions = array(
            "X-PORTALNAME-X" => $SysConfig->PortalName(),
            "X-RESETURL-X" => $ResetUrl,
            "X-RESETPARAMETERS-X" => $ResetUrlParameters,
            "X-MANUALRESETURL-X" => $ManualResetUrl,
            );

    # send forgotten password e-mail to user
    $FromAddress = $SysConfig->PortalName()." <".$SysConfig->AdminEmail().">";
    $G_EMailSent = $TargetUser->SendEMail(
            $MailTemplate, $FromAddress, $OurSubstitutions);

    # set values for use in HTML
    $G_UsedUserName = ($SearchField == "UserName");
    $G_UserName = $SearchString;
    $G_EMailAddress = $SearchString;

    # proceed to our page telling user that e-mail was sent
    include("include/SPT--StandardHtmlPageLoad.php");
}
else
{
    # return to calling page with error information
    PrintAutoRefreshPage("Error in Requesting Password Assistance",
            "SPT--ForgottenPassword.php?EC=".$ErrorCode
                    ."&EV=".urlencode($F_UserName));
}


?>
