-- update SystemConfiguration for number of columns for browsing 
ALTER TABLE SystemConfiguration ADD COLUMN NumColumnsPerBrowsePage INT DEFAULT 2;

-- update SystemConfiguration for Accessibility Wizard
ALTER TABLE SystemConfiguration ADD COLUMN AccessibilityWizardEnabled INT(11) DEFAULT 1 AFTER ResourceCommentsEnabled;

-- UI / accessibility user preferences
CREATE TABLE UserUIPreferences(
    UserId                      INT NOT NULL,
    FontSize                    INT,
    FontTypeFace                TEXT,
    FontColor                   TEXT,
    BackgroundColor             TEXT,
    ColorAvoidanceFlags         INT,
    ContentDensity              INT,
    ContentView                 INT,
    AudioDescriptionLevel       INT,
    AudioDescriptionLanguage    TEXT,
    VisualDescriptionLanguage   TEXT,
    UseGraphicAlternatives      INT,
    SignLanguage                TEXT,
    CaptionType                 INT,
    CaptionRate                 INT DEFAULT 120,
    INDEX                       (UserId)
);
