<?php

#
#   FILE:  SPT--EditClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessageList()
#           - print any error messages from previous attempt to save changes
#       PrintClassSegmentName()
#       PrintClassFullName()
#       PrintClassId()
#           - print various attributes of the class being edited
#       OkayToDeleteClass()
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--Qualifier.php");

# print class segment name
function PrintClassSegmentName()
{
    global $Class;
    global $SysConfig;

    print(GetHtmlTranslatedString($Class->SegmentName()));
}

# print class full name
function PrintClassFullName()
{
    global $Class;
    print($Class->FullName());
}

# print class id
function PrintClassId()
{
    global $Class;
    print($Class->Id());
}

# return if ok to delete class (true) or not (false)
function OkayToDeleteClass()
{
    global $Class;
    return (($Class->ResourceCount() == 0) && ($Class->ChildCount() == 0))
            ? TRUE : FALSE;
}

# function to determine if field has itemlevelqualifiers or not
function UsesQualifiers()
{
    global $Class;
    $Schema = & new MetadataSchema();
    $Field = $Schema->GetField($Class->FieldId());

    return $Field->UsesQualifiers();
}

# print Qualifier option list
function PrintQualifierList()
{
    global $Class;

    $Schema = & new MetadataSchema();
    $Field = $Schema->GetField($Class->FieldId());

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        # get current qualifier
        $QualifierId = $Class->QualifierId();
        if (is_null($QualifierId) || $QualifierId == 0)
            $QualifierId = $Field->DefaultQualifier();

        PrintOptionList("F_QualifierId", $Items, $QualifierId,
            0, 1, NULL, false);
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = & new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier))
            print $Qualifier->Name();
    }
    else
        print "None";

}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------


PageTitle("Edit Classification");
$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_CLASSADMIN);

# retrieve class info from DB
$Class =& new Classification($_GET["ClassificationId"]);

include("include/SPT--StandardHtmlPageLoad.php");


$Session->UnregisterVariable("ErrorMessages");

?>
