<?PHP
#
#   FILE:  SPT--AccessPreferences.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Accessibility Preferences");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function UserWantsScreenEnhanceSettings()
{  
    global $User;
    
    if (($User->PrefFontSize() > 0)
        || (strlen($User->PrefFontTypeFace()))
        || (strlen($User->PrefFontColor()))
        || (strlen($User->PrefBackgroundColor()))
        || ($User->PrefColorAvoidanceFlags() > 0))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function UserWantsStructuralPresentationSettings()
{  
    global $User;
    
    if (($User->PrefContentDensity() > 0)
        || ($User->PrefContentView() > 0))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function UserWantsAlternativesToVisualSettings()
{  
    global $User;
    
    if (($User->PrefAudioDescriptionLevel() > UIPREF_AUDIODESCRIPTION_NONE)
        || (strlen($User->PrefAudioDescriptionLanguage()) && ($User->PrefAudioDescriptionLanguage() != "English"))
        || (strlen($User->PrefVisualDescriptionLanguage()) && ($User->PrefVisualDescriptionLanguage() != "English")))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function UserWantsAlternativesToTextSettings()
{  
    global $User;
    
    if ($User->PrefUseGraphicAlternatives()
        || (strlen($User->PrefSignLanguage()) && ($User->PrefSignLanguage() != "None")))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function UserWantsAlternativesToAuditorySettings()
{  
    global $User;
    
    if (($User->PrefCaptionType() > 0)
        || (($User->PrefCaptionRate() > 0) && ($User->PrefCaptionRate() != 120)))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if user is logged in
if ($User->IsLoggedIn() == FALSE) 
{  
    PrintAutoRefreshPage("Not Logged In", "SPT--Home.php");
    exit;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
