<?PHP

#
#   FILE:  SPT--EditSearchConfigComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SearchEngine.php");

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

# if we have a new synonym list
if (isset($_POST["F_SynonymList"]))
{
    # attempt to parse list
    $SynonymList = array();
    $Lines = explode("\n", $_POST["F_SynonymList"]);
    foreach ($Lines as $Line)
    {
        if (strchr($Line, "="))
        {
            list($Word, $SynonymText) = explode("=", $Line);
            $Word = trim($Word);
            if (!preg_match("/[^a-zA-Z0-9]+/", $Word))
            {
                $Synonyms = explode(",", $SynonymText);
                foreach ($Synonyms as $Synonym)
                {
                    $Synonym = trim($Synonym);
                    if (!preg_match("/[^a-zA-Z0-9]+/", $Synonym))
                    {
                        $SynonymList[$Word][] = $Synonym;
                    }
                }
            }
        }
    }

    # if we have synonym entries
    if (count($SynonymList))
    {
        # update synonym list in search engine
        $SearchEngine =& new SPTSearchEngine();
        $SearchEngine->SetAllSynonyms($SynonymList);
    }
}


# go to main system administration page
PrintAutoRefreshPage("Search Configuration Editing Complete",
        "SPT--SysAdmin.php");

?>
