<?php
#
#   FILE:  SPT--NewSavedSearch.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2005 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SavedSearch.php");

PageTitle("Save Search");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFrequencyOptionList()
{
    global $User;
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SEARCHFREQ_HOURLY);
    }
    PrintOptionList("F_SearchFreq", $FreqList, SEARCHFREQ_NEVER);
}

function PrintCriteria()
{
    global $SearchGroups;
    $CriteriaText = SavedSearch::GetSearchGroupsAsTextDescription($SearchGroups);
    print $CriteriaText;
}

function PrintFormUrl()
{
    global $SearchGroups;
    print("SPT--SavedSearch.php?".SavedSearch::TranslateSearchGroupsToUrlParameters($SearchGroups));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);

include("include/SPT--StandardHtmlPageLoad.php");

?>
