<?PHP
#
#   FILE:  SPT--RSS.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("Axis--RSS.php");
require_once("Axis--Database.php");
require_once("include/SPT--Common.php");
require_once("include/SPT--ResourceFactory.php");

# create RSS output object and set up channel values
$RSS = new RSS();

$DB =& new SPTDatabase();

$Today = getdate();
$Date = $Today['year']."-".$Today['mon']."-".$Today['mday'];

$Query = "Select * from RSSConfiguration";
$DB->Query($Query);

# only one entry
$Entry = $DB->FetchNextRowArray();

$SiteLink = OurBaseUrl()."SPT--Home.php";
$NumberOfEntriesToPublish = $Entry["EntriesToPublish"];
$RSS->AddChannel($Entry["ChannelTitle"], $SiteLink, $Entry["ChannelDescription"]);
$RSS->SetImage($Entry["ImageUrl"], $Entry["ImageTitle"], $Entry["ImageLink"],
        $Entry["ImageHeight"], $Entry["ImageWidth"], $Entry["ImageDescription"]);
$RSS->SetLanguage(isset($Entry["Language"]) ? $Entry["Language"] : NULL);
$RSS->SetCopyright(isset($Entry["CopyRight"]) ? $Entry["CopyRight"] : NULL);
$RSS->SetManagingEditor(isset($Entry["ManagingEditor"]) ? $Entry["ManagingEditor"] : NULL);
$RSS->SetWebmaster(isset($Entry["Webmaster"]) ? $Entry["Webmaster"] : NULL);
$RSS->SetPicsRating(isset($Entry["PicsRating"]) ? $Entry["PicsRating"] : NULL);
$RSS->SetPublicationDate($Date);

# set date of most recent update to resources
$ResourceFact =& new ResourceFactory();
$LastChangeTimestamp = $ResourceFact->GetTimestampOfLastResourceModification();
$RSS->SetLastChangeDate(date("Y-m-d", $LastChangeTimestamp));

# get resource info to publish
$Resources = $ResourceFact->GetRecentlyReleasedResources($NumberOfEntriesToPublish, 0, 3650);

# add resources to feed
foreach ($Resources as $Resource)
{
    $RSS->AddItem(strip_tags($Resource->Get("Title")), 
        "http://".$_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"])
            ."/SPT--FullRecord.php?ResourceId=".$Resource->Id(), 
        strip_tags($Resource->Get("Description")),
        $Resource->Get("Date of Record Release"));
}

# publish RSS page
$RSS->PrintRSS();

?>
