<?PHP

#
#   FILE:  SPT--RecommendResources.php
#
#   FUNCTIONS PROVIDED:
#       PrintRecommendations()
#           - print search results (calling PrintRecommendation() for the
#                   actual output
#       PrintTotalNumberOfResults()
#           - print total number of results returned by search
#       PrintStartingResultNumber()
#       PrintEndingResultNumber()
#           - print starting and ending number of currently displayed results
#       PreviousResultsAvailable()
#       NextResultsAvailable()
#           - return TRUE if this is not the first/last page of results
#       PrintPreviousResultsLink()
#       PrintNextResultsLink()
#           - print URL for previous or next page of results
#       PrintNumberOfPreviousResults()
#       PrintNumberOfNextResults()
#           - print number of results on previous/next results page
#       NoResultsFound()
#           - returns TRUE if no recommendations were found
#       PrintSearchTime()
#           - print time taken for search, in seconds
#       GetWhyRecommendLink()
#           - returns link text to page indicating why resource was recommended
#
#   FUNCTIONS EXPECTED:
#       PrintRecommendation($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - called by PrintRecommendations() to output each resource
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--Recommender.php");

ParseArguments();
PageTitle("Recommend Resources");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintRecommendations()
{
    global $Recommendations;
    global $User;
    global $CurrentResourceId;

    # make sure recommendations have been generated
    GetRecommendations();

    # for each recommended result
    foreach ($Recommendations as $ResourceId => $Score)
    {
        # export resource ID for use by other functions
        $CurrentResourceId = $ResourceId;

        # print entry
        $Resource =& new Resource($ResourceId);
        PrintRecommendation($Resource,
                "SPT--FullRecord.php?ResourceId=${ResourceId}",
                CheckEditResource( $Resource ),
                "MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
                $Resource->ScaledCumulativeRating());
    }
}

function GetWhyRecommendLink()
{
    global $CurrentResourceId;
    return "SPT--WhyRecommend.php?rr=${CurrentResourceId}";
}

function PrintTotalNumberOfResults()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print($Recommender->NumberOfResults());
}

function PrintStartingResultNumber()
{
    global $StartingResult;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    if ($Recommender->NumberOfResults() == 0)
    {
        print("0");
    }
    else
    {
        print($StartingResult + 1);
    }
}

function PrintEndingResultNumber()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print(min(($StartingResult + $ResultsPerPage), $Recommender->NumberOfResults()));
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    return (($StartingResult + $ResultsPerPage) < $Recommender->NumberOfResults()) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $SearchString;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);
    print("SPT--RecommendResources.php?sr=".$NewStartingResult);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $SearchString;

    $NewStartingResult = $StartingResult + $ResultsPerPage;
    print("SPT--RecommendResources.php?sr=".$NewStartingResult);
}

function NoResultsFound()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    return ($Recommender->NumberOfResults() == 0) ? TRUE : FALSE;
}

function PrintSearchTime()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    printf("%.3f", $Recommender->SearchTime());
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print(min($ResultsPerPage, ($Recommender->NumberOfResults() - ($StartingResult + $ResultsPerPage))));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function ParseArguments()
{
    global $_GET;
    global $StartingResult;
    global $ResultsPerPage;

    # grab starting result number if passed in
    if (isset($_GET["sr"]))
    {       
        $StartingResult = $_GET["sr"];
    }
    else
    {
        $StartingResult = 0;
    }

    # set results per page to a default for now
    $ResultsPerPage = 10;
}

function GetRecommendations()
{
    global $User;
    global $Recommender;
    global $Recommendations;
    global $StartingResult;
    global $ResultsPerPage;

    # bail out if we've already gotten recommendations
    static $AlreadyGotRecommendations;
    if ($AlreadyGotRecommendations) {  return;  }
    $AlreadyGotRecommendations = TRUE;

    # create recommender
    $Recommender = new SPTRecommender;

    # add filter function to return only released records
    $Recommender->AddResultFilterFunction("FilterRecommendationsForReleasedRecords");

    # get recommendations
    $Recommendations = $Recommender->Recommend($User->Get("UserId"),
            $StartingResult, $ResultsPerPage);
}

# filter the search results for only released records
function FilterRecommendationsForReleasedRecords($ResourceId)
{
    $Resource = & new Resource($ResourceId);
    return ($Resource->Get("ReleaseFlag") ? FALSE : TRUE);
}


# ----- MAIN -----------------------------------------------------------------

include("include/SPT--StandardHtmlPageLoad.php");

?>

