<?PHP
#
#   FILE:  SPT--Local--EXAMPLE.php
#
#   DESCRIPTION:
#     This file contains examples of functions that can be put into the file
#     include/SPT--Local.php and be called by the SPT code at appropriate points.
#
#   USAGE:
#     1) copy this file to include/SPT--Local.php
#     2) remove "EXAMPLE_" from the name of the function(s) you want to use
#     3) replace the code between the "EXAMPLE CODE" lines with your code
#
#   Part of CWIS and the Scout Portal Toolkit
#   Copyright 2006 Internet Scout
#   http://scout.wisc.edu
#


#
#    FUNCTION:  Local_SavedSearchKeywordReplacement()
# CALLED WHEN:  generating saved search e-mail messages
#
# NOTES:
#   - should return replacement text
#   - $ResourceId and $ResultNumber are supplied when the function is called
#       within a specific result
#   - $User is an SPTUser object representing the user receiving the e-mail
#
function EXAMPLE_Local_SavedSearchKeywordReplacement(
        $Keyword, $User, $Search, $ResourceId = NULL, $ResultNumber = NULL)
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # if keyword is the one we are looking for
    if ($Keyword == "X-OURKEYWORD-X")
    {
        # use our replacement text
        $Replacement = "Our Replacement";
    }
    else
    {
        # otherwise send back NULL to indicate that we don't have a replacement
        $Replacement = NULL;
    }

    # return replacement text to caller
    return $Replacement;
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


#
#    FUNCTION:  Local_GetOAIRetrievalSearchParameters()
# CALLED WHEN:  responding to OAI queries
#
# NOTES:
#   - should return array of one or more search conditions that resources have
#       to meet to be retrievable via OAI (conditions are ANDed together)
#   - array indices are field names and array values are values to search for
#   - prepend "=" to match an exact value
#   - prepend ">" or "<" to match relative values (only meaningful for numbers
#       and dates)
#   - syntax is the same as used for the OSMASE fielded search method (as in
#       part described above)
#
function EXAMPLE_Local_GetOAIRetrievalSearchParameters()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    return array(
            "Release Flag" => 1,
            "Language" => "=English",
            );
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


#
#    FUNCTION:  Local_GetDoNotReturnToPages()
# CALLED WHEN:  after logging user in
#
# NOTES:
#   - should return an array of one more more relative paths that the user
#       should NOT be sent to after logging in
#   - useful when setting up your own login or registration pages
#   - user will be sent to home page after logging in instead of these pages
#
function EXAMPLE_Local_GetDoNotReturnToPages()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    return array(
            "MY--LoginError",
            "MY--RegistrationComplete",
            );
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


#
#    FUNCTION:  Local_GetNewResources($MaxNumber, $Offset, $MaxDays)
# CALLED WHEN:  retrieving list of new resources to display on home page
#
# NOTES:
#   - should return an array of Resource objects with IDs as indexes
#   - useful to customize what gets displayed in "New Resources" column
#
function EXAMPLE_Local_GetNewResources($MaxNumber, $Offset, $MaxDays)
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # retrieve IDs of new resources
    $ResourceFactory =& new ResourceFactory();
    $NewResourceIds = $ResourceFactory->GetResourceIdsSortedBy(
            "Date of Record Release", FALSE, ($Offset + $MaxNumber));

    # load resource objects
    $Resources = array();
    $Index = 0;
    foreach ($NewResourceIds as $ResourceId)
    {
        if ($Index >= $Offset)
        {
            $Resources[$ResourceId] = new Resource($ResourceId);
        }
        $Index++;
    }

    # return resource objects to caller
    return $Resources;
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


#
#    FUNCTION:  Local_HourlyMaintenance()
# CALLED WHEN:  run hourly as part of maintenance
#
# NOTES:
#   - runs before any other maintenance task
#   - only runs if cron or some other mechanism is set up to call
#       hourly maintenance page ("SPT--HourlyMaint.php")
#   - should not produce any HTML output
#
function EXAMPLE_Local_HourlyMaintenance()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # (code to be run hourly goes here)
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}

#
#    FUNCTION:  Local_DailyMaintenance()
# CALLED WHEN:  run daily as part of maintenance
#
# NOTES:
#   - runs after hourly but before any other maintenance task
#   - only runs if cron or some other mechanism is set up to call
#       daily maintenance page ("SPT--DailyMaint.php")
#   - should not produce any HTML output
#
function EXAMPLE_Local_DailyMaintenance()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # (code to be run daily goes here)
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}

#
#    FUNCTION:  Local_WeeklyMaintenance()
# CALLED WHEN:  run weekly as part of maintenance
#
# NOTES:
#   - runs after hourly and daily but before any other maintenance task
#   - only runs if cron or some other mechanism is set up to call
#       weekly maintenance page ("SPT--WeeklyMaint.php")
#   - should not produce any HTML output
#
function EXAMPLE_Local_WeeklyMaintenance()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # (code to be run weekly goes here)
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


#
#    FUNCTION:  Local_CollectionStatistics()
# CALLED WHEN:  Metadata Tool page is displayed
#
# NOTES:
#   - intended to provide a seamless way to add additional collection
#       statistics to those displayed on the Metadata Tool home page
#   - should return an associative array with the statistics
#       as values and labels as keys
#   - should not produce any HTML output
#
function EXAMPLE_Local_CollectionStatistics()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    $MyStats = array(
            "Label for My First Stats" => "First Stats",
            "Label for My Second Stats" => "Second Stats",
            );
    return $MyStats;
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


?>
