<?PHP

#
#   FILE:  SPT--Privilege.php
#
#   METHODS PROVIDED:
#       Privilege()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Collection Workflow Integration System
#   Copyright 2007 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SPTDatabase.php");

class Privilege {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    # (pass in Name and NULL for $Id to create new privilege)
    function Privilege($Id, $Name = NULL)
    {
        global $G_PrivDescriptions;
    
        # if caller requested creation of new entry
        if ($Id === NULL)
        {
            # get highest current ID
            $DB = new SPTDatabase();
            $HighestId = $DB->Query("SELECT Id FROM CustomPrivileges"
                    ." ORDER BY Id DESC LIMIT 1", "Id");

            # select new ID
            $this->Id = max(100, ($HighestId + 1));

            # add new entry to database
            $DB->Query("INSERT INTO CustomPrivileges (Id, Name)"
                    ." VALUES (".$this->Id.", '".addslashes($Name)."')");
            $this->Name = $Name;
        }
        else
        {
            # save ID
            $this->Id = intval($Id);
    
            # if ID indicates predefined privilege
            if ($this->IsPredefined())
            {
                # load privilege info from predefined priv array
                $this->Name = $G_PrivDescriptions[$this->Id];
            }
            else
            {
                # load privilege info from database
                $DB = new SPTDatabase();
                $this->Name = $DB->Query("SELECT Name FROM CustomPrivileges"
                        ." WHERE Id = ".$this->Id, "Name");
            }
        }
    }

    # get/set attributes
    function Id() {  return $this->Id;  }
    function Name($NewValue = NULL)
    {  
        if (($NewValue !== NULL) && !$this->IsPredefined())
        {
            $DB = new SPTDatabase();
            $DB->Query("UPDATE CustomPrivileges"
                    ." SET Name = '".addslashes($NewValue)."'"
                    ." WHERE Id = ".$this->Id);
            $this->Name = $NewValue;
        }
        return $this->Name;
    }

    # report whether privilege is predefined or custom
    # (may be called statically with ID)
    function IsPredefined($Id = NULL)
    {
        if ($Id === NULL)
        {
            $Id = $this->Id;
        }
        return ($Id < 100) ? TRUE : FALSE;
    }

    # delete privilege
    # (NOTE: object should not be used after calling this method!)
    function Delete()
    {
        if (!$this->IsPredefined())
        {
            $DB = new SPTDatabase();
            $DB->Query("DELETE FROM CustomPrivileges"
                    ." WHERE Id = ".$this->Id);
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Id;
    var $Name;
}


?>
