<?PHP
#
#   FILE:  SPT--DownloadFile.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2007 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--File.php");
require_once("include/SPT--Resource.php");

# if file ID was supplied
if (isset($_GET["Id"]))
{
    # load file info
    $File = new File(intval($_GET["Id"]));

    # if file info was loaded successfully
    if ($File->Status() == FILESTAT_OK)
    {
        # if user can view file
        $Field = new MetadataField($File->FieldId());
        $Resource = new Resource($File->ResourceId());
        if ($Resource->UserCanViewField($User, $Field))
        {
            # set headers to download file
            header("Content-disposition: attachment; filename=\""
                    .addslashes($File->Name())."\"");
            header("Content-type: ".$File->GetMimeType());

            # send file to user
            readfile($File->GetNameOfStoredFile());
            exit(0);
        }
        else
        {
            include("include/SPT--UnauthorizedAccess.php");
            exit(0); 
        }
    }
}

?>
