<?PHP

#
#   FILE:  SPT--QualifierFactory.php
#
#   METHODS PROVIDED:
#       QualifierFactory()
#           - constructor
#       QualifierList()
#           - return list of all qualifiers
#       QualifierCount()
#           - return count of qualifiers
#       QualifierNameIsInUse($Name)
#           - return whether qualifier name is in use
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--Common.php");
require_once(dirname(__FILE__)."/SPT--Qualifier.php");


class QualifierFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function QualifierFactory()
    {
        # create database handle for our use
        $this->DB =& new SPTDatabase();
    }
    
    # return list of all qualifiers
    function QualifierList()
    {
        # retrieve list of qualifiers
        $this->DB->Query("SELECT QualifierId, QualifierName FROM Qualifiers"
                ." ORDER BY QualifierName");
        return $this->DB->FetchColumn("QualifierName", "QualifierId");
    }
    
    # return count of qualifiers
    function QualifierCount()
    {
        # retrieve count of qualifiers
        return $this->DB->Query("SELECT COUNT(*) AS RecordCount FROM Qualifiers",
                "RecordCount");
    }
    
    # return whether qualifier name is in use
    function QualifierNameIsInUse($Name)
    {
        # query whether name is in use
        $RecordCount = $this->DB->Query("SELECT COUNT(*) AS RecordCount FROM Qualifiers"
               ." WHERE UPPER(QualifierName) = '".addslashes(strtoupper($Name))."'",
               "RecordCount");
        
        # return result to caller
        return ($RecordCount > 0) ? TRUE : FALSE;
    }

    # retrieve qualifier by name
    function GetQualifierByName($QualifierName)
    {
        # query database for qualifier ID
        $QualifierId = $this->DB->Query("SELECT QualifierId FROM Qualifiers"
               ." WHERE QualifierName = '".addslashes($QualifierName)."'",
               "QualifierId");

        # create qualifier object and return to caller
        return new Qualifier($QualifierId);
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
}


?>
